/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.query;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import thredds.catalog.JaxpFactory;
import thredds.catalog.query.DqcConvertIF;
import thredds.catalog.query.QueryCapability;

public class DqcFactory {
    public static boolean debugURL = false;
    public static boolean debugVersion = false;
    public static boolean showParsedXML = false;
    private DocumentBuilder builder;
    private DqcConvertIF defaultConverter;
    private HashMap versionHash = new HashMap(10);
    private StringBuffer warnMessages;
    private StringBuffer errMessages;
    private StringBuffer fatalMessages;

    public DqcFactory(boolean validate) {
        JaxpFactory jaxp = new JaxpFactory(validate);
        this.builder = jaxp.getDocumentBuilder();
        this.warnMessages = jaxp.getWarningMessages();
        this.errMessages = jaxp.getErrorMessages();
        this.fatalMessages = jaxp.getFatalMessages();
        this.setDefaults();
    }

    private void setDefaults() {
        try {
            Class<?> fac2 = Class.forName("thredds.catalog.parser.jdom.DqcConvert2");
            Object fac2o = fac2.newInstance();
            this.registerConverter("http://www.unidata.ucar.edu/schemas/thredds/queryCapability", (DqcConvertIF)fac2o);
            Class<?> fac3 = Class.forName("thredds.catalog.parser.jdom.DqcConvert3");
            Object fac3o = fac3.newInstance();
            this.defaultConverter = (DqcConvertIF)fac3o;
            this.registerConverter("http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.3", (DqcConvertIF)fac3o);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("DqcFactory: no implementing class found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("DqcFactory: instantition failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("DqcFactory: access failed: " + e.getMessage());
        }
    }

    private void registerConverter(String namespace, DqcConvertIF converter) {
        this.versionHash.put(namespace, converter);
    }

    public void appendErr(String err) {
        this.errMessages.append(err);
    }

    public void appendFatalErr(String err) {
        this.fatalMessages.append(err);
    }

    public void appendWarning(String err) {
        this.warnMessages.append(err);
    }

    public QueryCapability readXML(String uriString) throws IOException, MalformedURLException {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.parse(uriString);
        }
        catch (SAXException e) {
            this.fatalMessages.append(e.getMessage());
        }
        return this.readXML(doc, uri);
    }

    public QueryCapability readXML(InputStream docIs, URI uri) throws IOException {
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.parse(docIs);
        }
        catch (SAXException e) {
            this.fatalMessages.append(e.getMessage());
        }
        return this.readXML(doc, uri);
    }

    public QueryCapability readXML(Document doc, URI uri) throws IOException {
        if (doc == null) {
            QueryCapability dqc = new QueryCapability();
            if (this.fatalMessages.length() > 0) {
                dqc.appendErrorMessage(this.fatalMessages.toString(), true);
            }
            if (this.errMessages.length() > 0) {
                dqc.appendErrorMessage(this.errMessages.toString(), false);
            }
            if (this.errMessages.length() > 0) {
                dqc.appendErrorMessage(this.warnMessages.toString(), false);
            }
            return dqc;
        }
        Element root = doc.getDocumentElement();
        String namespace = root.getNamespaceURI();
        DqcConvertIF fac = (DqcConvertIF)this.versionHash.get(namespace);
        if (fac == null) {
            fac = this.defaultConverter;
            if (debugVersion) {
                System.out.println("use default converter " + fac.getClass().getName() + "; no namespace " + namespace);
            }
        } else if (debugVersion) {
            System.out.println("use converter " + fac.getClass().getName() + " based on namespace " + namespace);
        }
        QueryCapability dqc = fac.parseXML(this, doc, uri);
        if (this.fatalMessages.length() > 0) {
            dqc.appendErrorMessage(this.fatalMessages.toString(), true);
        }
        if (this.errMessages.length() > 0) {
            dqc.appendErrorMessage(this.errMessages.toString(), false);
        }
        if (this.errMessages.length() > 0) {
            dqc.appendErrorMessage(this.warnMessages.toString(), false);
        }
        return dqc;
    }

    public String writeXML(QueryCapability dqc) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML(dqc, os);
        return os.toString();
    }

    public void writeXML(QueryCapability dqc, OutputStream os) throws IOException {
        this.defaultConverter.writeXML(dqc, os);
    }

    public boolean writeXML(QueryCapability dqc, String filename) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
            this.writeXML(dqc, os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void doOne(DqcFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            QueryCapability dqc = fac.readXML(url);
            System.out.println(" dqc hasFatalError= " + dqc.hasFatalError());
            System.out.println(" dqc messages= \n" + dqc.getErrorMessages());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        DqcFactory fac = new DqcFactory(true);
        DqcFactory.doOne(fac, "file:///C:/dev/thredds/catalog/test/data/dqc/zoneDQC.xml");
        DqcFactory.doOne(fac, "file:///C:/dev/thredds/catalog/test/data/dqc/zoneDQCinvalid.xml");
    }
}

