/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import thredds.catalog.DataType;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetImplProxy;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;

public class InvCatalogFactory6
implements InvCatalogConvertIF,
MetadataConverterIF {
    private static final String dtdDefault = "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd";
    private static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/thredds");
    private static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private InvCatalogFactory factory;
    private DOMBuilder builder = new DOMBuilder();
    private DOMOutputter domOut = null;
    private HashMap metadataHash = new HashMap(10);

    public InvCatalogImpl parseXML(InvCatalogFactory fac, org.w3c.dom.Document domDoc, URI uri) {
        this.factory = fac;
        Document doc = this.builder.build(domDoc);
        if (InvCatalogFactory.showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** catalog/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        InvCatalogImpl catalog = this.readCatalog(doc.getRootElement(), uri);
        return catalog;
    }

    public void registerMetadataConverter(MetadataType type, MetadataConverterIF converter) {
        this.metadataHash.put(type, converter);
    }

    protected InvAccessImpl readAccess(InvDatasetImpl dataset, Element accessElem) {
        String urlPath = accessElem.getAttributeValue("urlPath");
        String serviceName = accessElem.getAttributeValue("serviceName");
        String serviceType = accessElem.getAttributeValue("serviceType");
        InvAccessImpl access = new InvAccessImpl(dataset, urlPath, serviceName, serviceType, null, 0.0);
        return access;
    }

    protected InvCatalogImpl readCatalog(Element catalogElem, URI baseURI) {
        String name = catalogElem.getAttributeValue("name");
        String version = catalogElem.getAttributeValue("version");
        InvCatalogImpl catalog = new InvCatalogImpl(name, version, baseURI);
        Element dsElement = catalogElem.getChild("dataset", defNS);
        if (dsElement == null) {
            InvCatalogImpl cat = new InvCatalogImpl(baseURI.toString(), version, baseURI);
            cat.appendErrorMessage("** InvCatalogFactory6.readXML no top dataset element; URL= (" + baseURI.toString() + ")\n", true);
            return cat;
        }
        InvDatasetImpl topDataset = this.readDataset(catalog, null, dsElement, baseURI);
        catalog.addDataset(topDataset);
        topDataset.setCatalog(catalog);
        return catalog;
    }

    protected InvCatalogRef readCatalogRef(InvDatasetImpl parent, Element catRefElem) {
        String title = catRefElem.getAttributeValue("title", xlinkNS);
        String href = catRefElem.getAttributeValue("href", xlinkNS);
        InvCatalogRef catRef = new InvCatalogRef(parent, title, href);
        List docList = catRefElem.getChildren("documentation", defNS);
        for (int j = 0; j < docList.size(); ++j) {
            InvDocumentation doc = this.readDocumentation(parent.getParentCatalog(), (Element)docList.get(j));
            catRef.addDocumentation(doc);
        }
        return catRef;
    }

    protected InvDatasetImpl readDataset(InvCatalogImpl catalog, InvDatasetImpl parent, Element dsElem, URI base) {
        List properties;
        String name = dsElem.getAttributeValue("name");
        String alias = dsElem.getAttributeValue("alias");
        if (alias != null) {
            InvDatasetImpl ds = (InvDatasetImpl)catalog.findDatasetByID(alias);
            if (ds == null) {
                this.factory.appendErr(" ** Parse error: dataset named " + name + " has illegal alias = " + alias + "\n");
            }
            return new InvDatasetImplProxy(name, ds);
        }
        String dataTypeName = dsElem.getAttributeValue("dataType");
        String authority = dsElem.getAttributeValue("authority");
        String id = dsElem.getAttributeValue("ID");
        String serviceName = dsElem.getAttributeValue("serviceName");
        String urlPath = dsElem.getAttributeValue("urlPath");
        DataType dataType = null;
        if (dataTypeName != null && (dataType = DataType.getType(dataTypeName)) == null) {
            dataType = new DataType(dataTypeName);
            this.factory.appendWarning(" ** warning: non-standard data type = " + dataTypeName);
        }
        InvDatasetImpl dataset = new InvDatasetImpl(parent, name, null, null, urlPath);
        if (id != null) {
            dataset.setID(id);
        }
        catalog.addDatasetByID(dataset);
        List serviceList = dsElem.getChildren("service", defNS);
        for (int j = 0; j < serviceList.size(); ++j) {
            InvService s = this.readService((Element)serviceList.get(j), base);
            dataset.addService(s);
        }
        ThreddsMetadata tmg = dataset.getLocalMetadata();
        List list = dsElem.getChildren("documentation", defNS);
        for (int j = 0; j < list.size(); ++j) {
            InvDocumentation doc = this.readDocumentation(catalog, (Element)list.get(j));
            tmg.addDocumentation(doc);
        }
        List mList = dsElem.getChildren("metadata", defNS);
        for (int j = 0; j < mList.size(); ++j) {
            InvMetadata m = this.readMetadata(catalog, dataset, (Element)mList.get(j));
            if (m == null) continue;
            tmg.addMetadata(m);
        }
        List aList = dsElem.getChildren("access", defNS);
        for (int j = 0; j < aList.size(); ++j) {
            InvAccessImpl a = this.readAccess(dataset, (Element)aList.get(j));
            dataset.addAccess(a);
        }
        List allChildren = dsElem.getChildren();
        for (int j = 0; j < allChildren.size(); ++j) {
            InvDatasetImpl ds;
            Element e = (Element)allChildren.get(j);
            if (e.getName().equals("dataset")) {
                ds = this.readDataset(catalog, dataset, e, base);
                dataset.addDataset(ds);
                continue;
            }
            if (!e.getName().equals("catalogRef")) continue;
            ds = this.readCatalogRef(dataset, e);
            dataset.addDataset(ds);
        }
        ThreddsMetadata tmgi = dataset.getLocalMetadataInherited();
        if (dataTypeName != null) {
            tmgi.setDataType(DataType.getType(dataTypeName));
        }
        if (serviceName != null) {
            tmgi.setServiceName(serviceName);
        }
        if (authority != null) {
            tmgi.setAuthority(authority);
        }
        if ((properties = dsElem.getChildren("property", defNS)).size() > 0) {
            for (int j = 0; j < properties.size(); ++j) {
                InvProperty p = this.readProperty((Element)properties.get(j));
                tmgi.addProperty(p);
            }
        }
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Dataset added: " + dataset.dump());
        }
        return dataset;
    }

    protected InvDocumentation readDocumentation(InvCatalog catalog, Element s) {
        String href = s.getAttributeValue("href", xlinkNS);
        String title = s.getAttributeValue("title", xlinkNS);
        String content = s.getTextNormalize();
        URI uri = null;
        if (href != null) {
            try {
                uri = catalog.resolveUri(href);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid documentation href = " + href + " " + e.getMessage());
            }
        }
        InvDocumentation doc = new InvDocumentation(href, uri, title, null, content);
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Documentation added: " + doc);
        }
        return doc;
    }

    protected InvMetadata readMetadata(InvCatalog catalog, InvDatasetImpl dataset, Element mdataElement) {
        String mtype = mdataElement.getAttributeValue("metadataType");
        String href = mdataElement.getAttributeValue("href", xlinkNS);
        String title = mdataElement.getAttributeValue("title", xlinkNS);
        boolean inherited = false;
        boolean isThreddsNamespace = mtype == null || mtype.equals("THREDDS");
        MetadataConverterIF metaConverter = this.factory.getMetadataConverter(mtype);
        if (metaConverter != null) {
            Object contentObj = null;
            if (href == null) {
                contentObj = metaConverter.readMetadataContent(dataset, this.toDOM(mdataElement));
                return new InvMetadata(dataset, mtype, null, null, inherited, false, metaConverter, contentObj);
            }
            return new InvMetadata(dataset, href, title, mtype, null, null, inherited, false, metaConverter);
        }
        if (href == null) {
            return new InvMetadata(dataset, mtype, null, null, inherited, false, this, mdataElement);
        }
        return new InvMetadata(dataset, href, title, mtype, null, null, inherited, false, null);
    }

    public Object readMetadataContentFromURL(InvDataset dataset, String urlString) {
        return null;
    }

    public Object readMetadataContent(InvDataset dataset, org.w3c.dom.Element mdataElement) {
        return null;
    }

    public void addMetadataContent(org.w3c.dom.Element mdataElement, Object contentObject) {
    }

    public boolean validateMetadataContent(Object contentObject, StringBuffer out) {
        return true;
    }

    public Object readMetadataContentFromURL(InvDataset dataset, URI uri) throws IOException {
        return null;
    }

    protected InvProperty readProperty(Element s) {
        String name = s.getAttributeValue("name");
        String value = s.getAttributeValue("value");
        InvProperty p = new InvProperty(name, value);
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Property added: " + p);
        }
        return p;
    }

    protected InvService readService(Element s, URI baseURI) {
        String name = s.getAttributeValue("name");
        String type = s.getAttributeValue("serviceType");
        String serviceBase = s.getAttributeValue("base");
        String suffix = s.getAttributeValue("suffix");
        InvService service = new InvService(name, type, serviceBase, suffix, null);
        List propertyList = s.getChildren("property", defNS);
        for (int j = 0; j < propertyList.size(); ++j) {
            InvProperty p = this.readProperty((Element)propertyList.get(j));
            service.addProperty(p);
        }
        List serviceList = s.getChildren("service", defNS);
        for (int j = 0; j < serviceList.size(); ++j) {
            InvService ss = this.readService((Element)serviceList.get(j), baseURI);
            service.addService(ss);
        }
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Service added: " + service);
        }
        return service;
    }

    public void writeXML(InvCatalogImpl catalog, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter();
        fmt.output(this.makeCatalog(catalog), os);
    }

    public Document makeCatalog(InvCatalogImpl cat) {
        String dtd = cat.getDTDid();
        if (dtd == null) {
            dtd = dtdDefault;
        }
        DocType docType = new DocType("catalog", dtd);
        Element rootElem = new Element("catalog", defNS);
        Document doc = new Document(rootElem);
        doc.setDocType(docType);
        rootElem.setAttribute("name", cat.getName());
        rootElem.setAttribute("version", "0.6");
        rootElem.addNamespaceDeclaration(xlinkNS);
        Element topDsElem = this.makeDataset(cat, null, (InvDatasetImpl)cat.getDataset());
        rootElem.addContent(topDsElem);
        return doc;
    }

    private Element makeAccess(InvAccessImpl access) {
        Element accessElem = new Element("access", defNS);
        accessElem.setAttribute("urlPath", access.getUrlPath());
        if (access.getServiceType() != null) {
            accessElem.setAttribute("serviceType", access.getServiceType().toString());
        }
        if (access.getServiceName() != null) {
            accessElem.setAttribute("serviceName", access.getServiceName());
        }
        return accessElem;
    }

    private Element makeCatalogRef(InvCatalogRef catRef) {
        Element catrefElem = new Element("catalogRef", defNS);
        catrefElem.setAttribute("href", catRef.getXlinkHref(), xlinkNS);
        catrefElem.setAttribute("title", catRef.getName(), xlinkNS);
        return catrefElem;
    }

    private Element makeDataset(InvCatalogImpl catalog, InvDatasetImpl p, InvDatasetImpl ds) {
        InvProperty pr;
        int j;
        Element dsElem = new Element("dataset", defNS);
        if (ds == null) {
            return dsElem;
        }
        if (ds instanceof InvDatasetImplProxy) {
            dsElem.setAttribute("name", ((InvDatasetImplProxy)ds).getAliasName());
            dsElem.setAttribute("alias", ds.getID());
            return dsElem;
        }
        dsElem.setAttribute("name", ds.getName());
        if (ds.getID() != null) {
            dsElem.setAttribute("ID", ds.getID());
        }
        if (ds.getUrlPath() != null) {
            dsElem.setAttribute("urlPath", ds.getUrlPath());
        }
        Iterator services = ds.getServicesLocal().iterator();
        while (services.hasNext()) {
            InvService service = (InvService)services.next();
            dsElem.addContent(this.makeService(service));
        }
        if (p == null) {
            List topLevelServices = catalog.getServices();
            Iterator it = topLevelServices.iterator();
            while (it.hasNext()) {
                InvService curService = (InvService)it.next();
                dsElem.addContent(this.makeService(curService));
            }
        }
        Iterator docs = ds.getDocumentation().iterator();
        while (docs.hasNext()) {
            InvDocumentation doc = (InvDocumentation)docs.next();
            dsElem.addContent(this.makeDocumentation(doc));
        }
        Iterator mdata = ds.getMetadata().iterator();
        while (mdata.hasNext()) {
            InvMetadata m = (InvMetadata)mdata.next();
            dsElem.addContent(this.makeMetadata(m));
        }
        ThreddsMetadata tm = ds.getLocalMetadata();
        ThreddsMetadata tmi = ds.getLocalMetadataInherited();
        if (tmi.getDataType() != null) {
            dsElem.setAttribute("dataType", tmi.getDataType().toString());
        } else if (tm.getDataType() != null) {
            dsElem.setAttribute("dataType", tm.getDataType().toString());
        }
        if (tmi.getServiceName() != null) {
            dsElem.setAttribute("serviceName", tmi.getServiceName());
        } else if (tm.getServiceName() != null) {
            dsElem.setAttribute("serviceName", tm.getServiceName());
        }
        if (tmi.getAuthority() != null) {
            dsElem.setAttribute("authority", tmi.getAuthority());
        } else if (tm.getAuthority() != null) {
            dsElem.setAttribute("authority", tm.getAuthority());
        }
        List list = tmi.getProperties();
        for (j = 0; j < list.size(); ++j) {
            pr = (InvProperty)list.get(j);
            dsElem.addContent(this.makeProperty(pr));
        }
        list = tm.getProperties();
        for (j = 0; j < list.size(); ++j) {
            pr = (InvProperty)list.get(j);
            dsElem.addContent(this.makeProperty(pr));
        }
        Iterator access = ds.getAccessLocal().iterator();
        while (access.hasNext()) {
            InvAccessImpl a = (InvAccessImpl)access.next();
            dsElem.addContent(this.makeAccess(a));
        }
        Iterator datasets = ds.getDatasets().iterator();
        while (datasets.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)datasets.next();
            if (nested instanceof InvCatalogRef) {
                dsElem.addContent(this.makeCatalogRef((InvCatalogRef)nested));
                continue;
            }
            dsElem.addContent(this.makeDataset(catalog, ds, nested));
        }
        return dsElem;
    }

    private Element makeDocumentation(InvDocumentation doc) {
        String inline;
        Element docElem = new Element("documentation", defNS);
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getURI().toString(), xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    private Element makeMetadata(InvMetadata mdata) {
        Element mdataElem = new Element("metadata", defNS);
        if (mdata.getMetadataType() != null) {
            mdataElem.setAttribute("metadataType", mdata.getMetadataType());
        }
        if (mdata.isInherited()) {
            mdataElem.setAttribute("inherited", "true");
        }
        if (mdata.hasXlink()) {
            mdataElem.setAttribute("href", mdata.getXlinkHref().toString(), xlinkNS);
            if (mdata.getXlinkTitle() != null) {
                mdataElem.setAttribute("title", mdata.getXlinkTitle(), xlinkNS);
            }
        } else {
            MetadataConverterIF converter = mdata.getConverter();
            if (converter != null && mdata.getContentObject() != null) {
                if (mdata.getContentObject() instanceof Element) {
                    Element mdataOrg = (Element)mdata.getContentObject();
                    List children = mdataOrg.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        Element child = (Element)children.get(i);
                        mdataElem.addContent((Element)child.clone());
                    }
                } else {
                    org.w3c.dom.Element dome = this.toDOM(mdataElem);
                    converter.addMetadataContent(dome, mdata.getContentObject());
                    mdataElem = this.toJDOM(dome);
                    mdataElem.detach();
                }
            }
        }
        return mdataElem;
    }

    private Element makeProperty(InvProperty prop) {
        Element propElem = new Element("property", defNS);
        propElem.setAttribute("name", prop.getName());
        propElem.setAttribute("value", prop.getValue());
        return propElem;
    }

    private Element makeService(InvService service) {
        Element serviceElem = new Element("service", defNS);
        serviceElem.setAttribute("name", service.getName());
        serviceElem.setAttribute("serviceType", service.getServiceType().toString());
        serviceElem.setAttribute("base", service.getBase());
        if (service.getSuffix() != null && service.getSuffix().length() > 0) {
            serviceElem.setAttribute("suffix", service.getSuffix());
        }
        Iterator services = service.getServices().iterator();
        while (services.hasNext()) {
            InvService nested = (InvService)services.next();
            serviceElem.addContent(this.makeService(nested));
        }
        Iterator props = service.getProperties().iterator();
        while (props.hasNext()) {
            InvProperty p = (InvProperty)props.next();
            serviceElem.addContent(this.makeProperty(p));
        }
        return serviceElem;
    }

    private org.w3c.dom.Element toDOM(Element elem) {
        try {
            if (this.domOut == null) {
                this.domOut = new DOMOutputter();
            }
            return this.domOut.output(elem);
        }
        catch (JDOMException e) {
            System.out.println("InvCatalogFactory6.readMetadata.toDom error " + (Object)((Object)e));
            return null;
        }
    }

    public Element toJDOM(org.w3c.dom.Element domElement) {
        return this.builder.build(domElement);
    }
}

