/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataType;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetImplProxy;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;
import thredds.datatype.DateType;
import thredds.datatype.TimeDuration;

public class InvCatalogFactory10
implements InvCatalogConvertIF,
MetadataConverterIF {
    private static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
    private static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private InvCatalogFactory factory = null;
    private DOMBuilder builder = new DOMBuilder();
    private DOMOutputter domOut = null;
    private boolean debugMetadataRead = false;
    private HashMap metadataHash = new HashMap(10);

    public InvCatalogImpl parseXML(InvCatalogFactory fac, org.w3c.dom.Document domDoc, URI uri) {
        this.factory = fac;
        Document doc = this.builder.build(domDoc);
        if (InvCatalogFactory.showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** catalog/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        InvCatalogImpl catalog = this.readCatalog(doc.getRootElement(), uri);
        return catalog;
    }

    public void registerMetadataConverter(MetadataType type, MetadataConverterIF converter) {
        this.metadataHash.put(type, converter);
    }

    protected InvAccessImpl readAccess(InvDatasetImpl dataset, org.jdom.Element accessElem) {
        String urlPath = accessElem.getAttributeValue("urlPath");
        String serviceName = accessElem.getAttributeValue("serviceName");
        String dataFormat = accessElem.getAttributeValue("dataFormat");
        return new InvAccessImpl(dataset, urlPath, serviceName, null, dataFormat, this.readDataSize(accessElem));
    }

    protected InvCatalogImpl readCatalog(org.jdom.Element catalogElem, URI baseURI) {
        String name = catalogElem.getAttributeValue("name");
        String expires = catalogElem.getAttributeValue("expires");
        String version = catalogElem.getAttributeValue("version");
        InvCatalogImpl catalog = new InvCatalogImpl(name, version, this.makeDateType(expires, null, null), baseURI);
        List sList = catalogElem.getChildren("service", defNS);
        for (int j = 0; j < sList.size(); ++j) {
            InvService s = this.readService((org.jdom.Element)sList.get(j), baseURI);
            catalog.addService(s);
        }
        List pList = catalogElem.getChildren("property", defNS);
        for (int j = 0; j < pList.size(); ++j) {
            InvProperty s = this.readProperty((org.jdom.Element)pList.get(j));
            catalog.addProperty(s);
        }
        List allChildren = catalogElem.getChildren();
        for (int j = 0; j < allChildren.size(); ++j) {
            org.jdom.Element e = (org.jdom.Element)allChildren.get(j);
            if (e.getName().equals("dataset")) {
                catalog.addDataset(this.readDataset(catalog, null, e, baseURI));
                continue;
            }
            if (!e.getName().equals("catalogRef")) continue;
            catalog.addDataset(this.readCatalogRef(catalog, null, e, baseURI));
        }
        return catalog;
    }

    protected InvCatalogRef readCatalogRef(InvCatalog cat, InvDatasetImpl parent, org.jdom.Element catRefElem, URI baseURI) {
        String title = catRefElem.getAttributeValue("title", xlinkNS);
        String href = catRefElem.getAttributeValue("href", xlinkNS);
        InvCatalogRef catRef = new InvCatalogRef(parent, title, href);
        List docList = catRefElem.getChildren("documentation", defNS);
        for (int j = 0; j < docList.size(); ++j) {
            InvDocumentation doc = this.readDocumentation(cat, (org.jdom.Element)docList.get(j));
            catRef.addDocumentation(doc);
        }
        return catRef;
    }

    protected ThreddsMetadata.Contributor readContributor(org.jdom.Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Contributor(elem.getText(), elem.getAttributeValue("role"));
    }

    protected ThreddsMetadata.Vocab readControlledVocabulary(org.jdom.Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Vocab(elem.getText(), elem.getAttributeValue("vocabulary"));
    }

    protected InvDatasetImpl readDataset(InvCatalogImpl catalog, InvDatasetImpl parent, org.jdom.Element dsElem, URI base) {
        String name = dsElem.getAttributeValue("name");
        String alias = dsElem.getAttributeValue("alias");
        if (alias != null) {
            InvDatasetImpl ds = (InvDatasetImpl)catalog.findDatasetByID(alias);
            if (ds == null) {
                this.factory.appendErr(" ** Parse error: dataset named " + name + " has illegal alias = " + alias + "\n");
            }
            return new InvDatasetImplProxy(name, ds);
        }
        String authority = dsElem.getAttributeValue("authority");
        String collectionTypeName = dsElem.getAttributeValue("collectionType");
        String dataTypeName = dsElem.getAttributeValue("dataType");
        String harvest = dsElem.getAttributeValue("harvest");
        String id = dsElem.getAttributeValue("ID");
        String serviceName = dsElem.getAttributeValue("serviceName");
        String urlPath = dsElem.getAttributeValue("urlPath");
        DataType dataType = null;
        if (dataTypeName != null && (dataType = DataType.getType(dataTypeName)) == null) {
            dataType = new DataType(dataTypeName);
            this.factory.appendWarning(" ** warning: non-standard data type = " + dataTypeName + "\n");
        }
        InvDatasetImpl dataset = new InvDatasetImpl(parent, name, dataType, serviceName, urlPath);
        if (authority != null) {
            dataset.setAuthority(authority);
        }
        if (id != null) {
            dataset.setID(id);
        }
        if (harvest != null) {
            dataset.setHarvest(harvest.equalsIgnoreCase("true"));
        }
        if (collectionTypeName != null) {
            CollectionType collectionType = CollectionType.getType(collectionTypeName);
            if (collectionType == null) {
                collectionType = new CollectionType(collectionTypeName);
                this.factory.appendWarning(" ** warning: non-standard collection type = " + collectionTypeName + "\n");
            }
            dataset.setCollectionType(collectionType);
        }
        catalog.addDatasetByID(dataset);
        List serviceList = dsElem.getChildren("service", defNS);
        for (int j = 0; j < serviceList.size(); ++j) {
            InvService s = this.readService((org.jdom.Element)serviceList.get(j), base);
            dataset.addService(s);
        }
        ThreddsMetadata tmg = dataset.getLocalMetadata();
        this.readThreddsMetadata(catalog, dataset, dsElem, tmg);
        List aList = dsElem.getChildren("access", defNS);
        for (int j = 0; j < aList.size(); ++j) {
            InvAccessImpl a = this.readAccess(dataset, (org.jdom.Element)aList.get(j));
            dataset.addAccess(a);
        }
        List allChildren = dsElem.getChildren();
        for (int j = 0; j < allChildren.size(); ++j) {
            InvDatasetImpl ds;
            org.jdom.Element e = (org.jdom.Element)allChildren.get(j);
            if (e.getName().equals("dataset")) {
                ds = this.readDataset(catalog, dataset, e, base);
                if (ds == null) continue;
                dataset.addDataset(ds);
                continue;
            }
            if (!e.getName().equals("catalogRef")) continue;
            ds = this.readCatalogRef(catalog, dataset, e, base);
            dataset.addDataset(ds);
        }
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Dataset added: " + dataset.dump());
        }
        return dataset;
    }

    protected DateType readDate(org.jdom.Element elem) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        return this.makeDateType(elem.getText(), format, type);
    }

    protected DateType makeDateType(String text, String format, String type) {
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type);
        }
        catch (ParseException e) {
            this.factory.appendErr(" ** Parse error: Bad date format = " + text + "\n");
            return null;
        }
    }

    protected TimeDuration readDuration(org.jdom.Element elem) {
        if (elem == null) {
            return null;
        }
        String text = null;
        try {
            text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            this.factory.appendErr(" ** Parse error: Bad duration format = " + text + "\n");
            return null;
        }
    }

    protected InvDocumentation readDocumentation(InvCatalog cat, org.jdom.Element s) {
        String href = s.getAttributeValue("href", xlinkNS);
        String title = s.getAttributeValue("title", xlinkNS);
        String type = s.getAttributeValue("type");
        String content = s.getTextNormalize();
        URI uri = null;
        if (href != null) {
            try {
                uri = cat.resolveUri(href);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid documentation href = " + href + " " + e.getMessage() + "\n");
            }
        }
        InvDocumentation doc = new InvDocumentation(href, uri, title, type, content);
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Documentation added: " + doc);
        }
        return doc;
    }

    protected double readDouble(org.jdom.Element elem) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            this.factory.appendErr(" ** Parse error: Bad double format = " + text + "\n");
            return Double.NaN;
        }
    }

    protected ThreddsMetadata.GeospatialCoverage readGeospatialCoverage(org.jdom.Element gcElem) {
        if (gcElem == null) {
            return null;
        }
        String zpositive = gcElem.getAttributeValue("zpositive");
        ThreddsMetadata.Range northsouth = this.readGeospatialRange(gcElem.getChild("northsouth", defNS));
        ThreddsMetadata.Range eastwest = this.readGeospatialRange(gcElem.getChild("eastwest", defNS));
        ThreddsMetadata.Range updown = this.readGeospatialRange(gcElem.getChild("updown", defNS));
        ArrayList<ThreddsMetadata.Vocab> names = new ArrayList<ThreddsMetadata.Vocab>();
        List list = gcElem.getChildren("name", defNS);
        for (int j = 0; j < list.size(); ++j) {
            ThreddsMetadata.Vocab name = this.readControlledVocabulary((org.jdom.Element)list.get(j));
            names.add(name);
        }
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage(eastwest, northsouth, updown, names, zpositive);
        return gc;
    }

    protected ThreddsMetadata.Range readGeospatialRange(org.jdom.Element spElem) {
        if (spElem == null) {
            return null;
        }
        double start = this.readDouble(spElem.getChild("start", defNS));
        double size = this.readDouble(spElem.getChild("size", defNS));
        double resolution = this.readDouble(spElem.getChild("resolution", defNS));
        String units = spElem.getAttributeValue("units");
        return new ThreddsMetadata.Range(start, size, resolution, units);
    }

    protected InvMetadata readMetadata(InvCatalog catalog, InvDatasetImpl dataset, org.jdom.Element mdataElement) {
        List inlineElements = mdataElement.getChildren();
        Namespace namespace = inlineElements.size() > 0 ? ((org.jdom.Element)inlineElements.get(0)).getNamespace() : mdataElement.getNamespace();
        String mtype = mdataElement.getAttributeValue("metadataType");
        String href = mdataElement.getAttributeValue("href", xlinkNS);
        String title = mdataElement.getAttributeValue("title", xlinkNS);
        String inheritedS = mdataElement.getAttributeValue("inherited");
        boolean inherited = inheritedS != null && inheritedS.equalsIgnoreCase("true");
        boolean isThreddsNamespace = (mtype == null || mtype.equalsIgnoreCase("THREDDS")) && namespace.getURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        MetadataConverterIF metaConverter = this.factory.getMetadataConverter(namespace.getURI());
        if (metaConverter == null) {
            metaConverter = this.factory.getMetadataConverter(mtype);
        }
        if (metaConverter != null) {
            if (this.debugMetadataRead) {
                System.out.println("found factory for metadata type = " + mtype + " namespace = " + namespace + "=" + metaConverter.getClass().getName());
            }
            Object contentObj = null;
            if (inlineElements.size() > 0) {
                contentObj = metaConverter.readMetadataContent(dataset, this.toDOM(mdataElement));
                return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, metaConverter, contentObj);
            }
            return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, metaConverter);
        }
        if (!isThreddsNamespace) {
            if (inlineElements.size() > 0) {
                return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, this, mdataElement);
            }
            return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, null);
        }
        if (inlineElements.size() > 0) {
            ThreddsMetadata tmg = new ThreddsMetadata(false);
            this.readThreddsMetadata(catalog, dataset, mdataElement, tmg);
            return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, true, this, tmg);
        }
        return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, true, this);
    }

    public Object readMetadataContent(InvDataset dataset, Element mdataElement) {
        InvMetadata m = this.readMetadata(dataset.getParentCatalog(), (InvDatasetImpl)dataset, this.toJDOM(mdataElement));
        return m.getThreddsMetadata();
    }

    public Object readMetadataContentFromURL(InvDataset dataset, URI uri) throws IOException {
        Element mdataElement;
        if (this.debugMetadataRead) {
            System.out.println(" readMetadataContentFromURL = " + uri);
        }
        if ((mdataElement = this.factory.readOtherXML(uri)) == null) {
            this.factory.appendErr(" ** failed to read thredds metadata at = " + uri + " for dataset" + dataset.getName() + "\n");
            return null;
        }
        Object contentObject = this.readMetadataContent(dataset, mdataElement);
        if (this.debugMetadataRead) {
            System.out.println(" convert to " + contentObject.getClass().getName());
        }
        return contentObject;
    }

    public boolean validateMetadataContent(Object contentObject, StringBuffer out) {
        return true;
    }

    public void addMetadataContent(Element mdataElement, Object contentObject) {
    }

    protected InvProperty readProperty(org.jdom.Element s) {
        String name = s.getAttributeValue("name");
        String value = s.getAttributeValue("value");
        return new InvProperty(name, value);
    }

    protected ThreddsMetadata.Source readSource(org.jdom.Element elem) {
        if (elem == null) {
            return null;
        }
        ThreddsMetadata.Vocab name = this.readControlledVocabulary(elem.getChild("name", defNS));
        org.jdom.Element contact = elem.getChild("contact", defNS);
        if (contact == null) {
            this.factory.appendErr(" ** Parse error: Missing contact element in = " + elem.getName() + "\n");
            return null;
        }
        return new ThreddsMetadata.Source(name, contact.getAttributeValue("url"), contact.getAttributeValue("email"));
    }

    protected InvService readService(org.jdom.Element s, URI baseURI) {
        String name = s.getAttributeValue("name");
        String type = s.getAttributeValue("serviceType");
        String serviceBase = s.getAttributeValue("base");
        String suffix = s.getAttributeValue("suffix");
        String desc = s.getAttributeValue("desc");
        InvService service = new InvService(name, type, serviceBase, suffix, desc);
        List propertyList = s.getChildren("property", defNS);
        for (int j = 0; j < propertyList.size(); ++j) {
            InvProperty p = this.readProperty((org.jdom.Element)propertyList.get(j));
            service.addProperty(p);
        }
        List serviceList = s.getChildren("service", defNS);
        for (int j = 0; j < serviceList.size(); ++j) {
            InvService ss = this.readService((org.jdom.Element)serviceList.get(j), baseURI);
            service.addService(ss);
        }
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Service added: " + service);
        }
        return service;
    }

    protected double readDataSize(org.jdom.Element parent) {
        double size;
        org.jdom.Element elem = parent.getChild("dataSize", defNS);
        if (elem == null) {
            return Double.NaN;
        }
        String sizeS = elem.getText();
        try {
            size = Double.parseDouble(sizeS);
        }
        catch (NumberFormatException e) {
            this.factory.appendErr(" ** Parse error: Bad double format in size element = " + sizeS + "\n");
            return Double.NaN;
        }
        String units = elem.getAttributeValue("units");
        char c = Character.toUpperCase(units.charAt(0));
        if (c == 'K') {
            size *= 1000.0;
        } else if (c == 'M') {
            size *= 1000000.0;
        } else if (c == 'G') {
            size *= 1.0E9;
        } else if (c == 'T') {
            size *= -7.27379968E8;
        } else if (c == 'P') {
            size *= -1.530494976E9;
        }
        return size;
    }

    protected ThreddsMetadata.TimeCoverage readTimeCoverage(org.jdom.Element tElem) {
        if (tElem == null) {
            return null;
        }
        DateType start = this.readDate(tElem.getChild("start", defNS));
        DateType end = this.readDate(tElem.getChild("end", defNS));
        TimeDuration duration = this.readDuration(tElem.getChild("duration", defNS));
        TimeDuration resolution = this.readDuration(tElem.getChild("resolution", defNS));
        ThreddsMetadata.TimeCoverage tc = new ThreddsMetadata.TimeCoverage(start, end, duration, resolution);
        return tc;
    }

    protected void readThreddsMetadata(InvCatalog catalog, InvDatasetImpl dataset, org.jdom.Element parent, ThreddsMetadata tmg) {
        double size;
        String dataFormatTypeName;
        org.jdom.Element dataFormatElem;
        String dataTypeName;
        org.jdom.Element dataTypeElem;
        org.jdom.Element authElem;
        org.jdom.Element serviceNameElem;
        ThreddsMetadata.TimeCoverage tc;
        int j;
        int j2;
        List list = parent.getChildren("creator", defNS);
        for (j2 = 0; j2 < list.size(); ++j2) {
            tmg.addCreator(this.readSource((org.jdom.Element)list.get(j2)));
        }
        list = parent.getChildren("contributor", defNS);
        for (j2 = 0; j2 < list.size(); ++j2) {
            tmg.addContributor(this.readContributor((org.jdom.Element)list.get(j2)));
        }
        list = parent.getChildren("date", defNS);
        for (j2 = 0; j2 < list.size(); ++j2) {
            DateType d = this.readDate((org.jdom.Element)list.get(j2));
            tmg.addDate(d);
        }
        list = parent.getChildren("documentation", defNS);
        for (j2 = 0; j2 < list.size(); ++j2) {
            InvDocumentation doc = this.readDocumentation(catalog, (org.jdom.Element)list.get(j2));
            tmg.addDocumentation(doc);
        }
        list = parent.getChildren("keyword", defNS);
        for (j2 = 0; j2 < list.size(); ++j2) {
            tmg.addKeyword(this.readControlledVocabulary((org.jdom.Element)list.get(j2)));
        }
        List mList = parent.getChildren("metadata", defNS);
        for (j = 0; j < mList.size(); ++j) {
            InvMetadata m = this.readMetadata(catalog, dataset, (org.jdom.Element)mList.get(j));
            if (m == null) continue;
            tmg.addMetadata(m);
        }
        list = parent.getChildren("project", defNS);
        for (j = 0; j < list.size(); ++j) {
            tmg.addProject(this.readControlledVocabulary((org.jdom.Element)list.get(j)));
        }
        list = parent.getChildren("property", defNS);
        for (j = 0; j < list.size(); ++j) {
            InvProperty p = this.readProperty((org.jdom.Element)list.get(j));
            tmg.addProperty(p);
        }
        list = parent.getChildren("publisher", defNS);
        for (j = 0; j < list.size(); ++j) {
            tmg.addPublisher(this.readSource((org.jdom.Element)list.get(j)));
        }
        list = parent.getChildren("variables", defNS);
        for (j = 0; j < list.size(); ++j) {
            ThreddsMetadata.Variables vars = this.readVariables(catalog, dataset, (org.jdom.Element)list.get(j));
            tmg.addVariables(vars);
        }
        ThreddsMetadata.GeospatialCoverage gc = this.readGeospatialCoverage(parent.getChild("geospatialCoverage", defNS));
        if (gc != null) {
            tmg.setGeospatialCoverage(gc);
        }
        if ((tc = this.readTimeCoverage(parent.getChild("timeCoverage", defNS))) != null) {
            tmg.setTimeCoverage(tc);
        }
        if ((serviceNameElem = parent.getChild("serviceName", defNS)) != null) {
            tmg.setServiceName(serviceNameElem.getText());
        }
        if ((authElem = parent.getChild("authority", defNS)) != null) {
            tmg.setAuthority(authElem.getText());
        }
        if ((dataTypeElem = parent.getChild("dataType", defNS)) != null && (dataTypeName = dataTypeElem.getText()) != null && dataTypeName.length() > 0) {
            DataType dataType = DataType.getType(dataTypeName);
            if (dataType == null) {
                dataType = new DataType(dataTypeName);
                this.factory.appendWarning(" ** warning: non-standard data type = " + dataTypeName + "\n");
            }
            tmg.setDataType(dataType);
        }
        if ((dataFormatElem = parent.getChild("dataFormat", defNS)) != null && (dataFormatTypeName = dataFormatElem.getText()) != null && dataFormatTypeName.length() > 0) {
            DataFormatType dataFormatType = DataFormatType.getType(dataFormatTypeName);
            if (dataFormatType == null) {
                dataFormatType = new DataFormatType(dataFormatTypeName);
                this.factory.appendWarning(" ** warning: non-standard data type = " + dataFormatTypeName + "\n");
            }
            tmg.setDataFormatType(dataFormatType);
        }
        if (!Double.isNaN(size = this.readDataSize(parent))) {
            tmg.setDataSize(size);
        }
    }

    protected ThreddsMetadata.Variable readVariable(org.jdom.Element varElem) {
        if (varElem == null) {
            return null;
        }
        String name = varElem.getAttributeValue("name");
        String vocabulary_name = varElem.getAttributeValue("vocabulary_name");
        String units = varElem.getAttributeValue("units");
        return new ThreddsMetadata.Variable(name, vocabulary_name, units);
    }

    protected ThreddsMetadata.Variables readVariables(InvCatalog cat, InvDataset ds, org.jdom.Element varsElem) {
        Element domElement;
        if (varsElem == null) {
            return null;
        }
        String vocab = varsElem.getAttributeValue("vocabulary");
        String vocabHref = varsElem.getAttributeValue("href", xlinkNS);
        URI vocabUri = null;
        if (vocabHref != null) {
            try {
                vocabUri = cat.resolveUri(vocabHref);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid Variables vocabulary URI = " + vocabHref + " " + e.getMessage() + "\n");
            }
        }
        List vlist = varsElem.getChildren("variable", defNS);
        String mapHref = null;
        URI mapUri = null;
        org.jdom.Element map = varsElem.getChild("variableMap", defNS);
        if (map != null) {
            mapHref = map.getAttributeValue("href", xlinkNS);
            try {
                mapUri = cat.resolveUri(mapHref);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid Variables map URI = " + mapHref + " " + e.getMessage() + "\n");
            }
        }
        if (mapUri != null && vlist.size() > 0) {
            this.factory.appendErr(" ** Catalog error: cant have variableMap and variable in same element (dataset = " + ds.getName() + "\n");
            mapUri = null;
        }
        ThreddsMetadata.Variables variables = new ThreddsMetadata.Variables(vocab, vocabHref, vocabUri, mapHref, mapUri);
        for (int j = 0; j < vlist.size(); ++j) {
            ThreddsMetadata.Variable v = this.readVariable((org.jdom.Element)vlist.get(j));
            variables.addVariable(v);
        }
        if (mapUri != null && (domElement = this.factory.readOtherXML(mapUri)) != null) {
            org.jdom.Element varsElement = this.toJDOM(domElement);
            List list = varsElement.getChildren("variable", defNS);
            for (int j = 0; j < list.size(); ++j) {
                ThreddsMetadata.Variable v = this.readVariable((org.jdom.Element)list.get(j));
                variables.addVariable(v);
            }
        }
        return variables;
    }

    public void writeXML(InvCatalogImpl catalog, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter();
        fmt.output(this.writeCatalog(catalog), os);
    }

    public Document writeCatalog(InvCatalogImpl cat) {
        org.jdom.Element rootElem = new org.jdom.Element("catalog", defNS);
        Document doc = new Document(rootElem);
        if (cat.getName() != null) {
            rootElem.setAttribute("name", cat.getName());
        }
        rootElem.addNamespaceDeclaration(xlinkNS);
        if (cat.getExpires() != null) {
            rootElem.setAttribute("expires", cat.getExpires().toString());
        }
        Iterator iter = cat.getServices().iterator();
        while (iter.hasNext()) {
            InvService service = (InvService)iter.next();
            rootElem.addContent(this.writeService(service));
        }
        iter = cat.getProperties().iterator();
        while (iter.hasNext()) {
            InvProperty p = (InvProperty)iter.next();
            rootElem.addContent(this.writeProperty(p));
        }
        iter = cat.getDatasets().iterator();
        while (iter.hasNext()) {
            InvDatasetImpl ds = (InvDatasetImpl)iter.next();
            rootElem.addContent(this.writeDataset(null, ds));
        }
        return doc;
    }

    private org.jdom.Element writeAccess(InvAccessImpl access) {
        org.jdom.Element accessElem = new org.jdom.Element("access", defNS);
        accessElem.setAttribute("urlPath", access.getUrlPath());
        if (access.getServiceName() != null) {
            accessElem.setAttribute("serviceName", access.getServiceName());
        }
        if (access.getDataFormatType() != null) {
            accessElem.setAttribute("dataFormat", access.getDataFormatType().toString());
        }
        if (access.hasDataSize()) {
            accessElem.addContent(this.writeSize(access.getDataSize()));
        }
        return accessElem;
    }

    private org.jdom.Element writeCatalogRef(InvCatalogRef catRef) {
        org.jdom.Element catrefElem = new org.jdom.Element("catalogRef", defNS);
        catrefElem.setAttribute("href", catRef.getXlinkHref(), xlinkNS);
        catrefElem.setAttribute("title", catRef.getName(), xlinkNS);
        List list = catRef.getDocumentation();
        for (int j = 0; j < list.size(); ++j) {
            InvDocumentation doc = (InvDocumentation)list.get(j);
            catrefElem.addContent(this.writeDocumentation(doc, "documentation"));
        }
        return catrefElem;
    }

    protected org.jdom.Element writeContributor(ThreddsMetadata.Contributor c) {
        org.jdom.Element elem = new org.jdom.Element("contributor", defNS);
        if (c.getRole() != null) {
            elem.setAttribute("role", c.getRole());
        }
        elem.setText(c.getName());
        return elem;
    }

    private org.jdom.Element writeControlledVocabulary(ThreddsMetadata.Vocab v, String name) {
        org.jdom.Element elem = new org.jdom.Element(name, defNS);
        if (v.getVocabulary() != null) {
            elem.setAttribute("vocabulary", v.getVocabulary());
        }
        elem.addContent(v.getText());
        return elem;
    }

    private org.jdom.Element writeDataset(InvDatasetImpl p, InvDatasetImpl ds) {
        org.jdom.Element dsElem = new org.jdom.Element("dataset", defNS);
        if (ds instanceof InvDatasetImplProxy) {
            dsElem.setAttribute("name", ((InvDatasetImplProxy)ds).getAliasName());
            dsElem.setAttribute("alias", ds.getID());
            return dsElem;
        }
        dsElem.setAttribute("name", ds.getName());
        if (ds.getCollectionType() != null && ds.getCollectionType() != CollectionType.NONE) {
            dsElem.setAttribute("collectionType", ds.getCollectionType().toString());
        }
        if (ds.isHarvest()) {
            dsElem.setAttribute("harvest", "true");
        }
        if (ds.getID() != null) {
            dsElem.setAttribute("ID", ds.getID());
        }
        if (ds.getUrlPath() != null) {
            dsElem.setAttribute("urlPath", ds.getUrlPath());
        }
        Iterator services = ds.getServicesLocal().iterator();
        while (services.hasNext()) {
            InvService service = (InvService)services.next();
            dsElem.addContent(this.writeService(service));
        }
        this.writeThreddsMetadata(dsElem, ds.getLocalMetadata());
        this.writeCat6InheritedMetadata(dsElem, ds.getLocalMetadataInherited());
        Iterator access = ds.getAccessLocal().iterator();
        while (access.hasNext()) {
            InvAccessImpl a = (InvAccessImpl)access.next();
            dsElem.addContent(this.writeAccess(a));
        }
        Iterator datasets = ds.getDatasets().iterator();
        while (datasets.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)datasets.next();
            if (nested instanceof InvCatalogRef) {
                dsElem.addContent(this.writeCatalogRef((InvCatalogRef)nested));
                continue;
            }
            dsElem.addContent(this.writeDataset(ds, nested));
        }
        return dsElem;
    }

    protected org.jdom.Element writeDate(String name, DateType date) {
        org.jdom.Element dateElem = new org.jdom.Element(name, defNS);
        dateElem.addContent(date.getText());
        if (date.getType() != null) {
            dateElem.setAttribute("type", date.getType());
        }
        if (date.getFormat() != null) {
            dateElem.setAttribute("format", date.getFormat());
        }
        return dateElem;
    }

    private org.jdom.Element writeDocumentation(InvDocumentation doc, String name) {
        String inline;
        org.jdom.Element docElem = new org.jdom.Element(name, defNS);
        if (doc.getType() != null) {
            docElem.setAttribute("type", doc.getType());
        }
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getXlinkHref(), xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    protected org.jdom.Element writeGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        org.jdom.Element elem = new org.jdom.Element("geospatialCoverage", defNS);
        if (gc.getZPositive().equals("down")) {
            elem.setAttribute("zpositive", gc.getZPositive());
        }
        this.writeGeospatialRange(elem, new org.jdom.Element("northsouth", defNS), gc.getNorthSouthRange());
        this.writeGeospatialRange(elem, new org.jdom.Element("eastwest", defNS), gc.getEastWestRange());
        if (gc.getUpDownRange() != null) {
            this.writeGeospatialRange(elem, new org.jdom.Element("updown", defNS), gc.getUpDownRange());
        }
        List names = gc.getNames();
        ThreddsMetadata.Vocab global = new ThreddsMetadata.Vocab("global", null);
        if (gc.isGlobal() && !names.contains(global)) {
            names.add(global);
        } else if (!gc.isGlobal() && names.contains(global)) {
            names.remove(global);
        }
        for (int j = 0; j < names.size(); ++j) {
            ThreddsMetadata.Vocab name = (ThreddsMetadata.Vocab)names.get(j);
            elem.addContent(this.writeControlledVocabulary(name, "name"));
        }
        return elem;
    }

    private void writeGeospatialRange(org.jdom.Element parent, org.jdom.Element elem, ThreddsMetadata.Range r) {
        if (r == null) {
            return;
        }
        elem.addContent(new org.jdom.Element("start", defNS).setText(Double.toString(r.getStart())));
        elem.addContent(new org.jdom.Element("size", defNS).setText(Double.toString(r.getSize())));
        if (r.hasResolution()) {
            elem.addContent(new org.jdom.Element("resolution", defNS).setText(Double.toString(r.getResolution())));
        }
        if (r.getUnits() != null) {
            elem.addContent(new org.jdom.Element("units", defNS).setText(r.getUnits()));
        }
        parent.addContent(elem);
    }

    private org.jdom.Element writeMetadata(InvMetadata mdata) {
        String ns;
        org.jdom.Element mdataElem = new org.jdom.Element("metadata", defNS);
        if (mdata.getMetadataType() != null) {
            mdataElem.setAttribute("metadataType", mdata.getMetadataType());
        }
        if (mdata.isInherited()) {
            mdataElem.setAttribute("inherited", "true");
        }
        if ((ns = mdata.getNamespaceURI()) != null && !ns.equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0")) {
            Namespace mdataNS = Namespace.getNamespace((String)mdata.getNamespacePrefix(), (String)ns);
            mdataElem.addNamespaceDeclaration(mdataNS);
        }
        if (mdata.hasXlink()) {
            mdataElem.setAttribute("href", mdata.getXlinkHref().toString(), xlinkNS);
            if (mdata.getXlinkTitle() != null) {
                mdataElem.setAttribute("title", mdata.getXlinkTitle(), xlinkNS);
            }
        } else if (mdata.getThreddsMetadata() != null) {
            this.writeThreddsMetadata(mdataElem, mdata.getThreddsMetadata());
        } else {
            MetadataConverterIF converter = mdata.getConverter();
            if (converter != null && mdata.getContentObject() != null) {
                if (mdata.getContentObject() instanceof org.jdom.Element) {
                    org.jdom.Element mdataOrg = (org.jdom.Element)mdata.getContentObject();
                    List children = mdataOrg.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        org.jdom.Element child = (org.jdom.Element)children.get(i);
                        mdataElem.addContent((org.jdom.Element)child.clone());
                    }
                } else {
                    Element dome = this.toDOM(mdataElem);
                    converter.addMetadataContent(dome, mdata.getContentObject());
                    mdataElem = this.toJDOM(dome);
                    mdataElem.detach();
                }
            }
        }
        return mdataElem;
    }

    private org.jdom.Element writeProperty(InvProperty prop) {
        org.jdom.Element propElem = new org.jdom.Element("property", defNS);
        propElem.setAttribute("name", prop.getName());
        propElem.setAttribute("value", prop.getValue());
        return propElem;
    }

    protected org.jdom.Element writeSource(String elementName, ThreddsMetadata.Source p) {
        org.jdom.Element elem = new org.jdom.Element(elementName, defNS);
        elem.addContent(this.writeControlledVocabulary(p.getNameVocab(), "name"));
        org.jdom.Element contact = new org.jdom.Element("contact", defNS);
        if (p.getUrl() != null) {
            contact.setAttribute("url", p.getUrl());
        }
        if (p.getEmail() != null) {
            contact.setAttribute("email", p.getEmail());
        }
        elem.addContent(contact);
        return elem;
    }

    private org.jdom.Element writeService(InvService service) {
        org.jdom.Element serviceElem = new org.jdom.Element("service", defNS);
        serviceElem.setAttribute("name", service.getName());
        serviceElem.setAttribute("serviceType", service.getServiceType().toString());
        serviceElem.setAttribute("base", service.getBase());
        if (service.getSuffix() != null && service.getSuffix().length() > 0) {
            serviceElem.setAttribute("suffix", service.getSuffix());
        }
        Iterator props = service.getProperties().iterator();
        while (props.hasNext()) {
            InvProperty p = (InvProperty)props.next();
            serviceElem.addContent(this.writeProperty(p));
        }
        Iterator services = service.getServices().iterator();
        while (services.hasNext()) {
            InvService nested = (InvService)services.next();
            serviceElem.addContent(this.writeService(nested));
        }
        return serviceElem;
    }

    private org.jdom.Element writeSize(double size) {
        org.jdom.Element sizeElem = new org.jdom.Element("dataSize", defNS);
        String unit = null;
        if (size > 1.0E15) {
            unit = "Pbytes";
            size *= 1.0E-15;
        } else if (size > 1.0E12) {
            unit = "Tbytes";
            size *= 1.0E-12;
        } else if (size > 1.0E9) {
            unit = "Gbytes";
            size *= 1.0E-9;
        } else if (size > 1000000.0) {
            unit = "Mbytes";
            size *= 1.0E-6;
        } else if (size > 1000.0) {
            unit = "Kbytes";
            size *= 0.001;
        } else {
            unit = "bytes";
        }
        sizeElem.setAttribute("units", unit);
        sizeElem.setText(Double.toString(size));
        return sizeElem;
    }

    protected void writeCat6InheritedMetadata(org.jdom.Element elem, ThreddsMetadata tmi) {
        if (tmi.getDataType() == null && tmi.getServiceName() == null && tmi.getAuthority() == null && tmi.getProperties().size() == 0) {
            return;
        }
        org.jdom.Element mdataElem = new org.jdom.Element("metadata", defNS);
        mdataElem.setAttribute("inherited", "true");
        this.writeThreddsMetadata(mdataElem, tmi);
        elem.addContent(mdataElem);
    }

    protected void writeThreddsMetadata(org.jdom.Element elem, ThreddsMetadata tmg) {
        ThreddsMetadata.TimeCoverage tc;
        ThreddsMetadata.Vocab v;
        Object p;
        int j;
        if (tmg.getServiceName() != null) {
            org.jdom.Element serviceNameElem = new org.jdom.Element("serviceName", defNS);
            serviceNameElem.setText(tmg.getServiceName());
            elem.addContent(serviceNameElem);
        }
        if (tmg.getAuthority() != null) {
            org.jdom.Element authElem = new org.jdom.Element("authority", defNS);
            authElem.setText(tmg.getAuthority());
            elem.addContent(authElem);
        }
        if (tmg.getDataType() != null && tmg.getDataType() != DataType.NONE) {
            org.jdom.Element dataTypeElem = new org.jdom.Element("dataType", defNS);
            dataTypeElem.setText(tmg.getDataType().toString());
            elem.addContent(dataTypeElem);
        }
        if (tmg.getDataFormatType() != null && tmg.getDataFormatType() != DataFormatType.NONE) {
            org.jdom.Element dataFormatElem = new org.jdom.Element("dataFormat", defNS);
            dataFormatElem.setText(tmg.getDataFormatType().toString());
            elem.addContent(dataFormatElem);
        }
        if (tmg.hasDataSize()) {
            elem.addContent(this.writeSize(tmg.getDataSize()));
        }
        List list = tmg.getDocumentation();
        for (j = 0; j < list.size(); ++j) {
            InvDocumentation doc = (InvDocumentation)list.get(j);
            elem.addContent(this.writeDocumentation(doc, "documentation"));
        }
        list = tmg.getContributors();
        for (j = 0; j < list.size(); ++j) {
            ThreddsMetadata.Contributor c = (ThreddsMetadata.Contributor)list.get(j);
            elem.addContent(this.writeContributor(c));
        }
        list = tmg.getCreators();
        for (j = 0; j < list.size(); ++j) {
            p = (ThreddsMetadata.Source)list.get(j);
            elem.addContent(this.writeSource("creator", (ThreddsMetadata.Source)p));
        }
        list = tmg.getKeywords();
        for (j = 0; j < list.size(); ++j) {
            v = (ThreddsMetadata.Vocab)list.get(j);
            elem.addContent(this.writeControlledVocabulary(v, "keyword"));
        }
        list = tmg.getMetadata();
        for (j = 0; j < list.size(); ++j) {
            InvMetadata m = (InvMetadata)list.get(j);
            elem.addContent(this.writeMetadata(m));
        }
        list = tmg.getProjects();
        for (j = 0; j < list.size(); ++j) {
            v = (ThreddsMetadata.Vocab)list.get(j);
            elem.addContent(this.writeControlledVocabulary(v, "project"));
        }
        list = tmg.getProperties();
        for (j = 0; j < list.size(); ++j) {
            p = (InvProperty)list.get(j);
            elem.addContent(this.writeProperty((InvProperty)p));
        }
        list = tmg.getPublishers();
        for (j = 0; j < list.size(); ++j) {
            p = (ThreddsMetadata.Source)list.get(j);
            elem.addContent(this.writeSource("publisher", (ThreddsMetadata.Source)p));
        }
        list = tmg.getDates();
        for (j = 0; j < list.size(); ++j) {
            DateType d = (DateType)list.get(j);
            elem.addContent(this.writeDate("date", d));
        }
        ThreddsMetadata.GeospatialCoverage gc = tmg.getGeospatialCoverage();
        if (gc != null && !gc.isEmpty()) {
            elem.addContent(this.writeGeospatialCoverage(gc));
        }
        if ((tc = tmg.getTimeCoverage()) != null && !tc.isEmpty()) {
            elem.addContent(this.writeTimeCoverage(tc));
        }
        list = tmg.getVariables();
        for (int j2 = 0; j2 < list.size(); ++j2) {
            ThreddsMetadata.Variables v2 = (ThreddsMetadata.Variables)list.get(j2);
            elem.addContent(this.writeVariables(v2));
        }
    }

    protected org.jdom.Element writeTimeCoverage(ThreddsMetadata.TimeCoverage t) {
        org.jdom.Element telem;
        org.jdom.Element elem = new org.jdom.Element("timeCoverage", defNS);
        DateType start = t.getStart();
        DateType end = t.getEnd();
        TimeDuration duration = t.getDuration();
        if (start != null && !start.isBlank()) {
            org.jdom.Element startElem = new org.jdom.Element("start", defNS);
            startElem.setText(start.toString());
            elem.addContent(startElem);
        }
        if (end != null && !end.isBlank()) {
            telem = new org.jdom.Element("end", defNS);
            telem.setText(end.toString());
            elem.addContent(telem);
        }
        if (duration != null && !duration.isBlank()) {
            telem = new org.jdom.Element("duration", defNS);
            telem.setText(duration.toString());
            elem.addContent(telem);
        }
        if (t.getResolution() != null && !t.getResolution().isBlank()) {
            telem = new org.jdom.Element("resolution", defNS);
            telem.setText(t.getResolution().toString());
            elem.addContent(telem);
        }
        return elem;
    }

    protected org.jdom.Element writeVariable(ThreddsMetadata.Variable v) {
        org.jdom.Element elem = new org.jdom.Element("variable", defNS);
        elem.setAttribute("name", v.getName());
        elem.setAttribute("vocabulary_name", v.getVocabularyName());
        if (v.getUnits() != null) {
            elem.setAttribute("units", v.getUnits());
        }
        return elem;
    }

    protected org.jdom.Element writeVariables(ThreddsMetadata.Variables vs) {
        org.jdom.Element elem = new org.jdom.Element("variables", defNS);
        if (vs.getVocabulary() != null) {
            elem.setAttribute("vocabulary", vs.getVocabulary());
        }
        if (vs.getVocabHref() != null) {
            elem.setAttribute("href", vs.getVocabHref(), xlinkNS);
        }
        if (vs.getMapHref() != null) {
            org.jdom.Element mapElem = new org.jdom.Element("variableMap", defNS);
            mapElem.setAttribute("href", vs.getMapHref(), xlinkNS);
            elem.addContent(mapElem);
        } else {
            List list = vs.getVariableList();
            for (int j = 0; j < list.size(); ++j) {
                ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)list.get(j);
                elem.addContent(this.writeVariable(v));
            }
        }
        return elem;
    }

    public Element toDOM(org.jdom.Element elem) {
        try {
            if (this.domOut == null) {
                this.domOut = new DOMOutputter();
            }
            return this.domOut.output(elem);
        }
        catch (JDOMException e) {
            System.out.println("InvCatalogFactory6.readMetadata.toDom error " + (Object)((Object)e));
            return null;
        }
    }

    public org.jdom.Element toJDOM(Element domElement) {
        return this.builder.build(domElement);
    }
}

