/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import thredds.catalog.query.DqcConvertIF;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.ListChoice;
import thredds.catalog.query.Location;
import thredds.catalog.query.Query;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;

public class DqcConvert2
implements DqcConvertIF {
    public static boolean debugURL = false;
    public static boolean debugXML = false;
    public static boolean debugDBurl = false;
    public static boolean debugXMLopen = false;
    public static boolean showParsedXML = false;
    public static boolean showXMLoutput = false;
    protected static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/schemas/thredds/queryCapability");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private DOMBuilder builder = new DOMBuilder();

    public QueryCapability parseXML(DqcFactory fac, org.w3c.dom.Document domDoc, URI uri) throws IOException {
        Document doc = this.builder.build(domDoc);
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** queryFactory/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        QueryCapability qc = this.readQC(doc.getRootElement(), uri);
        if (showXMLoutput) {
            System.out.println("*** queryFactory/showXMLoutput");
            this.writeXML(qc, System.out);
        }
        return qc;
    }

    private QueryCapability readQC(Element qcElem, URI uri) {
        String name = qcElem.getAttributeValue("name");
        String version = qcElem.getAttributeValue("version");
        QueryCapability qc = new QueryCapability(uri.toString(), name, version);
        qc.setQuery(this.readQuery(qcElem.getChild("query", defNS), uri));
        Element selections = qcElem.getChild("selections", defNS);
        List list = selections.getChildren();
        for (int j = 0; j < list.size(); ++j) {
            Element child = (Element)list.get(j);
            String childName = child.getName();
            if (childName.equals("selectList")) {
                qc.addSelector(this.readSelectList(qc, child));
            }
            if (!childName.equals("selectStation")) continue;
            qc.addSelector(this.readSelectStation(qc, child));
        }
        return qc;
    }

    public Document makeQC(QueryCapability qc) {
        Element rootElem = new Element("queryCapability", defNS);
        Document doc = new Document(rootElem);
        if (null != qc.getName()) {
            rootElem.setAttribute("name", qc.getName());
        }
        rootElem.setAttribute("version", qc.getVersion());
        rootElem.addContent(this.makeQuery(qc.getQuery()));
        Element elem = new Element("selections", defNS);
        ArrayList selectors = qc.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s = (Selector)selectors.get(i);
            if (s instanceof SelectList) {
                elem.addContent(this.makeSelectList((SelectList)s));
                continue;
            }
            if (!(s instanceof SelectStation)) continue;
            elem.addContent(this.makeSelectStation((SelectStation)s));
        }
        rootElem.addContent(elem);
        return doc;
    }

    private Query readQuery(Element s, URI base) {
        String action = s.getAttributeValue("action");
        String construct = s.getAttributeValue("construct");
        String returns = s.getAttributeValue("returns");
        URI uri = base.resolve(action);
        return new Query(action, uri, construct);
    }

    private Element makeQuery(Query q) {
        Element elem = new Element("query", defNS);
        elem.setAttribute("action", q.getBase());
        elem.setAttribute("construct", q.getConstruct());
        elem.setAttribute("returns", q.getReturns());
        return elem;
    }

    private SelectList readSelectList(QueryCapability qc, Element s) {
        String label = s.getAttributeValue("label");
        String id = s.getAttributeValue("id");
        String template = s.getAttributeValue("template");
        String selectType = s.getAttributeValue("selectType");
        String required = s.getAttributeValue("required");
        String multiple = "false";
        if (selectType.equals("multiple")) {
            multiple = "true";
        }
        SelectList slist = new SelectList(label, id, template, required, multiple);
        qc.addUniqueSelector(slist);
        List choices = s.getChildren("choice", defNS);
        for (int j = 0; j < choices.size(); ++j) {
            ListChoice choice = this.readChoice(qc, slist, (Element)choices.get(j));
            slist.addChoice(choice);
        }
        return slist;
    }

    private Element makeSelectList(SelectList s) {
        Element elem = new Element("selectList", defNS);
        elem.setAttribute("label", s.getTitle());
        if (null != s.getId()) {
            elem.setAttribute("id", s.getId());
        }
        if (null != s.getTemplate()) {
            elem.setAttribute("template", s.getTemplate());
        }
        elem.setAttribute("selectType", s.getSelectType());
        elem.setAttribute("required", Boolean.toString(s.isRequired()));
        ArrayList choices = s.getChoices();
        for (int i = 0; i < choices.size(); ++i) {
            elem.addContent(this.makeChoice((ListChoice)choices.get(i)));
        }
        return elem;
    }

    private SelectStation readSelectStation(QueryCapability qc, Element s) {
        String label = s.getAttributeValue("label");
        String id = s.getAttributeValue("id");
        String template = s.getAttributeValue("template");
        String selectType = s.getAttributeValue("selectType");
        String required = s.getAttributeValue("required");
        String multiple = "false";
        if (selectType.equals("multiple")) {
            multiple = "true";
        }
        SelectStation ss = new SelectStation(label, id, template, required, multiple);
        qc.addUniqueSelector(ss);
        List stations = s.getChildren("station", defNS);
        for (int j = 0; j < stations.size(); ++j) {
            Station station = this.readStation(ss, (Element)stations.get(j));
            ss.addStation(station);
        }
        return ss;
    }

    private Element makeSelectStation(SelectStation s) {
        Element elem = new Element("selectStation", defNS);
        elem.setAttribute("label", s.getTitle());
        if (null != s.getId()) {
            elem.setAttribute("id", s.getId());
        }
        if (null != s.getTemplate()) {
            elem.setAttribute("template", s.getTemplate());
        }
        elem.setAttribute("selectType", s.getSelectType());
        elem.setAttribute("required", Boolean.toString(s.isRequired()));
        ArrayList stations = s.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            elem.addContent(this.makeStation((Station)stations.get(i)));
        }
        return elem;
    }

    private ListChoice readChoice(QueryCapability qc, Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        String description = elem.getAttributeValue("description");
        ListChoice c = new ListChoice(parent, name, value, description);
        List children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            Element child = (Element)children.get(j);
            String childName = child.getName();
            if (!childName.equals("selectList")) continue;
            c.addNestedSelector(this.readSelectList(qc, child));
        }
        return c;
    }

    private Element makeChoice(ListChoice c) {
        Element elem = new Element("choice", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        ArrayList selectors = c.getNestedSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s = (Selector)selectors.get(i);
            if (!(s instanceof SelectList)) continue;
            elem.addContent(this.makeSelectList((SelectList)s));
        }
        return elem;
    }

    private Station readStation(Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        String description = elem.getAttributeValue("description");
        Station station = new Station(parent, name, value, description);
        Element locationElem = elem.getChild("location", defNS);
        if (null == locationElem) {
            locationElem = elem.getChild("location3D", defNS);
        }
        String latitude = locationElem.getAttributeValue("latitude");
        String longitude = locationElem.getAttributeValue("longitude");
        String elevation = locationElem.getAttributeValue("elevation");
        String latitude_units = locationElem.getAttributeValue("latitude_units");
        String longitude_units = locationElem.getAttributeValue("longitude_units");
        String elevation_units = locationElem.getAttributeValue("elevation_units");
        Location location = new Location(latitude, longitude, elevation, latitude_units, longitude_units, elevation_units);
        station.setLocation(location);
        return station;
    }

    private Element makeStation(Station c) {
        Element elem = new Element("station", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        Location l = c.getLocation();
        Element locationElem = new Element(l.hasElevation() ? "location3D" : "location", defNS);
        locationElem.setAttribute("latitude", Double.toString(l.getLatitude()));
        locationElem.setAttribute("longitude", Double.toString(l.getLongitude()));
        if (null != l.getLatitudeUnits()) {
            locationElem.setAttribute("latitude_units", l.getLatitudeUnits());
        }
        if (null != l.getLongitudeUnits()) {
            locationElem.setAttribute("longitude_units", l.getLongitudeUnits());
        }
        if (l.hasElevation()) {
            locationElem.setAttribute("elevation", Double.toString(l.getElevation()));
            if (null != l.getElevationUnits()) {
                locationElem.setAttribute("elevation_units", l.getElevationUnits());
            }
        }
        elem.addContent(locationElem);
        return elem;
    }

    public void writeXML(QueryCapability qc, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter();
        fmt.output(this.makeQC(qc), os);
    }
}

