/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataType;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.datatype.DateType;
import thredds.datatype.TimeDuration;

public class ThreddsMetadata {
    protected boolean inherited;
    protected ArrayList creators = new ArrayList();
    protected ArrayList contributors = new ArrayList();
    protected ArrayList dates = new ArrayList();
    protected ArrayList docs = new ArrayList();
    protected ArrayList keywords = new ArrayList();
    protected ArrayList metadata = new ArrayList();
    protected ArrayList projects = new ArrayList();
    protected ArrayList properties = new ArrayList();
    protected ArrayList publishers = new ArrayList();
    protected ArrayList variables = new ArrayList();
    protected GeospatialCoverage gc;
    protected TimeCoverage tc;
    protected String authorityName;
    protected String serviceName;
    protected DataType dataType;
    protected DataFormatType dataFormat;
    protected double dataSize = 0.0;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ThreddsMetadata(boolean inherited) {
        this.inherited = inherited;
    }

    public void add(ThreddsMetadata tmd) {
        this.creators.addAll(tmd.getCreators());
        this.contributors.addAll(tmd.getContributors());
        this.dates.addAll(tmd.getDates());
        this.docs.addAll(tmd.getDocumentation());
        this.keywords.addAll(tmd.getKeywords());
        this.metadata.addAll(tmd.getMetadata());
        this.projects.addAll(tmd.getProjects());
        this.properties.addAll(tmd.getProperties());
        this.publishers.addAll(tmd.getPublishers());
        this.variables.addAll(tmd.getVariables());
        if (this.gc == null) {
            this.gc = tmd.getGeospatialCoverage();
        }
        if (this.tc == null) {
            this.tc = tmd.getTimeCoverage();
        }
        if (this.serviceName == null) {
            this.serviceName = tmd.getServiceName();
        }
        if (this.dataType == null) {
            this.dataType = tmd.getDataType();
        }
        if (this.dataFormat == null) {
            this.dataFormat = tmd.getDataFormatType();
        }
        if (this.authorityName == null) {
            this.authorityName = tmd.getAuthority();
        }
    }

    public void addCreator(Source c) {
        if (c != null) {
            this.creators.add(c);
        }
    }

    public ArrayList getCreators() {
        return this.creators;
    }

    public void setCreators(ArrayList creators) {
        this.creators = creators;
    }

    public void addContributor(Contributor c) {
        if (c != null) {
            this.contributors.add(c);
        }
    }

    public ArrayList getContributors() {
        return this.contributors;
    }

    public void setContributors(ArrayList contributors) {
        this.contributors = contributors;
    }

    public void addDate(DateType d) {
        if (d != null) {
            this.dates.add(d);
        }
    }

    public List getDates() {
        return this.dates;
    }

    public void addDocumentation(InvDocumentation d) {
        if (d != null) {
            this.docs.add(d);
        }
    }

    public List getDocumentation() {
        return this.docs;
    }

    public void addKeyword(Vocab v) {
        if (v != null) {
            this.keywords.add(v);
        }
    }

    public ArrayList getKeywords() {
        return this.keywords;
    }

    public void setKeywords(ArrayList keywords) {
        this.keywords = keywords;
    }

    public void addMetadata(InvMetadata m) {
        if (m != null) {
            this.metadata.add(m);
        }
    }

    public void removeMetadata(InvMetadata m) {
        this.metadata.remove(m);
    }

    public List getMetadata() {
        return this.metadata;
    }

    public void addProject(Vocab v) {
        if (v != null) {
            this.projects.add(v);
        }
    }

    public ArrayList getProjects() {
        return this.projects;
    }

    public void setProjects(ArrayList projects) {
        this.projects = projects;
    }

    public void addProperty(InvProperty p) {
        if (p != null) {
            this.properties.add(p);
        }
    }

    public List getProperties() {
        return this.properties;
    }

    public void addPublisher(Source p) {
        if (p != null) {
            this.publishers.add(p);
        }
    }

    public List getPublishers() {
        return this.publishers;
    }

    public void setPublishers(ArrayList publishers) {
        this.publishers = publishers;
    }

    public void addVariables(Variables vs) {
        if (vs != null) {
            this.variables.add(vs);
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public void setGeospatialCoverage(GeospatialCoverage gc) {
        this.gc = gc;
    }

    public GeospatialCoverage getGeospatialCoverage() {
        return this.gc;
    }

    public void setTimeCoverage(TimeCoverage tc) {
        this.tc = tc;
    }

    public TimeCoverage getTimeCoverage() {
        return this.tc;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormat;
    }

    public void setDataFormatType(DataFormatType dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getAuthority() {
        return this.authorityName;
    }

    public void setAuthority(String authorityName) {
        this.authorityName = authorityName;
    }

    public String getDocumentation(String type) {
        List docs = this.getDocumentation();
        for (int i = 0; i < docs.size(); ++i) {
            InvDocumentation doc = (InvDocumentation)docs.get(i);
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            return doc.getInlineContent();
        }
        return null;
    }

    public String getHistory() {
        return this.getDocumentation("history");
    }

    public void setHistory(String history) {
        this.addDocumentation("history", history);
    }

    public String getProcessing() {
        return this.getDocumentation("processing_level");
    }

    public void setProcessing(String processing) {
        this.addDocumentation("processing_level", processing);
    }

    public String getRights() {
        return this.getDocumentation("rights");
    }

    public void setRights(String rights) {
        this.addDocumentation("rights", rights);
    }

    public String getSummary() {
        return this.getDocumentation("summary");
    }

    public void setSummary(String summary) {
        this.addDocumentation("summary", summary);
    }

    public double getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(double size) {
        this.dataSize = size;
    }

    public boolean hasDataSize() {
        return this.dataSize != 0.0 && !Double.isNaN(this.dataSize);
    }

    public void addDocumentation(String type, String s) {
        if (s == null) {
            return;
        }
        s.trim();
        List docs = this.getDocumentation();
        for (int i = 0; i < docs.size(); ++i) {
            InvDocumentation doc = (InvDocumentation)docs.get(i);
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            doc.setInlineContent(s);
            return;
        }
        if (s.length() > 0) {
            this.addDocumentation(new InvDocumentation(null, null, null, type, s));
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class Variables {
        private String vocab;
        private String vocabHref;
        private String mapHref;
        private URI vocabUri;
        private URI mapUri;
        private ArrayList variables = new ArrayList();
        private boolean isInit = false;
        private volatile int hashCode = 0;

        public Variables(String vocab, String vocabHref, URI vocabUri, String mapHref, URI mapUri) {
            this.vocab = vocab;
            this.vocabHref = vocabHref;
            this.vocabUri = vocabUri;
            this.mapHref = mapHref;
            this.mapUri = mapUri;
        }

        public String getVocabulary() {
            return this.vocab;
        }

        public String getVocabHref() {
            return this.vocabHref;
        }

        public URI getVocabUri() {
            return this.vocabUri;
        }

        public URI getMapUri() {
            return this.mapUri;
        }

        public String getMapHref() {
            return this.mapHref;
        }

        public void addVariable(Variable v) {
            this.variables.add(v);
        }

        public List getVariableList() {
            this.init();
            return this.variables;
        }

        private void init() {
            if (this.isInit || this.mapUri != null) {
                return;
            }
            this.isInit = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variables)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                if (null != this.getVocabUri()) {
                    result = 37 * result + this.getVocabUri().hashCode();
                }
                if (null != this.getMapUri()) {
                    result = 37 * result + this.getMapUri().hashCode();
                }
                if (null != this.getVariableList()) {
                    result = 37 * result + ((Object)this.getVariableList()).hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class Variable {
        private String name;
        private String vocabulary_name;
        private String units;
        private volatile int hashCode = 0;

        public Variable(String name, String vocabulary_name, String units) {
            this.name = name;
            this.vocabulary_name = vocabulary_name;
            this.units = units;
        }

        public String getName() {
            return this.name;
        }

        public String getVocabularyName() {
            return this.vocabulary_name;
        }

        public String getUnits() {
            return this.units;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variable)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getName()) {
                    result = 37 * result + this.getName().hashCode();
                }
                if (null != this.getVocabularyName()) {
                    result = 37 * result + this.getVocabularyName().hashCode();
                }
                if (null != this.getUnits()) {
                    result = 37 * result + this.getUnits().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class TimeCoverage {
        private static TimeCoverage empty = new TimeCoverage();
        private DateType start;
        private DateType end;
        private TimeDuration duration;
        private TimeDuration resolution;
        private double durationSecs;
        boolean hasStart;
        boolean hasEnd;
        boolean hasDuration;
        boolean invalid;
        private DateType _start;
        private DateType _end;
        private volatile int hashCode = 0;

        public TimeCoverage() {
        }

        public TimeCoverage(DateType start, DateType end, TimeDuration duration, TimeDuration resolution) {
            this.start = start;
            this.end = end;
            this.duration = duration;
            this.resolution = resolution;
            this.recalc();
        }

        private void recalc() {
            this.hasStart = this.start != null && !this.start.isBlank();
            this.hasEnd = this.end != null && !this.end.isBlank();
            this.hasDuration = this.duration != null && !this.duration.isBlank();
            this.invalid = true;
            if (this.hasStart && this.hasEnd) {
                this.invalid = false;
            } else if (this.hasStart && this.hasDuration) {
                this.invalid = false;
                this._end = this.start.add(this.duration);
            } else if (this.hasEnd && this.hasDuration) {
                this.invalid = false;
                this._start = this.end.subtract(this.duration);
            }
            this.hashCode = 0;
        }

        public boolean isEmpty() {
            return this.equals(empty);
        }

        public boolean included(Date d) {
            if (this.invalid) {
                return false;
            }
            if (this.hasStart && this.hasEnd) {
                if (this.start.after(d)) {
                    return false;
                }
                if (this.end.before(d)) {
                    return false;
                }
            } else if (this.hasStart && this.hasDuration) {
                if (this.start.after(d)) {
                    return false;
                }
                if (this._end.before(d)) {
                    return false;
                }
            } else if (this.hasEnd && this.hasDuration) {
                if (this._start.after(d)) {
                    return false;
                }
                if (this.end.before(d)) {
                    return false;
                }
            }
            return true;
        }

        public DateType getStart() {
            return this.start;
        }

        public void setStart(DateType start) {
            this.start = start;
            this.recalc();
        }

        public DateType getEnd() {
            return this.end;
        }

        public void setEnd(DateType end) {
            this.end = end;
            this.recalc();
        }

        public TimeDuration getDuration() {
            return this.duration;
        }

        public void setDuration(TimeDuration duration) {
            this.duration = duration;
            this.recalc();
        }

        public TimeDuration getResolution() {
            return this.resolution;
        }

        public void setResolution(TimeDuration resolution) {
            this.resolution = resolution;
            this.recalc();
        }

        public String toString() {
            return "start= " + this.start + " end= " + this.end + " duration= " + this.duration + " resolution= " + this.resolution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeCoverage)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (this.hasStart && !this.start.isBlank()) {
                    result = 37 * result + this.start.hashCode();
                }
                if (this.hasEnd && !this.end.isBlank()) {
                    result = 37 * result + this.end.hashCode();
                }
                if (this.hasDuration && !this.duration.isBlank()) {
                    result = 37 * result + this.duration.hashCode();
                }
                if (this.resolution != null && !this.resolution.isBlank()) {
                    result = 37 * result + this.resolution.hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class Range {
        private double start;
        private double size;
        private double resolution;
        private String units;
        private volatile int hashCode = 0;

        public Range(double start, double size, double resolution, String units) {
            this.start = start;
            this.size = size;
            this.resolution = resolution;
            this.units = units;
        }

        public double getStart() {
            return this.start;
        }

        public double getSize() {
            return this.size;
        }

        public double getResolution() {
            return this.resolution;
        }

        public String getUnits() {
            return this.units;
        }

        public boolean hasResolution() {
            return this.resolution != 0.0 && !Double.isNaN(this.resolution);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getUnits()) {
                    result = 37 * result + this.getUnits().hashCode();
                }
                result = 37 * result + (int)(this.getStart() * 1000.0);
                result = 37 * result + (int)(this.getSize() * 1000.0);
                if (this.hasResolution()) {
                    result = 37 * result + (int)(this.getResolution() * 1000.0);
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class GeospatialCoverage {
        private static GeospatialCoverage empty = new GeospatialCoverage();
        private Range eastwest;
        private Range northsouth;
        private Range updown;
        private boolean isGlobal = false;
        private String zpositive = "up";
        private List names = new ArrayList();
        private volatile int hashCode = 0;

        public GeospatialCoverage() {
            this.eastwest = new Range(-180.0, 360.0, 0.0, "degrees_east");
            this.northsouth = new Range(-90.0, 180.0, 0.0, "degrees_north");
            this.updown = new Range(0.0, 0.0, 0.0, "km");
        }

        public GeospatialCoverage(Range eastwest, Range northsouth, Range updown, List names, String zpositive) {
            this.eastwest = eastwest != null ? eastwest : new Range(-180.0, 360.0, 0.0, "degrees_east");
            this.northsouth = northsouth != null ? northsouth : new Range(-90.0, 180.0, 0.0, "degrees_north");
            Range range = this.updown = updown != null ? updown : new Range(0.0, 0.0, 0.0, "km");
            if (names != null) {
                this.names = new ArrayList(names);
            }
            this.zpositive = zpositive;
            for (int i = 0; i < names.size(); ++i) {
                String elem = ((Vocab)names.get(i)).getText();
                if (!elem.equalsIgnoreCase("global")) continue;
                this.isGlobal = true;
            }
        }

        public boolean isEmpty() {
            return this.equals(empty);
        }

        public Range getEastWestRange() {
            return this.eastwest;
        }

        public Range getNorthSouthRange() {
            return this.northsouth;
        }

        public Range getUpDownRange() {
            return this.updown;
        }

        public List getNames() {
            return this.names;
        }

        public String getZPositive() {
            return this.zpositive;
        }

        public void setZPositive(String positive) {
            this.zpositive = positive;
            this.hashCode = 0;
        }

        public boolean isValid() {
            return this.isGlobal || this.eastwest != null && this.northsouth != null;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }

        public void setGlobal(boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.hashCode = 0;
        }

        public double getLatStart() {
            return this.northsouth.start;
        }

        public void setLatStart(double start) {
            this.northsouth.start = start;
            this.hashCode = 0;
        }

        public double getLatExtent() {
            return this.northsouth.size;
        }

        public void setLatExtent(double size) {
            this.northsouth.size = size;
            this.hashCode = 0;
        }

        public double getLatResolution() {
            return this.northsouth.resolution;
        }

        public void setLatResolution(double resolution) {
            this.northsouth.resolution = resolution;
            this.hashCode = 0;
        }

        public String getLatUnits() {
            return this.northsouth.units;
        }

        public void setLatUnits(String units) {
            this.northsouth.units = units;
            this.hashCode = 0;
        }

        public double getLatNorth() {
            return Math.max(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLatSouth() {
            return Math.min(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLonStart() {
            return this.eastwest.start;
        }

        public void setLonStart(double start) {
            this.eastwest.start = start;
            this.hashCode = 0;
        }

        public double getLonExtent() {
            return this.eastwest.size;
        }

        public void setLonExtent(double size) {
            this.eastwest.size = size;
            this.hashCode = 0;
        }

        public double getLonResolution() {
            return this.eastwest.resolution;
        }

        public void setLonResolution(double resolution) {
            this.eastwest.resolution = resolution;
            this.hashCode = 0;
        }

        public String getLonUnits() {
            return this.eastwest.units;
        }

        public void setLonUnits(String units) {
            this.eastwest.units = units;
            this.hashCode = 0;
        }

        public double getLonEast() {
            return Math.max(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getLonWest() {
            return Math.min(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getHeightStart() {
            return this.updown == null ? 0.0 : this.updown.start;
        }

        public void setHeightStart(double start) {
            if (this.updown != null) {
                this.updown.start = start;
            }
            this.hashCode = 0;
        }

        public double getHeightExtent() {
            return this.updown == null ? 0.0 : this.updown.size;
        }

        public void setHeightExtent(double size) {
            if (this.updown != null) {
                this.updown.size = size;
            }
            this.hashCode = 0;
        }

        public double getHeightResolution() {
            return this.updown == null ? 0.0 : this.updown.resolution;
        }

        public void setHeightResolution(double resolution) {
            if (this.updown != null) {
                this.updown.resolution = resolution;
            }
            this.hashCode = 0;
        }

        public String getHeightUnits() {
            return this.updown == null ? null : this.updown.units;
        }

        public void setHeightUnits(String units) {
            if (this.updown != null) {
                this.updown.units = units;
            }
            this.hashCode = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeospatialCoverage)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getEastWestRange()) {
                    result = 37 * result + this.getEastWestRange().hashCode();
                }
                if (null != this.getNorthSouthRange()) {
                    result = 37 * result + this.getNorthSouthRange().hashCode();
                }
                if (null != this.getUpDownRange()) {
                    result = 37 * result + this.getUpDownRange().hashCode();
                }
                if (null != this.getNames()) {
                    result = 37 * result + ((Object)this.getNames()).hashCode();
                }
                if (null != this.getZPositive()) {
                    result = 2 * result + this.getZPositive().hashCode();
                }
                this.hashCode = result = 2 * result + (this.isGlobal() ? 1 : 0);
            }
            return this.hashCode;
        }
    }

    public static class Vocab {
        private String text;
        private String vocabulary;
        private volatile int hashCode = 0;

        public Vocab() {
        }

        public Vocab(String text, String vocabulary) {
            this.text = text;
            this.vocabulary = vocabulary;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.hashCode = 0;
        }

        public String getVocabulary() {
            return this.vocabulary;
        }

        public void setVocabulary(String vocabulary) {
            this.vocabulary = vocabulary;
            this.hashCode = 0;
        }

        public static String editableProperties() {
            return "text vocabulary";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Vocab)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getText()) {
                    result = 37 * result + this.getText().hashCode();
                }
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class Source {
        private Vocab name;
        private Vocab long_name;
        private String url;
        private String email;
        private volatile int hashCode = 0;

        public Source() {
            this.name = new Vocab();
            this.long_name = new Vocab();
        }

        public Source(Vocab name, String url, String email) {
            this.name = name;
            this.url = url;
            this.email = email;
        }

        public Vocab getNameVocab() {
            return this.name;
        }

        public String getName() {
            return this.name.getText();
        }

        public void setName(String name) {
            this.name.setText(name);
            this.hashCode = 0;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
            this.hashCode = 0;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
            this.hashCode = 0;
        }

        public String getVocabulary() {
            return this.name.getVocabulary();
        }

        public void setVocabulary(String vocabulary) {
            this.name.setVocabulary(vocabulary);
            this.long_name.setVocabulary(vocabulary);
            this.hashCode = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getName().hashCode();
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                if (null != this.getUrl()) {
                    result = 37 * result + this.getUrl().hashCode();
                }
                if (null != this.getEmail()) {
                    result = 37 * result + this.getEmail().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public static String hiddenProperties() {
            return "nameVocab";
        }

        public static String editableProperties() {
            return "name email url vocabulary";
        }
    }

    public static class Contributor {
        private String name;
        private String role;
        private volatile int hashCode = 0;

        public Contributor() {
        }

        public Contributor(String name, String role) {
            this.name = name;
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.hashCode = 0;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
            this.hashCode = 0;
        }

        public static String editableProperties() {
            return "role name";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Contributor)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getName().hashCode();
                if (null != this.getRole()) {
                    result = 37 * result + this.getRole().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }
}

