/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import thredds.util.IO;
import thredds.util.Resource;
import thredds.util.reflect.ProxyGenerator;

public class JaxpFactory {
    private static boolean debugEntityResolution = false;
    private static boolean debugFactory = false;
    private static boolean debugMessages = false;
    private static DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private static HashMap entityHash = new HashMap();
    private static boolean schemaValidationOk = true;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String CATALOG_NAMESPACE_06 = "http://www.unidata.ucar.edu/thredds";
    public static final String CATALOG_NAMESPACE_10 = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0";
    public static final String DQC_NAMESPACE_02 = "http://www.unidata.ucar.edu/schemas/thredds/queryCapability";
    public static final String DQC_NAMESPACE_03 = "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.3";
    public static final String NJ22_NAMESPACE = "http://www.unidata.ucar.edu/schemas/netcdf/nj22";
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private DocumentBuilder builder;
    private HashMap versionHash = new HashMap(10);
    private StringBuffer warnMessages = new StringBuffer();
    private StringBuffer errMessages = new StringBuffer();
    private StringBuffer fatalMessages = new StringBuffer();
    private String version = "";

    private static void initEntity(String entityName, String resourceName, String urlName) {
        String entity = null;
        try {
            ByteArrayOutputStream sbuff = new ByteArrayOutputStream(3000);
            InputStream is = Resource.getFileResource(resourceName);
            if (is != null) {
                IO.copy(is, sbuff);
                entity = sbuff.toString();
                if (debugEntityResolution) {
                    System.out.println(" *** entity " + entityName + " mapped to local resource at " + resourceName);
                }
            } else if (urlName != null) {
                entity = IO.readURLcontentsWithException(urlName);
                if (debugEntityResolution) {
                    System.out.println(" *** entity " + entityName + " mapped to remote URL at " + urlName);
                }
            }
        }
        catch (IOException e) {
            System.out.println(" *** FAILED to map entity " + entityName + " locally at " + resourceName + " or remotely at " + urlName);
        }
        entityHash.put(entityName, entity);
        entityHash.put(urlName, entity);
    }

    private static void showFactoryInfo(DocumentBuilderFactory factory) {
        System.out.println("------------------------");
        System.out.println("DocumentBuilderFactory class= " + factory.getClass().getName());
        try {
            Class<?> version = Class.forName("org.apache.xerces.impl.Version");
            Method m = version.getMethod("getVersion", null);
            System.out.println(" org.apache.xerces.impl.Version.version()=" + m.invoke(null, null));
            ProxyGenerator.showMethods(factory.getClass(), System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(" factory.isValidating()=" + factory.isValidating());
        System.out.println(" factory.isNamespaceAware()=" + factory.isNamespaceAware());
        System.out.println(" factory.isIgnoringElementContentWhitespace()=" + factory.isIgnoringElementContentWhitespace());
        System.out.println(" factory.isExpandEntityReferences()=" + factory.isExpandEntityReferences());
        System.out.println(" factory.isIgnoringComments()=" + factory.isIgnoringComments());
        System.out.println(" factory.isCoalescing()=" + factory.isCoalescing());
    }

    private static void showBuilderInfo(DocumentBuilder builder) {
        System.out.println("-----------------------");
        System.out.println(" builder.isValidating()=" + builder.isValidating());
        System.out.println(" builder.isNamespaceAware()=" + builder.isNamespaceAware());
        System.out.println("DocumentBuilder class= " + builder.getClass().getName());
        try {
            ProxyGenerator.showMethods(builder.getClass(), System.out);
            ProxyGenerator.showMethods(builder.getDOMImplementation().getClass(), System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxpFactory(boolean validate) {
        try {
            DocumentBuilderFactory documentBuilderFactory = docBuilderFactory;
            synchronized (documentBuilderFactory) {
                docBuilderFactory.setValidating(validate && schemaValidationOk);
                this.builder = docBuilderFactory.newDocumentBuilder();
            }
            this.builder.setEntityResolver(new MyEntityResolver());
            this.builder.setErrorHandler(new MyErrorHandler());
            if (debugFactory) {
                JaxpFactory.showBuilderInfo(this.builder);
            }
        }
        catch (ParserConfigurationException e) {
            System.out.println("The underlying parser does not support the requested features.");
            throw new UnsupportedOperationException();
        }
        catch (FactoryConfigurationError e) {
            System.out.println("Error occurred obtaining Document Builder Factory.");
            throw new UnsupportedOperationException();
        }
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public StringBuffer getWarningMessages() {
        return this.warnMessages;
    }

    public StringBuffer getErrorMessages() {
        return this.errMessages;
    }

    public StringBuffer getFatalMessages() {
        return this.fatalMessages;
    }

    public String getVersion() {
        return this.version;
    }

    private static void doOne(JaxpFactory fac, DocumentBuilder builder, String url) {
        System.out.println("***read " + url);
        fac.getFatalMessages().setLength(0);
        fac.getErrorMessages().setLength(0);
        try {
            Document doc = builder.parse(url);
            System.out.println(" fatal= " + fac.getFatalMessages());
            System.out.println(" errors= " + fac.getErrorMessages());
            System.out.println(" warn= " + fac.getWarningMessages());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        JaxpFactory fac = new JaxpFactory(true);
        DocumentBuilder builder = fac.getDocumentBuilder();
        JaxpFactory.doOne(fac, builder, "file:///C:/dev/thredds/catalog/test/data/Example1.0rc7.xml");
    }

    static {
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        if (schemaValidationOk) {
            try {
                docBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_NAMESPACE);
                docBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, new String[]{CATALOG_NAMESPACE_06, CATALOG_NAMESPACE_10, XLINK_NAMESPACE, DQC_NAMESPACE_02, DQC_NAMESPACE_03});
            }
            catch (IllegalArgumentException e) {
                System.out.println("***XML Parser does not support JAXP 1.2; schema validation not set\n" + e);
                schemaValidationOk = false;
            }
        }
        if (debugFactory) {
            JaxpFactory.showFactoryInfo(docBuilderFactory);
        }
        JaxpFactory.initEntity("http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd", "/resources/xml/InvCatalog.0.6.dtd", "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd");
        JaxpFactory.initEntity(CATALOG_NAMESPACE_10, "/resources/xml/InvCatalog.1.0.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.xsd");
        JaxpFactory.initEntity(CATALOG_NAMESPACE_06, "/resources/xml/InvCatalog.0.6.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.xsd");
        JaxpFactory.initEntity(DQC_NAMESPACE_02, "/resources/xml/queryCapability.0.2.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.2.xsd");
        JaxpFactory.initEntity(DQC_NAMESPACE_03, "/resources/xml/queryCapability.0.3.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.3.xsd");
        JaxpFactory.initEntity(NJ22_NAMESPACE, "/resources/xml/ncml-2.2.xsd", "http://www.unidata.ucar.edu/schemas/netcdf/ncml-2.2.xsd");
        JaxpFactory.initEntity(XLINK_NAMESPACE, "/resources/xml/xlink.xsd", "http://www.unidata.ucar.edu/schemas/other/xlink.xsd");
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            JaxpFactory.this.warnMessages.append("*** XML parser warning=" + e.getMessage() + "\n");
            if (debugMessages) {
                System.out.println("*** XML parser warning=" + e.getMessage() + "\n");
            }
        }

        public void error(SAXParseException e) throws SAXException {
            JaxpFactory.this.errMessages.append("*** XML parser error=" + e.getMessage() + "\n");
            if (debugMessages) {
                System.out.println("*** XML parser error=" + e.getMessage() + "\n");
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            JaxpFactory.this.fatalMessages.append("*** XML parser fatalError=" + e.getMessage() + "\n");
            if (debugMessages) {
                System.out.println("*** XML parser fatalError=" + e.getMessage() + "\n");
            }
        }
    }

    private class MyInputSource
    extends InputSource {
        MyInputSource(String entity) {
            this.setCharacterStream(new StringReader(entity));
        }
    }

    private class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String entity;
            if (debugEntityResolution) {
                System.out.print("  publicId=" + publicId + " systemId=" + systemId);
            }
            if ((entity = (String)entityHash.get(systemId)) != null) {
                if (debugEntityResolution) {
                    System.out.println(" *** resolved  with local copy");
                }
                return new MyInputSource(entity);
            }
            if (systemId.indexOf("InvCatalog.0.6.dtd") >= 0 && (entity = (String)entityHash.get("http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd")) != null) {
                if (debugEntityResolution) {
                    System.out.println(" *** resolved2 with local copy");
                }
                return new MyInputSource(entity);
            }
            if (debugEntityResolution) {
                System.out.println(" *** not resolved");
            }
            return null;
        }
    }
}

