/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.ServiceType;

public class InvService {
    private String name;
    private String base;
    private String suffix;
    private String desc;
    private ServiceType type = null;
    private URI uri = null;
    private ArrayList nestedServices = new ArrayList();
    private ArrayList properties = new ArrayList();
    private StringBuffer log = new StringBuffer();
    private volatile int hashCode = 0;

    public InvService(String name, String serviceTypeName, String base, String suffix, String desc) {
        this.name = name;
        this.type = ServiceType.getType(serviceTypeName);
        this.base = base.trim();
        this.suffix = suffix == null ? "" : suffix.trim();
        this.desc = desc;
        if (this.type == null) {
            this.log.append(" ** InvService: non-standard type =(" + serviceTypeName + ") for service (" + name + ")");
            this.type = new ServiceType(serviceTypeName);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getBase() {
        return this.base;
    }

    public ServiceType getServiceType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDescription() {
        return this.desc != null ? this.desc : this.type.toString();
    }

    public List getProperties() {
        return this.properties;
    }

    public String findProperty(String name) {
        InvProperty result = null;
        for (int i = 0; i < this.properties.size(); ++i) {
            InvProperty p = (InvProperty)this.properties.get(i);
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public String toString() {
        return "name:(" + this.name + ") type:(" + this.type + ") base:(" + this.base + ") suffix:(" + this.suffix + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvService)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getBase().hashCode();
            result = 37 * result + this.getServiceType().hashCode();
            if (null != this.getSuffix()) {
                result = 37 * result + this.getSuffix().hashCode();
            }
            result = 37 * result + ((Object)this.getProperties()).hashCode();
            this.hashCode = result = 37 * result + this.nestedServices.hashCode();
        }
        return this.hashCode;
    }

    public String dump() {
        return this.dump(0);
    }

    String dump(int n) {
        List props;
        StringBuffer buff = new StringBuffer(200);
        buff.setLength(0);
        buff.append(InvDatasetImpl.indent(n) + "Service " + this + "\n");
        List svs = this.getServices();
        if (svs.size() > 0) {
            for (int i = 0; i < svs.size(); ++i) {
                InvService s = (InvService)svs.get(i);
                buff.append(s.dump(n + 2));
            }
        }
        if ((props = this.getProperties()).size() > 0) {
            String indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Properties:\n");
            for (int i = 0; i < props.size(); ++i) {
                InvProperty p = (InvProperty)props.get(i);
                buff.append(InvDatasetImpl.indent(n + 4) + p + "\n");
            }
        }
        return buff.toString();
    }

    public void addService(InvService service) {
        this.nestedServices.add(service);
    }

    public void addProperty(InvProperty p) {
        this.properties.add(p);
    }

    public List getServices() {
        return this.nestedServices;
    }

    public String getFullName() {
        return this.name;
    }

    protected boolean check(StringBuffer out) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (this.getServiceType() == ServiceType.COMPOUND) {
            if (this.getServices().size() < 1) {
                out.append(" ** InvService (" + this.getName() + ") type COMPOUND must have a nested service\n");
                isValid = false;
            }
        } else if (this.getServices().size() > 0) {
            out.append(" ** InvService(" + this.getName() + ") type " + this.getServiceType() + " may not have nested services\n");
            isValid = false;
        }
        try {
            this.uri = new URI(this.base);
        }
        catch (URISyntaxException e) {
            out.append(" ** InvService(" + this.getName() + ") invalid base URL =(" + this.base + ")");
            isValid = false;
        }
        return isValid;
    }
}

