/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import thredds.catalog.InvDataset;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.ThreddsMetadata;

public class InvMetadata {
    private InvDataset dataset;
    private String title;
    private String type;
    private String xlinkHref;
    private URI xlinkUri = null;
    private String namespaceURI;
    private String prefix;
    private boolean isInherited;
    private boolean isThreddsMetadata = true;
    private MetadataConverterIF converter = null;
    private Object contentObject = null;
    private ThreddsMetadata tm = null;
    private StringBuffer log = new StringBuffer();
    private boolean debug = false;
    private boolean init = false;
    private volatile int hashCode = 0;

    public InvMetadata(InvDataset dataset, String xlinkHref, String title, String type, String namespaceURI, String prefix, boolean inherited, boolean isThreddsMetadata, MetadataConverterIF converter) {
        this.dataset = dataset;
        this.xlinkHref = xlinkHref;
        this.title = title;
        this.type = type;
        this.namespaceURI = namespaceURI;
        this.prefix = prefix;
        this.isInherited = inherited;
        this.isThreddsMetadata = isThreddsMetadata;
        this.converter = converter;
    }

    public InvMetadata(InvDataset dataset, String mtype, String namespaceURI, String namespacePrefix, boolean inherited, boolean isThreddsMetadata, MetadataConverterIF converter, Object contentObject) {
        this.dataset = dataset;
        this.type = mtype;
        this.namespaceURI = namespaceURI;
        this.prefix = namespacePrefix;
        this.isInherited = inherited;
        this.isThreddsMetadata = isThreddsMetadata;
        this.converter = converter;
        this.contentObject = contentObject;
        if (isThreddsMetadata) {
            this.tm = (ThreddsMetadata)contentObject;
        }
        this.init = true;
    }

    public InvDataset getParentDataset() {
        return this.dataset;
    }

    public MetadataConverterIF getConverter() {
        return this.converter;
    }

    public String getMetadataType() {
        return this.type;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNamespacePrefix() {
        return this.prefix;
    }

    public boolean hasXlink() {
        return this.xlinkHref != null;
    }

    public String getXlinkHref() {
        return this.xlinkHref;
    }

    public URI getXlinkURI() {
        return this.xlinkUri;
    }

    public String getXlinkTitle() {
        return this.title;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public boolean isThreddsMetadata() {
        return this.isThreddsMetadata;
    }

    public void setThreddsMetadata(boolean isThreddsMetadata) {
        this.isThreddsMetadata = isThreddsMetadata;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
        this.hashCode = 0;
    }

    public Object getContentObject() {
        this.finish();
        return this.contentObject;
    }

    public void setThreddsMetadata(ThreddsMetadata tmd) {
        this.tm = tmd;
    }

    public ThreddsMetadata getThreddsMetadata() {
        return this.tm;
    }

    public void finish() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.xlinkHref == null) {
            return;
        }
        this.xlinkHref = this.xlinkHref.trim();
        try {
            this.xlinkUri = this.dataset.getParentCatalog().resolveUri(this.xlinkHref);
        }
        catch (URISyntaxException e) {
            this.log.append(" ** Error: Bad URL in metadata href = " + this.xlinkHref + "\n");
            return;
        }
        try {
            if (this.converter == null) {
                this.log.append("  **InvMetadata on = (" + this + "): has no converter\n");
                return;
            }
            this.contentObject = this.converter.readMetadataContentFromURL(this.dataset, this.xlinkUri);
            if (this.isThreddsMetadata) {
                this.tm = (ThreddsMetadata)this.contentObject;
            }
        }
        catch (IOException e) {
            this.log.append("  **InvMetadata on = (" + this.xlinkUri + "): Exception (" + e.getMessage() + ")\n");
        }
    }

    boolean check(StringBuffer out) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            isValid = false;
            out.append(this.log);
        }
        if (this.contentObject != null) {
            isValid &= this.converter.validateMetadataContent(this.contentObject, out);
        }
        return isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvMetadata)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (null != this.getNamespaceURI()) {
                result = 37 * result + this.getNamespaceURI().hashCode();
            }
            if (null != this.getXlinkHref()) {
                result = 37 * result + this.getXlinkHref().hashCode();
            }
            if (null != this.getXlinkTitle()) {
                result = 37 * result + this.getXlinkTitle().hashCode();
            }
            if (null != this.getMetadataType()) {
                result = 37 * result + this.getMetadataType().hashCode();
            }
            result = 37 * result + (this.isInherited() ? 1 : 0);
            this.hashCode = result = 37 * result + (this.isThreddsMetadata() ? 1 : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        return " xlink = " + this.getXlinkHref() + " mtype= " + this.type + " namespaceURI=" + this.namespaceURI + " isThredds= " + this.isThreddsMetadata + " inherit= " + this.isInherited();
    }
}

