/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class InvDocumentation {
    private String href;
    private String title;
    private String type;
    private String inlineContent;
    private URI uri;
    private String content = null;
    private volatile int hashCode = 0;

    public InvDocumentation(String href, URI uri, String title, String type, String inlineContent) {
        this.href = href;
        this.uri = uri;
        this.title = title;
        this.type = type;
        this.inlineContent = inlineContent;
        if (uri != null && title == null) {
            this.title = uri.toString();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.hashCode = 0;
    }

    public boolean hasXlink() {
        return this.uri != null;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getXlinkTitle() {
        return this.title;
    }

    public String getXlinkHref() {
        return this.href;
    }

    public String getXlinkContent() throws MalformedURLException, IOException {
        int bytesRead;
        if (this.content != null) {
            return this.content;
        }
        URL url = this.uri.toURL();
        InputStream is = url.openStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        is.close();
        this.content = os.toString();
        return this.content;
    }

    public String getInlineContent() {
        return this.inlineContent;
    }

    public void setInlineContent(String s) {
        this.inlineContent = s;
        this.hashCode = 0;
    }

    public String toString() {
        if (this.hasXlink()) {
            return "<" + this.uri + "> <" + this.title + "> <" + this.type + ">" + (this.content == null ? "" : " <" + this.content + ">");
        }
        return "<" + this.inlineContent + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvDocumentation)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (null != this.getURI()) {
                result = 37 * result + this.getURI().hashCode();
            }
            if (null != this.getInlineContent()) {
                result = 37 * result + this.getInlineContent().hashCode();
            }
            if (null != this.getXlinkTitle()) {
                result = 37 * result + this.getXlinkTitle().hashCode();
            }
            if (null != this.getType()) {
                result = 37 * result + this.getType().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

