/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.datatype.DateType;
import thredds.datatype.TimeDuration;

public class InvDatasetImpl
extends InvDataset {
    private String urlPath;
    private String alias;
    private double size = 0.0;
    private ArrayList accessLocal = new ArrayList();
    private ArrayList servicesLocal = new ArrayList();
    protected ThreddsMetadata tm = new ThreddsMetadata(false);
    protected ThreddsMetadata tmi = new ThreddsMetadata(true);
    protected StringBuffer log = new StringBuffer();
    protected boolean mark = false;
    private boolean debugInherit = false;
    private HashMap userMap = null;
    private volatile int hashCode = 0;

    public InvDatasetImpl(InvDatasetImpl parent, String name, DataType dataType, String serviceName, String urlPath) {
        super(parent, name);
        this.tm.setDataType(dataType);
        this.tm.setServiceName(serviceName);
        this.urlPath = urlPath;
    }

    public boolean finish() {
        InvAccessImpl a;
        boolean ok = true;
        if (this.debugInherit) {
            System.out.println("Now finish " + this.getName() + " id= " + this.getID());
        }
        this.dataFormatType = null;
        this.gc = null;
        this.tc = null;
        this.docs = new ArrayList();
        this.metadata = new ArrayList();
        this.properties = new ArrayList();
        this.creators = new ArrayList();
        this.contributors = new ArrayList();
        this.dates = new ArrayList();
        this.keywords = new ArrayList();
        this.projects = new ArrayList();
        this.publishers = new ArrayList();
        this.variables = new ArrayList();
        this.transferMetadata(this.tm, true);
        this.transferMetadata(this.tmi, true);
        this.transferFromParents((InvDatasetImpl)this.getParent());
        this.access = new ArrayList();
        if (this.urlPath != null && this.getServiceDefault() != null) {
            a = new InvAccessImpl(this, this.urlPath, this.getServiceDefault());
            a.setSize(this.size);
            a.finish();
            this.addExpandedAccess(a);
        }
        Iterator iter = this.accessLocal.iterator();
        while (iter.hasNext()) {
            a = (InvAccessImpl)iter.next();
            a.finish();
            this.addExpandedAccess(a);
        }
        if (!(this instanceof InvCatalogRef)) {
            Iterator dsIter = this.getDatasets().iterator();
            while (dsIter.hasNext()) {
                InvDatasetImpl curDs = (InvDatasetImpl)dsIter.next();
                ok &= curDs.finish();
            }
        }
        return ok;
    }

    private void transferFromParents(InvDatasetImpl parent) {
        if (parent == null) {
            return;
        }
        if (this.debugInherit) {
            System.out.println(" inheritFromParent= " + parent.getID());
        }
        this.transferMetadata(parent.getLocalMetadataInherited(), true);
        ThreddsMetadata tmd = parent.getLocalMetadata();
        Iterator iter = tmd.getMetadata().iterator();
        while (iter.hasNext()) {
            InvMetadata meta = (InvMetadata)iter.next();
            if (!meta.isInherited()) continue;
            if (!meta.isThreddsMetadata()) {
                this.metadata.add(meta);
                continue;
            }
            if (this.debugInherit) {
                System.out.println("  inheritMetadata Element " + tmd.isInherited() + " " + meta.isInherited());
            }
            meta.finish();
            this.transferMetadata(meta.getThreddsMetadata(), false);
            this.metadata.add(meta);
        }
        this.transferFromParents((InvDatasetImpl)parent.getParent());
    }

    private void transferMetadata(ThreddsMetadata tmd, boolean inheritAll) {
        ThreddsMetadata.TimeCoverage ttc;
        ThreddsMetadata.GeospatialCoverage tgc;
        if (tmd == null) {
            return;
        }
        if (this.authorityName == null) {
            this.authorityName = tmd.getAuthority();
        }
        if (this.dataType == null || this.dataType == DataType.NONE) {
            this.dataType = tmd.getDataType();
        }
        if (this.dataFormatType == null || this.dataFormatType == DataFormatType.NONE) {
            this.dataFormatType = tmd.getDataFormatType();
        }
        if (this.defaultService == null) {
            this.defaultService = this.findService(tmd.getServiceName());
        }
        if (this.gc == null && (tgc = tmd.getGeospatialCoverage()) != null && !tgc.isEmpty()) {
            this.gc = tgc;
        }
        if (this.tc == null && (ttc = tmd.getTimeCoverage()) != null && !ttc.isEmpty()) {
            this.tc = ttc;
        }
        if (this.tc == null) {
            this.tc = tmd.getTimeCoverage();
        }
        Iterator iter = tmd.getProperties().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (this.properties.contains(item)) continue;
            if (this.debugInherit) {
                System.out.println("  add Property " + item + " to " + this.getID());
            }
            this.properties.add(item);
        }
        this.creators.addAll(tmd.getCreators());
        this.contributors.addAll(tmd.getContributors());
        this.dates.addAll(tmd.getDates());
        this.docs.addAll(tmd.getDocumentation());
        this.keywords.addAll(tmd.getKeywords());
        this.projects.addAll(tmd.getProjects());
        this.publishers.addAll(tmd.getPublishers());
        this.variables.addAll(tmd.getVariables());
        iter = tmd.getMetadata().iterator();
        while (iter.hasNext()) {
            InvMetadata meta = (InvMetadata)iter.next();
            if (!meta.isInherited() && !inheritAll) continue;
            if (!meta.isThreddsMetadata()) {
                this.metadata.add(meta);
                continue;
            }
            if (this.debugInherit) {
                System.out.println("  inheritMetadata Element " + tmd.isInherited() + " " + meta.isInherited());
            }
            meta.finish();
            this.transferMetadata(meta.getThreddsMetadata(), inheritAll);
            this.metadata.add(meta);
        }
    }

    private void addExpandedAccess(InvAccessImpl a) {
        InvService service = a.getService();
        if (null == service) {
            a.check(this.log, false);
            return;
        }
        if (service.getServiceType() == ServiceType.COMPOUND) {
            List serviceList = service.getServices();
            for (int i = 0; i < serviceList.size(); ++i) {
                InvService nestedService = (InvService)serviceList.get(i);
                InvAccessImpl nestedAccess = new InvAccessImpl(this, a.getUrlPath(), nestedService);
                this.addExpandedAccess(nestedAccess);
            }
        } else {
            this.access.add(a);
        }
    }

    public InvDatasetImpl(String urlPath, DataType dtype, ServiceType stype) {
        super(null, "local file");
        this.tm.setDataType(this.dataType);
        this.tm.setServiceName("anon");
        this.urlPath = urlPath;
        this.addService(new InvService(this.tm.getServiceName(), stype.toString(), "", "", null));
        this.finish();
    }

    public InvDatasetImpl(InvDataset parent, String name) {
        super(parent, name);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.hashCode = 0;
    }

    public void setCatalog(InvCatalog catalog) {
        this.catalog = catalog;
        this.hashCode = 0;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        this.hashCode = 0;
    }

    public void setAuthority(String authorityName) {
        this.tm.setAuthority(authorityName);
        this.hashCode = 0;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        this.hashCode = 0;
    }

    public void setHarvest(boolean harvest) {
        this.harvest = harvest;
        this.hashCode = 0;
    }

    public void setID(String id) {
        this.id = id;
        this.hashCode = 0;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode = 0;
    }

    public void setParent(InvDatasetImpl parent) {
        this.parent = parent;
        this.hashCode = 0;
    }

    public void setGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        this.tm.setGeospatialCoverage(gc);
        this.hashCode = 0;
    }

    public void setTimeCoverage(ThreddsMetadata.TimeCoverage tc) {
        this.tm.setTimeCoverage(tc);
        this.hashCode = 0;
    }

    public void setContributors(ArrayList a) {
        ArrayList dest = this.tm.getContributors();
        Iterator iter = a.iterator();
        while (iter.hasNext()) {
            ThreddsMetadata.Contributor item = (ThreddsMetadata.Contributor)iter.next();
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setKeywords(ArrayList a) {
        ArrayList dest = this.tm.getKeywords();
        Iterator iter = a.iterator();
        while (iter.hasNext()) {
            ThreddsMetadata.Vocab item = (ThreddsMetadata.Vocab)iter.next();
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setProjects(ArrayList a) {
        ArrayList dest = this.tm.getProjects();
        Iterator iter = a.iterator();
        while (iter.hasNext()) {
            ThreddsMetadata.Vocab item = (ThreddsMetadata.Vocab)iter.next();
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setPublishers(ArrayList a) {
        List dest = this.tm.getPublishers();
        Iterator iter = a.iterator();
        while (iter.hasNext()) {
            ThreddsMetadata.Source item = (ThreddsMetadata.Source)iter.next();
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void addAccess(InvAccess a) {
        this.accessLocal.add(a);
        this.hashCode = 0;
    }

    public List getAccessLocal() {
        return this.accessLocal;
    }

    public void addDataset(InvDatasetImpl ds) {
        ds.setParent(this);
        this.datasets.add(ds);
        this.hashCode = 0;
    }

    public boolean removeDataset(InvDatasetImpl ds) {
        if (this.datasets.remove(ds)) {
            ds.setParent(null);
            return true;
        }
        return false;
    }

    public void addDocumentation(InvDocumentation doc) {
        this.tm.addDocumentation(doc);
        this.hashCode = 0;
    }

    public void addProperty(InvProperty p) {
        this.tm.addProperty(p);
        this.hashCode = 0;
    }

    public void addService(InvService service) {
        this.servicesLocal.add(service);
        this.services.add(service);
        List serviceList = service.getServices();
        for (int k = 0; k < serviceList.size(); ++k) {
            InvService nested = (InvService)serviceList.get(k);
            this.services.add(nested);
        }
        this.hashCode = 0;
    }

    public void removeService(InvService service) {
        this.servicesLocal.remove(service);
        this.services.remove(service);
        List serviceList = service.getServices();
        for (int k = 0; k < serviceList.size(); ++k) {
            InvService nested = (InvService)serviceList.get(k);
            this.services.remove(nested);
        }
    }

    public List getServicesLocal() {
        return this.servicesLocal;
    }

    public void setServicesLocal(ArrayList s) {
        this.services = new ArrayList();
        this.servicesLocal = new ArrayList();
        for (int i = 0; i < s.size(); ++i) {
            InvService elem = (InvService)s.get(i);
            this.addService(elem);
        }
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadata() {
        return this.tm;
    }

    public void setLocalMetadata(ThreddsMetadata tm) {
        this.tm = tm;
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadataInherited() {
        return this.tmi;
    }

    public boolean removeLocalMetadata(InvMetadata metadata) {
        InvDatasetImpl parentDataset = (InvDatasetImpl)metadata.getParentDataset();
        List localMdata = parentDataset.getLocalMetadata().getMetadata();
        if (localMdata.contains(metadata) && localMdata.remove(metadata)) {
            this.hashCode = 0;
            return true;
        }
        return false;
    }

    protected boolean getMark() {
        return this.mark;
    }

    protected void setMark(boolean mark) {
        this.mark = mark;
    }

    public Object getUserProperty(Object key) {
        if (this.userMap == null) {
            return null;
        }
        return this.userMap.get(key);
    }

    public void setUserProperty(Object key, Object value) {
        if (this.userMap == null) {
            this.userMap = new HashMap();
        }
        this.userMap.put(key, value);
    }

    public String toString() {
        return this.getName();
    }

    public static void writeHtmlDescription(StringBuffer buff, InvDatasetImpl ds, boolean complete, boolean datasetEvents, boolean catrefEvents) {
        List props;
        InvMetadata m;
        int i;
        ThreddsMetadata.TimeCoverage tc;
        ThreddsMetadata.GeospatialCoverage gc;
        String vocab;
        Object t;
        List list;
        List access;
        URI uri;
        if (ds == null) {
            return;
        }
        if (complete) {
            buff.append("<html>");
            buff.append("<head>");
            buff.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            buff.append("</head>");
            buff.append("<body>\n");
        }
        buff.append("<h2>Dataset: " + ds.getName() + "</h2>\n<ul>\n");
        if (ds.getDataFormatType() != null && ds.getDataFormatType() != DataFormatType.NONE) {
            buff.append(" <li><em>Data format: </em>" + ds.getDataFormatType() + "\n");
        }
        if (ds.getDataType() != null && ds.getDataType() != DataType.NONE) {
            buff.append(" <li><em>Data type: </em>" + ds.getDataType() + "\n");
        }
        if (ds.getCollectionType() != null && ds.getCollectionType() != CollectionType.NONE) {
            buff.append(" <li><em>Collection type: </em>" + ds.getCollectionType() + "\n");
        }
        if (ds.isHarvest()) {
            buff.append(" <li><em>Harvest: </em>" + ds.isHarvest() + "\n");
        }
        if (ds.getAuthority() != null) {
            buff.append(" <li><em>Naming Authority: </em>" + ds.getAuthority() + "\n");
        }
        if (ds.getID() != null) {
            buff.append(" <li><em>ID: </em>" + ds.getID() + "\n");
        }
        if (ds instanceof InvCatalogRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            String href = InvDatasetImpl.resolve(ds, catref.getXlinkHref());
            if (catrefEvents) {
                href = "catref:" + href;
            }
            buff.append(" <li><em>CatalogRef: </em>" + InvDatasetImpl.makeHref(href, href) + "\n");
        }
        buff.append("</ul>\n");
        List docs = ds.getDocumentation();
        if (docs.size() > 0) {
            buff.append("<h3>Documentation:</h3>\n<ul>\n");
            for (int i2 = 0; i2 < docs.size(); ++i2) {
                InvDocumentation doc = (InvDocumentation)docs.get(i2);
                String type = doc.getType() == null ? "" : "<strong>" + doc.getType() + ":</strong> ";
                String inline = doc.getInlineContent();
                if (inline != null && inline.length() > 0) {
                    buff.append(" <li>" + type + inline + "\n");
                }
                if (!doc.hasXlink()) continue;
                uri = doc.getURI();
                buff.append(" <li>" + type + InvDatasetImpl.makeHrefResolve(ds, uri.toString(), doc.getXlinkTitle()) + "</a>\n");
            }
            buff.append("</ul>");
        }
        if ((access = ds.getAccess()).size() > 0) {
            buff.append("<h3>Access:</h3>\n<ol>\n");
            for (int i3 = 0; i3 < access.size(); ++i3) {
                InvAccess a = (InvAccess)access.get(i3);
                InvService s = a.getService();
                String urlString = a.getStandardUrlName();
                if (datasetEvents) {
                    urlString = "dataset:" + urlString;
                }
                buff.append(" <li> <b>" + s.getServiceType() + ":</b> " + InvDatasetImpl.makeHref(urlString, a.getStandardUrlName()) + "\n");
            }
            buff.append("</ol>\n");
        }
        if ((list = ds.getContributors()).size() > 0) {
            buff.append("<h3>Contributors:</h3>\n<ul>\n");
            for (int i4 = 0; i4 < list.size(); ++i4) {
                t = (ThreddsMetadata.Contributor)list.get(i4);
                String role = ((ThreddsMetadata.Contributor)t).getRole() == null ? "" : "<strong> (" + ((ThreddsMetadata.Contributor)t).getRole() + ")</strong> ";
                buff.append(" <li>" + ((ThreddsMetadata.Contributor)t).getName() + role + "\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getKeywords()).size() > 0) {
            buff.append("<h3>Keywords:</h3>\n<ul>\n");
            for (int i5 = 0; i5 < list.size(); ++i5) {
                t = (ThreddsMetadata.Vocab)list.get(i5);
                vocab = ((ThreddsMetadata.Vocab)t).getVocabulary() == null ? "" : " <strong>(" + ((ThreddsMetadata.Vocab)t).getVocabulary() + ")</strong> ";
                buff.append(" <li>" + ((ThreddsMetadata.Vocab)t).getText() + vocab + "\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getDates()).size() > 0) {
            buff.append("<h3>Dates:</h3>\n<ul>\n");
            for (int i6 = 0; i6 < list.size(); ++i6) {
                DateType d = (DateType)list.get(i6);
                String type = d.getType() == null ? "" : " <strong>(" + d.getType() + ")</strong> ";
                buff.append(" <li>" + d.getText() + type + "\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getProjects()).size() > 0) {
            buff.append("<h3>Projects:</h3>\n<ul>\n");
            for (int i7 = 0; i7 < list.size(); ++i7) {
                t = (ThreddsMetadata.Vocab)list.get(i7);
                vocab = ((ThreddsMetadata.Vocab)t).getVocabulary() == null ? "" : " <strong>(" + ((ThreddsMetadata.Vocab)t).getVocabulary() + ")</strong> ";
                buff.append(" <li>" + ((ThreddsMetadata.Vocab)t).getText() + vocab + "\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getCreators()).size() > 0) {
            buff.append("<h3>Creators:</h3>\n<ul>\n");
            for (int i8 = 0; i8 < list.size(); ++i8) {
                t = (ThreddsMetadata.Source)list.get(i8);
                buff.append(" <li><strong>" + ((ThreddsMetadata.Source)t).getName() + "</strong><ul>\n");
                buff.append(" <li><em>email: </em>" + ((ThreddsMetadata.Source)t).getEmail() + "\n");
                if (((ThreddsMetadata.Source)t).getUrl() != null) {
                    buff.append(" <li> <em>" + InvDatasetImpl.makeHrefResolve(ds, ((ThreddsMetadata.Source)t).getUrl(), null) + "</em>\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getPublishers()).size() > 0) {
            buff.append("<h3>Publishers:</h3>\n<ul>\n");
            for (int i9 = 0; i9 < list.size(); ++i9) {
                t = (ThreddsMetadata.Source)list.get(i9);
                buff.append(" <li><strong>" + ((ThreddsMetadata.Source)t).getName() + "</strong><ul>\n");
                buff.append(" <li><em>email: </em>" + ((ThreddsMetadata.Source)t).getEmail() + "\n");
                if (((ThreddsMetadata.Source)t).getUrl() != null) {
                    buff.append(" <li> <em>" + InvDatasetImpl.makeHrefResolve(ds, ((ThreddsMetadata.Source)t).getUrl(), null) + "</em>\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append("</ul>");
        }
        if ((list = ds.getVariables()).size() > 0) {
            buff.append("<h3>Variables:</h3>\n<ul>\n");
            for (int i10 = 0; i10 < list.size(); ++i10) {
                t = (ThreddsMetadata.Variables)list.get(i10);
                if (((ThreddsMetadata.Variables)t).getVocabUri() != null) {
                    uri = ((ThreddsMetadata.Variables)t).getVocabUri();
                    buff.append(" <li>" + InvDatasetImpl.makeHrefResolve(ds, uri.toString(), ((ThreddsMetadata.Variables)t).getVocabulary()) + "</a>");
                } else {
                    buff.append(" <li>" + ((ThreddsMetadata.Variables)t).getVocabulary());
                }
                buff.append(" <em>vocabulary:</em> <ul>\n");
                List vlist = ((ThreddsMetadata.Variables)t).getVariableList();
                if (vlist.size() > 0) {
                    for (int j = 0; j < vlist.size(); ++j) {
                        ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vlist.get(j);
                        String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                        buff.append(" <li><strong>" + v.getName() + "</strong> = " + v.getVocabularyName() + units + "\n");
                    }
                    buff.append(" </ul>\n");
                }
                buff.append("</ul>");
            }
            buff.append("</ul>");
        }
        if ((gc = ds.getGeospatialCoverage()) != null && !gc.isEmpty()) {
            buff.append("<h3>GeospatialCoverage:</h3>\n<ul>\n");
            if (gc.isGlobal()) {
                buff.append(" <li><em> Global </em></ul>\n");
            } else {
                List nlist;
                buff.append(" <li><em> Longitude: </em> " + InvDatasetImpl.rangeString(gc.getEastWestRange()) + "\n");
                buff.append(" <li><em> Latitude: </em> " + InvDatasetImpl.rangeString(gc.getNorthSouthRange()) + "\n");
                if (gc.getUpDownRange() != null) {
                    buff.append(" <li><em> Altitude: </em> " + InvDatasetImpl.rangeString(gc.getUpDownRange()) + " (positive is <strong>" + gc.getZPositive() + ")</strong>\n");
                }
                if ((nlist = gc.getNames()) != null && nlist.size() > 0) {
                    buff.append(" <li><em>  Names: </em> <ul>\n");
                    for (int i11 = 0; i11 < nlist.size(); ++i11) {
                        ThreddsMetadata.Vocab elem = (ThreddsMetadata.Vocab)nlist.get(i11);
                        buff.append(" <li>" + elem.getText() + "\n");
                    }
                    buff.append(" </ul>\n");
                }
                buff.append(" </ul>\n");
            }
        }
        if ((tc = ds.getTimeCoverage()) != null && !tc.isEmpty()) {
            TimeDuration resolution;
            TimeDuration duration;
            DateType end;
            buff.append("<h3>TimeCoverage:</h3>\n<ul>\n");
            DateType start = tc.getStart();
            if (start != null && !start.isBlank()) {
                buff.append(" <li><em>  Start: </em> " + start + "\n");
            }
            if ((end = tc.getEnd()) != null && !end.isBlank()) {
                buff.append(" <li><em>  End: </em> " + end + "\n");
            }
            if ((duration = tc.getDuration()) != null && !duration.isBlank()) {
                buff.append(" <li><em>  Duration: </em> " + duration + "\n");
            }
            if ((resolution = tc.getResolution()) != null && !resolution.isBlank()) {
                buff.append(" <li><em>  Resolution: </em> " + resolution + "\n");
            }
            buff.append(" </ul>\n");
        }
        List metadata = ds.getMetadata();
        boolean gotSomeMetadata = false;
        for (i = 0; i < metadata.size(); ++i) {
            m = (InvMetadata)metadata.get(i);
            if (!m.hasXlink()) continue;
            gotSomeMetadata = true;
        }
        if (gotSomeMetadata) {
            buff.append("<h3>Metadata:</h3>\n<ul>\n");
            for (i = 0; i < metadata.size(); ++i) {
                String type;
                m = (InvMetadata)metadata.get(i);
                String string = type = m.getMetadataType() == null ? "" : m.getMetadataType();
                if (!m.hasXlink()) continue;
                String title = m.getXlinkTitle() == null ? "Type " + type : m.getXlinkTitle();
                buff.append(" <li> " + InvDatasetImpl.makeHrefResolve(ds, m.getXlinkHref().toString(), title) + "\n");
            }
            buff.append("</ul>");
        }
        if ((props = ds.getProperties()).size() > 0) {
            buff.append("<h3>Properties:</h3>\n<ul>\n");
            for (int i12 = 0; i12 < props.size(); ++i12) {
                InvProperty p = (InvProperty)props.get(i12);
                if (p.getName().equals("attachments")) {
                    buff.append(" <li>" + InvDatasetImpl.makeHrefResolve(ds, p.getValue(), p.getName()) + "\n");
                    continue;
                }
                buff.append(" <li>" + p.getName() + " = \"" + p.getValue() + "\"\n");
            }
            buff.append("</ul>");
        }
        if (complete) {
            buff.append("</body></html>");
        }
    }

    private static String rangeString(ThreddsMetadata.Range r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? "" : " Resolution=" + r.getResolution();
        return r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units;
    }

    private static String resolve(InvDatasetImpl ds, String href) {
        InvCatalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                System.err.println("InvDatasetImpl.writeHtml: error parsing URL= " + href);
            }
        }
        return href;
    }

    private static String makeHref(String href, String title) {
        if (title == null) {
            title = href;
        }
        return "<a href='" + href + "'>" + title + "</a>";
    }

    private static String makeHrefResolve(InvDatasetImpl ds, String href, String title) {
        if (title == null) {
            title = href;
        }
        href = InvDatasetImpl.resolve(ds, href);
        return InvDatasetImpl.makeHref(href, title);
    }

    public String dump() {
        return this.dump(0);
    }

    String dump(int n) {
        ArrayList props;
        int i;
        String indent;
        StringBuffer buff = new StringBuffer(100);
        buff.append(InvDatasetImpl.indent(n));
        buff.append("Dataset name:<" + this.getName());
        if (this.dataType != null) {
            buff.append("> dataType:<" + this.dataType);
        }
        if (this.urlPath != null) {
            buff.append("> urlPath:<" + this.urlPath);
        }
        if (this.defaultService != null) {
            buff.append("> defaultService <" + this.defaultService);
        }
        buff.append("> uID:<" + this.getUniqueID());
        buff.append(">\n");
        List svcs = this.getServicesLocal();
        if (svcs.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Services:\n");
            for (i = 0; i < svcs.size(); ++i) {
                InvService s = (InvService)svcs.get(i);
                buff.append(s.dump(n + 4));
            }
        }
        if (this.access.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            if (this.access.size() == 1) {
                buff.append("Access: " + this.access.get(0) + "\n");
            } else if (this.access.size() > 1) {
                buff.append("Access:\n");
                for (i = 0; i < this.access.size(); ++i) {
                    InvAccessImpl a = (InvAccessImpl)this.access.get(i);
                    buff.append(InvDatasetImpl.indent(n + 4) + a + "\n");
                }
            }
        }
        if (this.docs.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Docs:\n");
            for (i = 0; i < this.docs.size(); ++i) {
                InvDocumentation doc = (InvDocumentation)this.docs.get(i);
                buff.append(InvDatasetImpl.indent(n + 4) + doc + "\n");
            }
        }
        if (this.metadata.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Metadata:\n");
            for (i = 0; i < this.metadata.size(); ++i) {
                InvMetadata m = (InvMetadata)this.metadata.get(i);
                buff.append(InvDatasetImpl.indent(n + 4) + m + "\n");
            }
        }
        if ((props = this.properties).size() > 0) {
            String indent2 = InvDatasetImpl.indent(n + 2);
            buff.append(indent2);
            buff.append("Properties:\n");
            for (int i2 = 0; i2 < props.size(); ++i2) {
                InvProperty p = (InvProperty)props.get(i2);
                buff.append(InvDatasetImpl.indent(n + 4) + p + "\n");
            }
        }
        if (this.datasets.size() > 0) {
            String indent3 = InvDatasetImpl.indent(n + 2);
            buff.append(indent3);
            buff.append("Datasets:\n");
            for (int i3 = 0; i3 < this.datasets.size(); ++i3) {
                InvDatasetImpl ds = (InvDatasetImpl)this.datasets.get(i3);
                buff.append(ds.dump(n + 4));
            }
        }
        return buff.toString();
    }

    static String indent(int n) {
        StringBuffer blanks = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            blanks.append(" ");
        }
        return blanks.toString();
    }

    boolean check(StringBuffer out, boolean show) {
        int i;
        boolean isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        for (i = 0; i < this.access.size(); ++i) {
            InvAccessImpl a = (InvAccessImpl)this.access.get(i);
            isValid &= a.check(out, show);
        }
        for (i = 0; i < this.datasets.size(); ++i) {
            InvDatasetImpl ds = (InvDatasetImpl)this.datasets.get(i);
            isValid &= ds.check(out, show);
        }
        List mdata = this.getMetadata();
        for (int i2 = 0; i2 < mdata.size(); ++i2) {
            InvMetadata m = (InvMetadata)mdata.get(i2);
            m.check(out);
        }
        List services = this.getServicesLocal();
        for (int i3 = 0; i3 < services.size(); ++i3) {
            InvService s = (InvService)services.get(i3);
            isValid &= s.check(out);
        }
        if (this.hasAccess() && this.getDataType() == null) {
            out.append("**Warning: Dataset (" + this.getFullName() + "): is selectable but no data type declared in it or in a parent element\n");
        }
        if (!this.hasAccess() && !this.hasNestedDatasets()) {
            out.append("**Warning: Dataset (" + this.getFullName() + "): is not selectable and does not have nested datasets\n");
        }
        if (show) {
            System.out.println("  dataset " + this.name + " valid = " + isValid);
        }
        return isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvDatasetImpl)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + ((Object)this.getServicesLocal()).hashCode();
            result = 37 * result + ((Object)this.getDatasets()).hashCode();
            result = 37 * result + ((Object)this.getAccessLocal()).hashCode();
            result = 37 * result + (this.isHarvest() ? 1 : 0);
            if (null != this.getCollectionType()) {
                result = 37 * result + this.getCollectionType().hashCode();
            }
            result = 37 * result + ((Object)this.getDocumentation()).hashCode();
            result = 37 * result + ((Object)this.getProperties()).hashCode();
            result = 37 * result + ((Object)this.getMetadata()).hashCode();
            result = 37 * result + ((Object)this.getCreators()).hashCode();
            result = 37 * result + ((Object)this.getContributors()).hashCode();
            result = 37 * result + ((Object)this.getDates()).hashCode();
            result = 37 * result + ((Object)this.getKeywords()).hashCode();
            result = 37 * result + ((Object)this.getProjects()).hashCode();
            result = 37 * result + ((Object)this.getPublishers()).hashCode();
            result = 37 * result + ((Object)this.getVariables()).hashCode();
            if (null != this.getID()) {
                result = 37 * result + this.getID().hashCode();
            }
            if (null != this.getAlias()) {
                result = 37 * result + this.getAlias().hashCode();
            }
            if (null != this.getAuthority()) {
                result = 37 * result + this.getAuthority().hashCode();
            }
            if (null != this.getDataType()) {
                result = 37 * result + this.getDataType().hashCode();
            }
            if (null != this.getDataFormatType()) {
                result = 37 * result + this.getDataFormatType().hashCode();
            }
            if (null != this.getServiceDefault()) {
                result = 37 * result + this.getServiceDefault().hashCode();
            }
            if (null != this.getUrlPath()) {
                result = 37 * result + this.getUrlPath().hashCode();
            }
            if (null != this.getGeospatialCoverage()) {
                result = 37 * result + this.getGeospatialCoverage().hashCode();
            }
            if (null != this.getTimeCoverage()) {
                result = 37 * result + this.getTimeCoverage().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public static void main(String[] args) {
        InvDatasetImpl topDs = new InvDatasetImpl(null, "topDs", DataType.getType("Grid"), "myService", "myUrlPath/");
        InvService myS = new InvService("myService", ServiceType.DODS.toString(), "http://motherlode.ucar.edu/cgi-bin/dods/nph-dods", "", null);
        topDs.addService(myS);
        topDs.getLocalMetadata().setServiceName("myService");
        InvDatasetImpl childDs = new InvDatasetImpl(null, "childDs", null, null, "myUrlPath/");
        topDs.addDataset(childDs);
        InvService ts = childDs.findService("myService");
        System.out.println("InvDatasetImpl.main(): " + childDs.getAccess(ServiceType.DODS).toString());
    }
}

