/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.ArrayList;
import java.util.List;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.MetadataType;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;

public abstract class InvDataset {
    protected InvCatalog catalog;
    protected InvDataset parent;
    protected String name;
    protected String id;
    protected ArrayList datasets = new ArrayList();
    protected boolean harvest;
    protected CollectionType collectionType;
    protected ArrayList access = new ArrayList();
    protected ArrayList services = new ArrayList();
    protected String authorityName;
    protected DataType dataType;
    protected InvService defaultService;
    protected DataFormatType dataFormatType;
    protected ArrayList docs;
    protected ArrayList metadata;
    protected ArrayList properties;
    protected ArrayList creators;
    protected ArrayList contributors;
    protected ArrayList dates;
    protected ArrayList keywords;
    protected ArrayList projects;
    protected ArrayList publishers;
    protected ArrayList variables;
    public ThreddsMetadata.GeospatialCoverage gc;
    public ThreddsMetadata.TimeCoverage tc;

    protected InvDataset(InvDataset parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.parent == null ? this.name : this.parent.getFullName() + "/" + this.name;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public boolean isHarvest() {
        return this.harvest;
    }

    public String getID() {
        return this.id;
    }

    public String getUniqueID() {
        String authority = this.getAuthority();
        if (authority != null && this.getID() != null) {
            return authority + this.getID();
        }
        if (this.getID() != null) {
            return this.getID();
        }
        return null;
    }

    public String getAuthority() {
        return this.authorityName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormatType;
    }

    public boolean hasAccess() {
        return !this.access.isEmpty();
    }

    public List getAccess() {
        return this.access;
    }

    public InvAccess getAccess(ServiceType type) {
        List alist = this.getAccess();
        for (int i = 0; i < alist.size(); ++i) {
            InvAccess m = (InvAccess)alist.get(i);
            InvService s = m.getService();
            if (s.getServiceType() != type) continue;
            return m;
        }
        return null;
    }

    public String getSubsetUrl() {
        if (this.getID() == null) {
            return null;
        }
        return "catalog=" + this.getParentCatalog().baseURI.toString() + "&dataset=" + this.getID();
    }

    public boolean hasNestedDatasets() {
        return !this.getDatasets().isEmpty();
    }

    public List getDatasets() {
        return this.datasets;
    }

    public InvDatasetImpl findDatasetByName(String name) {
        List dlist = this.getDatasets();
        for (int i = 0; i < dlist.size(); ++i) {
            InvDatasetImpl ds = (InvDatasetImpl)dlist.get(i);
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }

    public InvDataset getParent() {
        return this.parent;
    }

    public InvCatalog getParentCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        return this.parent != null ? this.parent.getParentCatalog() : null;
    }

    public List getDocumentation() {
        return this.docs;
    }

    public List getProperties() {
        return this.properties;
    }

    public String findProperty(String name) {
        InvProperty result = null;
        List plist = this.getProperties();
        for (int i = 0; i < plist.size(); ++i) {
            InvProperty p = (InvProperty)plist.get(i);
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public List getMetadata() {
        return this.metadata;
    }

    public List getMetadata(MetadataType want) {
        ArrayList<InvMetadata> result = new ArrayList<InvMetadata>();
        List mlist = this.getMetadata();
        for (int i = 0; i < mlist.size(); ++i) {
            InvMetadata m = (InvMetadata)mlist.get(i);
            MetadataType mtype = MetadataType.getType(m.getMetadataType());
            if (mtype != want) continue;
            result.add(m);
        }
        return result;
    }

    public InvService findService(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.services.size(); ++i) {
            InvService p = (InvService)this.services.get(i);
            if (!p.getName().equals(name)) continue;
            return p;
        }
        if (this.parent != null) {
            return this.parent.findService(name);
        }
        return this.catalog == null ? null : this.catalog.findService(name);
    }

    public InvService getServiceDefault() {
        return this.defaultService;
    }

    public List getCreators() {
        return this.creators;
    }

    public List getContributors() {
        return this.contributors;
    }

    public List getDates() {
        return this.dates;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getProjects() {
        return this.projects;
    }

    public List getPublishers() {
        return this.publishers;
    }

    public List getVariables() {
        return this.variables;
    }

    public ThreddsMetadata.Variables getVariables(String vocab) {
        ThreddsMetadata.Variables result = new ThreddsMetadata.Variables(vocab, null, null, null, null);
        if (this.variables == null) {
            return result;
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            ThreddsMetadata.Variables vs = (ThreddsMetadata.Variables)this.variables.get(i);
            if (!vs.getVocabulary().equals(vocab)) continue;
            result.getVariableList().addAll(vs.getVariableList());
        }
        return result;
    }

    public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
        return this.gc;
    }

    public ThreddsMetadata.TimeCoverage getTimeCoverage() {
        return this.tc;
    }

    public String getDocumentation(String type) {
        List docs = this.getDocumentation();
        for (int i = 0; i < docs.size(); ++i) {
            InvDocumentation doc = (InvDocumentation)docs.get(i);
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            return doc.getInlineContent();
        }
        return null;
    }
}

