/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.DataType;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvProperty;

public class InvCatalogRef
extends InvDatasetImpl {
    private String href;
    private InvDatasetImpl proxy = null;
    private URI uri = null;
    private String errMessage = null;
    private boolean init = false;
    private boolean useProxy = false;
    private boolean debug = false;
    private boolean debugProxy = false;
    private boolean debugAsynch = false;

    public InvCatalogRef(InvDatasetImpl parent, String title, String href) {
        super(parent, title);
        this.href = href.trim();
    }

    public String getXlinkHref() {
        return this.href;
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        try {
            return this.getParentCatalog().resolveUri(this.href);
        }
        catch (URISyntaxException e) {
            this.errMessage = "URISyntaxException on url  " + this.href + " = " + e.getMessage();
            return null;
        }
    }

    public List getDatasets() {
        this.read();
        return this.useProxy ? this.proxy.getDatasets() : super.getDatasets();
    }

    public boolean isRead() {
        return this.init;
    }

    public InvDatasetImpl getProxyDataset() {
        this.read();
        return this.proxy;
    }

    public String getName() {
        return this.useProxy ? this.proxy.getName() : super.getName();
    }

    public String getFullName() {
        return this.useProxy ? this.proxy.getName() : super.getFullName();
    }

    public String getID() {
        return this.useProxy ? this.proxy.getID() : super.getID();
    }

    public String getAuthority() {
        return this.useProxy ? this.proxy.getAuthority() : super.getAuthority();
    }

    public DataType getDataType() {
        return this.useProxy ? this.proxy.getDataType() : super.getDataType();
    }

    public boolean hasAccess() {
        return this.useProxy ? this.proxy.hasAccess() : super.hasAccess();
    }

    public boolean hasNestedDatasets() {
        return this.useProxy ? this.proxy.hasNestedDatasets() : true;
    }

    public List getDocumentation() {
        return this.useProxy ? this.proxy.getDocumentation() : super.getDocumentation();
    }

    public List getProperties() {
        return this.useProxy ? this.proxy.getProperties() : super.getProperties();
    }

    public List getMetadata() {
        return this.useProxy ? this.proxy.getMetadata() : super.getMetadata();
    }

    public List getAccessLocal() {
        return this.useProxy ? this.proxy.getAccessLocal() : super.getAccessLocal();
    }

    public boolean finish() {
        return super.finish();
    }

    private synchronized void read() {
        if (this.init) {
            return;
        }
        URI uriResolved = this.getURI();
        if (uriResolved == null) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println(this.errMessage);
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.errMessage));
            this.datasets.add(this.proxy);
            this.init = true;
        }
        try {
            if (this.debug) {
                System.out.println(" InvCatalogRef read " + this.getFullName() + "  hrefResolved = " + uriResolved);
            }
            InvCatalogFactory factory = ((InvCatalogImpl)this.getParentCatalog()).getCatalogFactory();
            InvCatalogImpl cat = factory.readXML(uriResolved.toString());
            this.finishCatalog(cat);
        }
        catch (Exception e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
            this.init = true;
            return;
        }
    }

    private void finishCatalog(InvCatalogImpl cat) {
        InvCatalogImpl parentCatalog = null;
        if (cat.hasFatalError()) {
            this.proxy = new InvDatasetImpl(null, "ERROR OPENING");
            StringBuffer out = new StringBuffer();
            cat.check(out);
            if (this.debug) {
                System.out.println("PARSE ERROR =\n  " + out.toString());
            }
            this.proxy.addProperty(new InvProperty("ERROR OPENING", out.toString()));
            this.proxy.finish();
        } else {
            parentCatalog = (InvCatalogImpl)this.getParentCatalog();
            DatasetFilter filter = parentCatalog.getDatasetFilter();
            if (filter != null) {
                cat.filter(filter);
            }
            this.proxy = (InvDatasetImpl)cat.getDataset();
            if (this.proxy.getMark()) {
                this.proxy.setName(this.proxy.getName() + " (EMPTY)");
                this.proxy.addProperty(new InvProperty("isEmpty", "true"));
                this.proxy.finish();
            }
            String name = this.getName().trim();
            String proxyName = this.proxy.getName().trim();
            boolean bl = this.useProxy = proxyName.equals(name) && !(this.proxy instanceof InvCatalogRef);
            if (this.debugProxy) {
                System.out.println("catRefname=" + name + "=topName=" + proxyName + "=" + this.useProxy);
            }
            if (this.useProxy) {
                for (int i = 0; i < this.docs.size(); ++i) {
                    this.proxy.addDocumentation((InvDocumentation)this.docs.get(i));
                }
                this.proxy.finish();
            }
        }
        this.datasets.add(this.proxy);
        this.init = true;
    }

    public synchronized void readAsynch(InvCatalogFactory factory, CatalogSetCallback caller) {
        if (this.init) {
            caller.setCatalog((InvCatalogImpl)this.getParentCatalog());
            return;
        }
        String hrefResolved = null;
        try {
            URI uri = this.getParentCatalog().resolveUri(this.href);
            hrefResolved = uri.toString();
        }
        catch (URISyntaxException e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
            return;
        }
        Object cat = null;
        try {
            if (this.debug) {
                System.out.println(" InvCatalogRef readXMLasynch " + this.getFullName() + "  hrefResolved = " + hrefResolved);
            }
            factory.readXMLasynch(hrefResolved, new Callback(caller));
        }
        catch (Exception e) {
            this.proxy = new InvDatasetImpl(null, "HREF ERROR");
            if (this.debug) {
                System.out.println("HREF ERROR =\n  " + this.href + " err= " + e.getMessage());
            }
            this.proxy.addProperty(new InvProperty("HREF ERROR", this.href));
            this.datasets.add(this.proxy);
            return;
        }
    }

    boolean check(StringBuffer out, boolean show) {
        return this.isRead() ? this.proxy.check(out, show) : true;
    }

    private class Callback
    implements CatalogSetCallback {
        CatalogSetCallback caller;

        Callback(CatalogSetCallback caller) {
            this.caller = caller;
        }

        public void setCatalog(InvCatalogImpl cat) {
            if (InvCatalogRef.this.debugAsynch) {
                System.out.println(" setCatalog was called");
            }
            InvCatalogRef.this.finishCatalog(cat);
            this.caller.setCatalog(cat);
        }

        public void failed() {
            if (InvCatalogRef.this.debugAsynch) {
                System.out.println(" setCatalog failed");
            }
            this.caller.failed();
        }
    }
}

