/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.datatype.DateType;

public class InvCatalogImpl
extends InvCatalog {
    private String createFrom;
    private String dtdID;
    private StringBuffer log = new StringBuffer();
    private boolean hasError = false;
    private DatasetFilter filter = null;
    private boolean debugFilter = false;
    private EventListenerList listenerList = null;
    private InvCatalogImpl top = null;
    private InvCatalogFactory factory = null;
    private InvCatalogConvertIF converter = null;
    private volatile int hashCode = 0;

    public void subset(InvDataset ds) {
        InvDatasetImpl dataset;
        this.topDataset = dataset = (InvDatasetImpl)ds;
        InvService service = dataset.getServiceDefault();
        dataset.dataType = dataset.getDataType();
        dataset.setCatalog(this);
        dataset.parent = null;
        ArrayList services = new ArrayList(dataset.getServicesLocal());
        this.findServices(services, dataset);
        dataset.setServicesLocal(services);
        this.finish();
    }

    private void findServices(ArrayList result, InvDatasetImpl ds) {
        if (ds instanceof InvCatalogRef) {
            return;
        }
        Iterator iter = ds.getAccess().iterator();
        while (iter.hasNext()) {
            InvAccess a = (InvAccess)iter.next();
            InvService s = a.getService();
            InvDataset d = a.getDataset();
            if (null != d.findService(s.getName()) || result.contains(s)) continue;
            result.add(s);
        }
        iter = ds.getDatasets().iterator();
        while (iter.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)iter.next();
            this.findServices(result, nested);
        }
    }

    public void filter(DatasetFilter filter) {
        this.mark(filter, this.topDataset);
        this.delete(this.topDataset);
        this.filter = filter;
    }

    protected DatasetFilter getDatasetFilter() {
        return this.filter;
    }

    private boolean mark(DatasetFilter filter, InvDatasetImpl ds) {
        InvCatalogRef catRef;
        if (ds instanceof InvCatalogRef && !(catRef = (InvCatalogRef)ds).isRead()) {
            return false;
        }
        boolean allMarked = true;
        Iterator iter = ds.getDatasets().iterator();
        while (iter.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)iter.next();
            allMarked &= this.mark(filter, nested);
        }
        if (!allMarked) {
            return false;
        }
        if (filter.accept(ds) >= 0) {
            return false;
        }
        ds.setMark(true);
        if (this.debugFilter) {
            System.out.println(" mark " + ds.getName());
        }
        return true;
    }

    private void delete(InvDatasetImpl ds) {
        InvCatalogRef catRef;
        if (ds instanceof InvCatalogRef && !(catRef = (InvCatalogRef)ds).isRead()) {
            return;
        }
        Iterator iter = ds.getDatasets().iterator();
        while (iter.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)iter.next();
            if (nested.getMark()) {
                iter.remove();
                if (!this.debugFilter) continue;
                System.out.println(" remove " + nested.getName());
                continue;
            }
            this.delete(nested);
        }
    }

    public InvCatalogImpl(String name, String version, URI baseURI) {
        this(name, version, null, baseURI);
    }

    public InvCatalogImpl(String name, String version, DateType expires, URI baseURI) {
        this.name = name;
        this.version = version;
        this.expires = expires;
        this.baseURI = baseURI;
    }

    public boolean finish() {
        if (this.topDataset == null) {
            if (this.datasets.size() == 1) {
                this.topDataset = (InvDatasetImpl)this.datasets.get(0);
            } else {
                this.topDataset = new InvDatasetImpl(null, this.name == null ? "Top Dataset" : this.name);
                Iterator iter = this.datasets.iterator();
                while (iter.hasNext()) {
                    this.topDataset.addDataset((InvDatasetImpl)iter.next());
                }
                this.topDataset.setServicesLocal(this.services);
            }
        }
        this.topDataset.setCatalog(this);
        this.dsHash = new HashMap();
        this.addDatasetIds(this.topDataset);
        return this.topDataset.finish();
    }

    private void addDatasetIds(InvDatasetImpl ds) {
        if (ds instanceof InvCatalogRef) {
            return;
        }
        this.addDatasetByID(ds);
        Iterator iter = ds.getDatasets().iterator();
        while (iter.hasNext()) {
            InvDatasetImpl nested = (InvDatasetImpl)iter.next();
            this.addDatasetIds(nested);
        }
    }

    public void addDatasetByID(InvDatasetImpl ds) {
        if (ds.getID() != null) {
            this.dsHash.put(ds.getID(), ds);
        }
    }

    public void addDataset(InvDatasetImpl ds) {
        this.datasets.add(ds);
    }

    public void addProperty(InvProperty p) {
        this.properties.add(p);
    }

    public void addService(InvService s) {
        if (s == null) {
            throw new IllegalArgumentException("Service to add was null.");
        }
        if (s.getName() != null) {
            Object obj = this.serviceHash.get(s.getName());
            if (obj == null) {
                this.serviceHash.put(s.getName(), s);
                this.services.add(s);
                return;
            }
            if (s.equals(obj)) {
                return;
            }
            this.log.append("Multiple Services with the same name\n");
            return;
        }
    }

    public void setDataset(InvDatasetImpl ds) {
        this.topDataset = ds;
        this.addDataset(ds);
    }

    public String getCreateFrom() {
        return this.createFrom;
    }

    public void setCreateFrom(String createFrom) {
        this.createFrom = createFrom;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public String getDTDid() {
        return this.dtdID;
    }

    public void setDTDid(String dtdID) {
        this.dtdID = dtdID;
    }

    public boolean hasFatalError() {
        return this.hasError;
    }

    public void appendErrorMessage(String message, boolean isInvalid) {
        this.log.append(message);
        this.hasError |= isInvalid;
    }

    public boolean check(StringBuffer out, boolean show) {
        boolean isValid = !this.hasError;
        out.append("----Catalog Validation version 1.0.01\n");
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (show) {
            System.out.println(" catalog valid = " + isValid);
        }
        for (int i = 0; i < this.datasets.size(); ++i) {
            InvDatasetImpl ds = (InvDatasetImpl)this.datasets.get(i);
            ds.check(out, show);
        }
        return isValid;
    }

    public String dump() {
        StringBuffer buff = new StringBuffer(1000);
        buff.setLength(0);
        buff.append("Catalog <" + this.getName() + "> <" + this.getVersion() + "> <" + this.getCreateFrom() + ">\n");
        buff.append(this.topDataset.dump(2));
        return buff.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$beans$PropertyChangeListener == null ? InvCatalogImpl.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    InvCatalogImpl getTopCatalog() {
        return this.top == null ? this : this.top;
    }

    void setTopCatalog(InvCatalogImpl top) {
        this.top = top;
    }

    InvCatalogFactory getCatalogFactory() {
        return this.factory;
    }

    void setCatalogFactory(InvCatalogFactory factory) {
        this.factory = factory;
    }

    InvCatalogConvertIF getCatalogConverter() {
        return this.converter;
    }

    void setCatalogConverter(InvCatalogConvertIF converter) {
        this.converter = converter;
    }

    public void setCatalogConverterToVersion1() {
        this.setCatalogConverter(this.factory.getCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0"));
    }

    public void writeXML(OutputStream os) throws IOException {
        InvCatalogConvertIF fac = this.getCatalogConverter();
        fac.writeXML(this, os);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvCatalogImpl)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (null != this.getName()) {
                result = 37 * result + this.getName().hashCode();
            }
            result = 37 * result + ((Object)this.getServices()).hashCode();
            this.hashCode = result = 37 * result + ((Object)this.getDatasets()).hashCode();
        }
        return this.hashCode;
    }
}

