/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.JaxpFactory;
import thredds.catalog.MetadataConverterIF;

public class InvCatalogFactory {
    public static boolean debugURL = false;
    public static boolean debugOpen = false;
    public static boolean debugVersion = false;
    public static boolean showParsedXML = false;
    public static boolean showStackTrace = false;
    public static boolean debugXML = false;
    public static boolean debugDBurl = false;
    public static boolean debugXMLopen = false;
    public static boolean showCatalogXML = false;
    private String name;
    private DocumentBuilder builder;
    private InvCatalogConvertIF defaultConverter;
    private HashMap converters = new HashMap(10);
    private HashMap metadataConverters = new HashMap(10);
    private StringBuffer warnMessages;
    private StringBuffer errMessages;
    private StringBuffer fatalMessages;

    public static InvCatalogFactory getDefaultFactory(boolean validate) {
        return new InvCatalogFactory("default", validate);
    }

    public String getName() {
        return this.name;
    }

    public InvCatalogFactory(String name, boolean validate) {
        this.name = name;
        JaxpFactory jaxp = new JaxpFactory(validate);
        this.builder = jaxp.getDocumentBuilder();
        this.warnMessages = jaxp.getErrorMessages();
        this.errMessages = jaxp.getErrorMessages();
        this.fatalMessages = jaxp.getFatalMessages();
        this.setDefaults();
    }

    private void setDefaults() {
        try {
            Class<?> fac6 = Class.forName("thredds.catalog.parser.jdom.InvCatalogFactory6");
            Object fac6o = fac6.newInstance();
            this.registerCatalogConverter("http://www.unidata.ucar.edu/thredds", (InvCatalogConvertIF)fac6o);
            Class<?> fac1 = Class.forName("thredds.catalog.parser.jdom.InvCatalogFactory10");
            Object fac1o = fac1.newInstance();
            this.defaultConverter = (InvCatalogConvertIF)fac1o;
            this.registerCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", (InvCatalogConvertIF)fac1o);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("InvCatalogFactory: no implementing class found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("InvCatalogFactory: instantition failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("InvCatalogFactory: access failed: " + e.getMessage());
        }
    }

    public void registerCatalogConverter(String namespace, InvCatalogConvertIF converter) {
        this.converters.put(namespace, converter);
    }

    public InvCatalogConvertIF getCatalogConverter(String namespace) {
        return (InvCatalogConvertIF)this.converters.get(namespace);
    }

    public void registerMetadataConverter(String key, MetadataConverterIF converter) {
        this.metadataConverters.put(key, converter);
    }

    public void readXMLasynch(String uriString, CatalogSetCallback callback) {
        InvCatalogImpl cat = this.readXML(uriString);
        callback.setCatalog(cat);
    }

    public InvCatalogImpl readXML(String uriString) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            InvCatalogImpl cat = new InvCatalogImpl(uriString, null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML URISyntaxException on URL (" + uriString + ") " + e.getMessage() + "\n", true);
            return cat;
        }
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.parse(uriString);
        }
        catch (Exception e) {
            InvCatalogImpl cat = new InvCatalogImpl(uriString, null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML failed\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n fatalMessages= " + this.fatalMessages.toString() + "\n errMessages= " + this.errMessages.toString() + "\n warnMessages= " + this.warnMessages.toString() + "\n", true);
            return cat;
        }
        if (this.fatalMessages.length() > 0) {
            InvCatalogImpl cat = new InvCatalogImpl(uriString, null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML XML Fatal error(s) =\n" + this.fatalMessages.toString() + "\n", true);
            return cat;
        }
        return this.readXML(doc, uri);
    }

    public InvCatalogImpl readXML(InputStream docIs, URI uri) {
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.parse(docIs);
        }
        catch (Exception e) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, uri);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML failed\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n fatalMessages= " + this.fatalMessages.toString() + "\n errMessages= " + this.errMessages.toString() + "\n warnMessages= " + this.warnMessages.toString() + "\n", true);
            return cat;
        }
        if (this.fatalMessages.length() > 0) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, uri);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML XML Fatal error(s) =\n" + this.fatalMessages.toString() + "\n", true);
            return cat;
        }
        return this.readXML(doc, uri);
    }

    public InvCatalogImpl readXML(Document doc, URI uri) {
        Element root = doc.getDocumentElement();
        String namespace = root.getNamespaceURI();
        InvCatalogConvertIF fac = (InvCatalogConvertIF)this.converters.get(namespace);
        if (fac == null) {
            fac = this.defaultConverter;
            if (debugVersion) {
                System.out.println("use default converter " + fac.getClass().getName() + "; no namespace " + namespace);
            }
        } else if (debugVersion) {
            System.out.println("use converter " + fac.getClass().getName() + " based on namespace " + namespace);
        }
        InvCatalogImpl cat = fac.parseXML(this, doc, uri);
        cat.setCreateFrom(uri.toString());
        cat.setCatalogFactory(this);
        cat.setCatalogConverter(fac);
        cat.finish();
        if (showCatalogXML) {
            System.out.println("*** catalog/showCatalogXML");
            try {
                this.writeXML(cat, System.out);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.fatalMessages.length() > 0) {
            cat.appendErrorMessage(this.fatalMessages.toString(), true);
        }
        if (this.errMessages.length() > 0) {
            cat.appendErrorMessage(this.errMessages.toString(), false);
        }
        if (this.errMessages.length() > 0) {
            cat.appendErrorMessage(this.warnMessages.toString(), false);
        }
        return cat;
    }

    public Element readOtherXML(URI uri) {
        Document doc = null;
        try {
            doc = this.builder.parse(uri.toString());
        }
        catch (Exception e) {
            this.errMessages.append("**Error:  InvCatalogFactory.readOtherXML failed on " + uri + "\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n");
            return null;
        }
        return doc.getDocumentElement();
    }

    public String writeXML(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML(catalog, os);
        return os.toString();
    }

    public void writeXML(InvCatalogImpl catalog, OutputStream os) throws IOException {
        InvCatalogConvertIF fac = catalog.getCatalogConverter();
        if (fac == null) {
            fac = this.defaultConverter;
        }
        fac.writeXML(catalog, os);
    }

    public boolean writeXML(InvCatalogImpl catalog, String filename) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
            this.writeXML(catalog, os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String writeXML_1_0(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML_1_0(catalog, os);
        return os.toString();
    }

    public String writeXML_0_6(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML_0_6(catalog, os);
        return os.toString();
    }

    public void writeXML_1_0(InvCatalogImpl catalog, OutputStream os) throws IOException {
        this.writeXML_ver("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", catalog, os);
    }

    public void writeXML_0_6(InvCatalogImpl catalog, OutputStream os) throws IOException {
        this.writeXML_ver("http://www.unidata.ucar.edu/thredds", catalog, os);
    }

    private void writeXML_ver(String namespace, InvCatalogImpl catalog, OutputStream os) throws IOException {
        InvCatalogConvertIF converter = this.getCatalogConverter(namespace);
        if (converter == null) {
            String tmpMsg = "This Factory <" + this.getName() + "> does not have a converter for the requested namespace <" + namespace + ">.";
            throw new IllegalStateException(tmpMsg);
        }
        converter.writeXML(catalog, os);
    }

    public void appendErr(String err) {
        this.errMessages.append(err);
    }

    public void appendFatalErr(String err) {
        this.fatalMessages.append(err);
    }

    public void appendWarning(String err) {
        this.warnMessages.append(err);
    }

    public MetadataConverterIF getMetadataConverter(String key) {
        if (key == null) {
            return null;
        }
        return (MetadataConverterIF)this.metadataConverters.get(key);
    }

    private static void doOne(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuffer buff = new StringBuffer();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            System.out.println(" catalog=\n" + fac.writeXML(cat));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogFactory.doOne(catFactory, "file:///C:/dev/thredds/catalog/test/data/Example1.0.xml");
    }
}

