/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.datatype.DateType;

public abstract class InvCatalog {
    protected String name;
    protected String version;
    protected URI baseURI = null;
    protected InvDatasetImpl topDataset;
    protected HashMap dsHash = new HashMap();
    protected HashMap serviceHash = new HashMap();
    protected ArrayList services = new ArrayList();
    protected ArrayList properties = new ArrayList();
    protected ArrayList datasets = new ArrayList();
    protected DateType expires;

    protected InvCatalog() {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public InvDataset getDataset() {
        return this.topDataset;
    }

    public InvDataset findDatasetByID(String id) {
        return (InvDataset)this.dsHash.get(id);
    }

    public List getDatasets() {
        return this.datasets;
    }

    public List getServices() {
        return this.services;
    }

    public List getProperties() {
        return this.properties;
    }

    public String findProperty(String name) {
        InvProperty result = null;
        List plist = this.getProperties();
        for (int i = 0; i < plist.size(); ++i) {
            InvProperty p = (InvProperty)plist.get(i);
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public DateType getExpires() {
        return this.expires;
    }

    public InvService findService(String name) {
        if (name == null) {
            return null;
        }
        for (int k = 0; k < this.services.size(); ++k) {
            InvService s = (InvService)this.services.get(k);
            if (name.equals(s.getName())) {
                return s;
            }
            List serviceList = s.getServices();
            for (int i = 0; i < serviceList.size(); ++i) {
                InvService nested = (InvService)serviceList.get(i);
                if (!name.equals(nested.getName())) continue;
                return nested;
            }
        }
        return null;
    }

    public URI resolveUri(String uriString) throws URISyntaxException {
        URI want = new URI(uriString);
        if (this.baseURI != null) {
            want = this.baseURI.resolve(want);
        }
        return want;
    }

    public String getUriString() {
        return this.baseURI.toString();
    }

    public abstract boolean check(StringBuffer var1, boolean var2);

    public boolean check(StringBuffer out) {
        return this.check(out, false);
    }

    public abstract void subset(InvDataset var1);

    public abstract void filter(DatasetFilter var1);
}

