/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDataset;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;

public abstract class InvAccess {
    protected InvDataset dataset;
    protected ServiceType type;
    protected DataFormatType dataFormat;
    protected InvService service;
    protected String urlPath;
    protected double dataSize = Double.NaN;

    public InvDataset getDataset() {
        return this.dataset;
    }

    public InvService getService() {
        return this.service;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormat != null ? this.dataFormat : this.dataset.getDataFormatType();
    }

    public double getDataSize() {
        return this.dataSize;
    }

    public boolean hasDataSize() {
        return this.dataSize != 0.0 && !Double.isNaN(this.dataSize);
    }

    public String getStandardUrlName() {
        InvCatalog cat = this.dataset.getParentCatalog();
        if (cat == null) {
            return this.getUnresolvedUrlName();
        }
        try {
            URI uri = cat.resolveUri(this.getUnresolvedUrlName());
            return uri.toString();
        }
        catch (URISyntaxException e) {
            System.err.println("Error parsing URL= " + this.getUnresolvedUrlName());
            return null;
        }
    }

    public String getUnresolvedUrlName() {
        return this.service.getBase() + this.getUrlPath() + this.service.getSuffix();
    }
}

