/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.util.ParameterList;

public class QuantTypeSpec
extends ModuleSpec {
    public QuantTypeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public QuantTypeSpec(int nt, int nc, byte type, ParameterList pl) {
        super(nt, nc, type);
        String param = pl.getParameter("Qtype");
        if (param == null) {
            if (pl.getBooleanParameter("lossless")) {
                this.setDefault("reversible");
            } else {
                this.setDefault("expounded");
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecValType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ModuleSpec.parseIdx(word, this.nTiles);
                    if (curSpecValType == 1) {
                        curSpecValType = 3;
                        break;
                    }
                    curSpecValType = 2;
                    break;
                }
                case 'c': {
                    compSpec = ModuleSpec.parseIdx(word, this.nComp);
                    if (curSpecValType == 2) {
                        curSpecValType = 3;
                        break;
                    }
                    curSpecValType = 1;
                    break;
                }
                case 'd': 
                case 'e': 
                case 'r': {
                    int i;
                    if (!(word.equalsIgnoreCase("reversible") || word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                    }
                    if (pl.getBooleanParameter("lossless") && (word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Cannot use non reversible quantization with '-lossless' option");
                    }
                    if (curSpecValType == 0) {
                        this.setDefault(word);
                    } else if (curSpecValType == 2) {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            if (tileSpec[i]) {
                                this.setTileDef(i, word);
                            }
                            --i;
                        }
                    } else if (curSpecValType == 1) {
                        i = compSpec.length - 1;
                        while (i >= 0) {
                            if (compSpec[i]) {
                                this.setCompDef(i, word);
                            }
                            --i;
                        }
                    } else {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            int j = compSpec.length - 1;
                            while (j >= 0) {
                                if (tileSpec[i] && compSpec[j]) {
                                    this.setTileCompVal(i, j, word);
                                }
                                --j;
                            }
                            --i;
                        }
                    }
                    curSpecValType = 0;
                    tileSpec = null;
                    compSpec = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                }
            }
        }
        if (this.getDefault() == null) {
            int c;
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                c = nc - 1;
                while (c >= 0) {
                    if (this.specValType[t][c] == 0) {
                        ++ndefspec;
                    }
                    --c;
                }
                --t;
            }
            if (ndefspec != 0) {
                if (pl.getBooleanParameter("lossless")) {
                    this.setDefault("reversible");
                } else {
                    this.setDefault("expounded");
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        c = nc - 1;
                        while (c >= 0) {
                            if (this.specValType[0][c] == 2) {
                                this.specValType[0][c] = 0;
                            }
                            --c;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        int t2 = nt - 1;
                        while (t2 >= 0) {
                            if (this.specValType[t2][0] == 1) {
                                this.specValType[t2][0] = 0;
                            }
                            --t2;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public boolean isDerived(int t, int c) {
        return ((String)this.getTileCompVal(t, c)).equals("derived");
    }

    public boolean isReversible(int t, int c) {
        return ((String)this.getTileCompVal(t, c)).equals("reversible");
    }

    public boolean isFullyReversible() {
        if (((String)this.getDefault()).equals("reversible")) {
            int t = this.nTiles - 1;
            while (t >= 0) {
                int c = this.nComp - 1;
                while (c >= 0) {
                    if (this.specValType[t][c] != 0) {
                        return false;
                    }
                    --c;
                }
                --t;
            }
            return true;
        }
        return false;
    }

    public boolean isFullyNonReversible() {
        int t = this.nTiles - 1;
        while (t >= 0) {
            int c = this.nComp - 1;
            while (c >= 0) {
                if (((String)this.getSpec(t, c)).equals("reversible")) {
                    return false;
                }
                --c;
            }
            --t;
        }
        return true;
    }
}

