/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import icc.ICCProfiler;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.image.output.ImgWriter;
import jj2000.j2k.image.output.ImgWriterArray;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;
import jj2000.j2k.wavelet.synthesis.InverseWT;
import ucar.unidata.io.RandomAccessFile;

public class Grib2JpegDecoder {
    private int packBytes;
    public int[] data;
    private ColorSpace csMap = null;
    private boolean isChildProcess = false;
    private int exitCode;
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private HeaderInfo hi;
    private static final char[] vprfxs = new char[]{'B', 'C', 'R', 'Q', 'M', 'H', 'I'};
    private static final String[][] pinfo = new String[][]{{"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}, {"v", "[on|off]", "Prints version and copyright information", "off"}, {"verbose", "[on|off]", "Prints information about the decoded codestream", "on"}, {"pfile", "<filename>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with '\\'. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"res", "<resolution level index>", "The resolution level at which to reconstruct the image  (0 means the lowest available resolution whereas the maximum resolution level corresponds to the original image resolution). If the given index is greater than the number of available resolution levels of the compressed image, the image is reconstructed at its highest resolution (among all tile-components). Note that this option affects only the inverse wavelet transform and not the number  of bytes read by the codestream parser: this number of bytes depends only on options '-nbytes' or '-rate'.", null}, {"i", "<filename or url>", "The file containing the JPEG 2000 compressed data. This can be either a JPEG 2000 codestream or a JP2 file containing a JPEG 2000 codestream. In the latter case the first codestream in the file will be decoded. If an URL is specified (e.g., http://...) the data will be downloaded and cached in memory before decoding. This is intended for easy use in applets, but it is not a very efficient way of decoding network served data.", null}, {"o", "<filename>", "This is the name of the file to which the decompressed image is written. If no output filename is given, the image is displayed on the screen. Output file format is PGX by default. If the extension is '.pgm' then a PGM file is written as output, however this is only permitted if the component bitdepth does not exceed 8. If the extension is '.ppm' then a PPM file is written, however this is only permitted if there are 3 components and none of them has a bitdepth of more than 8. If there is more than 1 component, suffices '-1', '-2', '-3', ... are added to the file name, just before the extension, except for PPM files where all three components are written to the same file.", null}, {"rate", "<decoding rate in bpp>", "Specifies the decoding rate in bits per pixel (bpp) where the number of pixels is related to the image's original size (Note: this number is not affected by the '-res' option). If it is equalto -1, the whole codestream is decoded. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bytes, use '-nbytes' options instead.", "-1"}, {"nbytes", "<decoding rate in bytes>", "Specifies the decoding rate in bytes. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bits per pixel, use '-rate' options instead.", "-1"}, {"parsing", null, "Enable or not the parsing mode when decoding rate is specified ('-nbytes' or '-rate' options). If it is false, the codestream is decoded as if it were truncated to the given rate. If it is true, the decoder creates, truncates and decodes a virtual layer progressive codestream with the same truncation points in each code-block.", "on"}, {"ncb_quit", "<max number of code blocks>", "Use the ncb and lbody quit conditions. If state information is found for more code blocks than is indicated with this option, the decoder will decode using only information found before that point. Using this otion implies that the 'rate' or 'nbyte' parameter is used to indicate the lbody parameter which is the number of packet body bytes the decoder will decode.", "-1"}, {"l_quit", "<max number of layers>", "Specifies the maximum number of layers to decode for any code-block", "-1"}, {"m_quit", "<max number of bit planes>", "Specifies the maximum number of bit planes to decode for any code-block", "-1"}, {"poc_quit", null, "Specifies the whether the decoder should only decode code-blocks included in the first progression order.", "off"}, {"one_tp", null, "Specifies whether the decoder should only decode the first tile part of each tile.", "off"}, {"comp_transf", null, "Specifies whether the component transform indicated in the codestream should be used.", "on"}, {"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"cdstr_info", null, "Display information about the codestream. This information is: \n- Marker segments value in main and tile-part headers,\n- Tile-part length and position within the code-stream.", "off"}, {"nocolorspace", null, "Ignore any colorspace information in the image.", "off"}, {"colorspace_debug", null, "Print debugging messages when an error is encountered in the colorspace module.", "off"}};

    public Grib2JpegDecoder(String[] argv) {
        String[][] param = Grib2JpegDecoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            this.defpl.put(param[i][0], param[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (argv.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(argv);
        }
        catch (StringFormatException e) {
            System.err.println("An error occured while parsing the arguments:\n" + e.getMessage());
            return;
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void decode(RandomAccessFile raf, int dataSize) {
        imwriter = null;
        decSpec = null;
        try {
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                verbose = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                this.pl.checkList(Grib2JpegDecoder.vprfxs, ParameterList.toNameArray(Grib2JpegDecoder.pinfo));
            }
            catch (IllegalArgumentException e) {
                this.error(e.getMessage(), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            buf = new byte[dataSize];
            raf.read(buf);
            bais = new ByteArrayInputStream(buf);
            in = new ISRandomAccessIO(bais, dataSize, 1, dataSize);
            ff = new FileFormatReader(in);
            ff.readFileFormat();
            if (ff.JP2FFUsed) {
                in.seek(ff.getFirstCodeStreamPos());
            }
            this.hi = new HeaderInfo();
            try {
                hd = new HeaderDecoder(in, this.pl, this.hi);
            }
            catch (EOFException e) {
                this.error("Codestream too short or bad header, unable to decode.", 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            nCompCod = hd.getNumComps();
            nTiles = this.hi.siz.getNumTiles();
            decSpec = hd.getDecoderSpecs();
            if (verbose) {
                info = nCompCod + " component(s) in codestream, " + nTiles + " tile(s)\n";
                info = info + "Image dimension: ";
                for (c = 0; c < nCompCod; ++c) {
                    info = info + this.hi.siz.getCompImgWidth(c) + "x" + this.hi.siz.getCompImgHeight(c) + " ";
                }
                if (nTiles != 1) {
                    info = info + "\nNom. Tile dim. (in canvas): " + this.hi.siz.xtsiz + "x" + this.hi.siz.ytsiz;
                }
                System.out.println("[INFO]: " + info);
            }
            if (this.pl.getBooleanParameter("cdstr_info")) {
                System.out.println("[INFO]: Main header:\n" + this.hi.toStringMainHeader());
            }
            depth = new int[nCompCod];
            for (i = 0; i < nCompCod; ++i) {
                depth[i] = hd.getOriginalBitDepth(i);
            }
            try {
                breader = BitstreamReaderAgent.createInstance(in, hd, this.pl, decSpec, this.pl.getBooleanParameter("cdstr_info"), this.hi);
            }
            catch (IOException e) {
                this.error("Error while reading bit stream header or parsing packets" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate bit stream reader" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                entdec = hd.createEntropyDecoder(breader, this.pl);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate entropy decoder" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                roids = hd.createROIDeScaler(entdec, this.pl, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate roi de-scaler." + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                deq = hd.createDequantizer(roids, depth, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate dequantizer" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                invWT = InverseWT.createInstance(deq, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate inverse wavelet transform" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            res = breader.getImgRes();
            invWT.setImgResLevel(res);
            converter = new ImgDataConverter(invWT, 0);
            ictransf = new InvCompTransf(converter, decSpec, depth, this.pl);
            if (ff.JP2FFUsed && this.pl.getParameter("nocolorspace").equals("off")) {
                try {
                    this.csMap = new ColorSpace(in, hd, this.pl);
                    channels = hd.createChannelDefinitionMapper(ictransf, this.csMap);
                    resampled = hd.createResampler(channels, this.csMap);
                    palettized = hd.createPalettizedColorSpaceMapper(resampled, this.csMap);
                    color /* !! */  = hd.createColorSpaceMapper(palettized, this.csMap);
                    if (!this.csMap.debugging()) ** GOTO lbl157
                    System.out.println("[ERROR]: " + this.csMap);
                    System.out.println("[ERROR]: " + channels);
                    System.out.println("[ERROR]: " + resampled);
                    System.out.println("[ERROR]: " + palettized);
                    System.out.println("[ERROR]: " + color /* !! */ );
                }
                catch (IllegalArgumentException e) {
                    this.error("Could not instantiate ICC profiler" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 1, e);
                    return;
                }
                catch (ColorSpaceException e) {
                    this.error("error processing jp2 colorspace information" + (e.getMessage() != null ? ": " + e.getMessage() : "    "), 1, e);
                    return;
                }
            } else {
                color /* !! */  = ictransf;
            }
lbl157:
            // 3 sources

            decodedImage = color /* !! */ ;
            if (color /* !! */  == null) {
                decodedImage = ictransf;
            }
            nCompImg = decodedImage.getNumComps();
            mrl = decSpec.dls.getMin();
            if (verbose) {
                if (mrl != res) {
                    System.out.println("Reconstructing resolution " + res + " on " + mrl + " (" + breader.getImgWidth(res) + "x" + breader.getImgHeight(res) + ")");
                }
                if (this.pl.getFloatParameter("rate") != -1.0f) {
                    System.out.println("Target rate = " + breader.getTargetRate() + " bpp (" + breader.getTargetNbytes() + " bytes)");
                }
            }
            imwriter = new ImgWriter[nCompImg];
            for (i = 0; i < imwriter.length; ++i) {
                try {
                    imwriter[i] = this.csMap != null ? new ImgWriterArray(decodedImage, i, this.csMap.isOutputSigned(i)) : new ImgWriterArray(decodedImage, i, hd.isOriginalSigned(i));
                }
                catch (IOException e) {
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                try {
                    imwriter[i].writeAll();
                    iwa = (ImgWriterArray)imwriter[i];
                    this.data = iwa.getGdata();
                    this.packBytes = iwa.getPackBytes();
                    continue;
                }
                catch (IOException e) {
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            if (verbose) {
                bitrate = breader.getActualRate();
                numBytes = breader.getActualNbytes();
                if (ff.JP2FFUsed) {
                    imageSize = (int)(8.0f * (float)numBytes / bitrate);
                    bitrate = (float)(numBytes += ff.getFirstCodeStreamPos()) * 8.0f / (float)imageSize;
                }
                if (this.pl.getIntParameter("ncb_quit") == -1) {
                    System.out.println("Actual bit rate = " + bitrate + " bpp (i.e. " + numBytes + " bytes)");
                } else {
                    System.out.println("Number of packet body bytes read = " + numBytes);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            }
            return;
        }
        catch (Error e) {
            if (e.getMessage() != null) {
                this.error(e.getMessage(), 2);
            } else {
                this.error("An error has occured during decoding.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null) {
                this.error("An uncaught runtime exception has occurred:\n" + e.getMessage(), 2);
            } else {
                this.error("An uncaught runtime exception has occurred.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (Throwable e) {
            this.error("An uncaught exception has occurred.", 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    private void error(String msg, int code) {
        this.exitCode = code;
        System.out.println(msg);
    }

    private void error(String msg, int code, Throwable ex) {
        this.exitCode = code;
        System.out.println(msg);
        if (this.pl.getParameter("debug").equals("on")) {
            ex.printStackTrace();
        } else {
            this.error("Use '-debug' option for more details", 2);
        }
    }

    public int getPackBytes() {
        return this.packBytes;
    }

    public int[] getGdata() {
        return this.data;
    }

    public String[] getCOMInfo() {
        if (this.hi == null) {
            return null;
        }
        int nCOMMarkers = this.hi.getNumCOM();
        Enumeration com = this.hi.com.elements();
        String[] infoCOM = new String[nCOMMarkers];
        for (int i = 0; i < nCOMMarkers; ++i) {
            infoCOM[i] = com.nextElement().toString();
        }
        return infoCOM;
    }

    public static String[][] getAllParameters() {
        int i;
        Vector<String[]> vec = new Vector<String[]>();
        String[][] str = BitstreamReaderAgent.getParameterInfo();
        if (str != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = EntropyDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ROIDeScaler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = Dequantizer.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = InvCompTransf.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = HeaderDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ICCProfiler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = Grib2JpegDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = new String[vec.size()][4]) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                str[i] = (String[])vec.elementAt(i);
            }
        }
        return str;
    }

    private void warning(String msg) {
        System.out.println(msg);
    }

    private void printVersionAndCopyright() {
        System.out.println("JJ2000's JPEG 2000 Grib2JpegDecoder\n");
    }

    private void printUsage() {
        System.out.println("Usage:");
        System.out.println("Grib2JpegDecoder args...\n");
        System.out.println("The exit code of the decoder is non-zero if an error occurs.");
        System.out.println("The following arguments are recongnized:\n");
        this.printParamInfo(Grib2JpegDecoder.getAllParameters());
    }

    private void printParamInfo(String[][] pinfo) {
        for (int i = 0; i < pinfo.length; ++i) {
            String defval = this.defpl.getParameter(pinfo[i][0]);
            if (defval != null) {
                System.out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] + " " : " ") + "(default = " + defval + ")");
            } else {
                System.out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] : ""));
            }
            if (pinfo[i][2] == null) continue;
            System.out.println(pinfo[i][2]);
        }
    }

    public void exit() {
        if (this.isChildProcess) {
            return;
        }
        System.exit(0);
    }

    public void setChildProcess(boolean b) {
        this.isChildProcess = b;
    }
}

