/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

public class CBlkInfo {
    public int ulx;
    public int uly;
    public int w;
    public int h;
    public int msbSkipped;
    public int[] len;
    public int[] off;
    public int[] ntp;
    public int ctp;
    public int[][] segLen;
    public int[] pktIdx;

    public CBlkInfo(int ulx, int uly, int w, int h, int nl) {
        this.ulx = ulx;
        this.uly = uly;
        this.w = w;
        this.h = h;
        this.off = new int[nl];
        this.len = new int[nl];
        this.ntp = new int[nl];
        this.segLen = new int[nl][];
        this.pktIdx = new int[nl];
        int i = nl - 1;
        while (i >= 0) {
            this.pktIdx[i] = -1;
            --i;
        }
    }

    public void addNTP(int l, int newtp) {
        this.ntp[l] = newtp;
        this.ctp = 0;
        int lIdx = 0;
        while (lIdx <= l) {
            this.ctp += this.ntp[lIdx];
            ++lIdx;
        }
    }

    public String toString() {
        String string = "(ulx,uly,w,h)= (" + this.ulx + "," + this.uly + "," + this.w + "," + this.h;
        string = string + ") " + this.msbSkipped + " MSB bit(s) skipped\n";
        if (this.len != null) {
            int i = 0;
            while (i < this.len.length) {
                string = string + "\tl:" + i + ", start:" + this.off[i] + ", len:" + this.len[i] + ", ntp:" + this.ntp[i] + ", pktIdx=" + this.pktIdx[i];
                if (this.segLen != null && this.segLen[i] != null) {
                    string = string + " { ";
                    int j = 0;
                    while (j < this.segLen[i].length) {
                        string = string + this.segLen[i][j] + " ";
                        ++j;
                    }
                    string = string + "}";
                }
                string = string + "\n";
                ++i;
            }
        }
        string = string + "\tctp=" + this.ctp;
        return string;
    }
}

