/*
 * Decompiled with CFR 0.152.
 */
package icc;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import icc.ICCProfileException;
import icc.ICCProfileInvalidException;
import icc.RestrictedICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCTagTable;
import icc.tags.ICCXYZType;
import icc.types.ICCDateTime;
import icc.types.ICCProfileHeader;
import icc.types.ICCProfileVersion;
import icc.types.XYZNumber;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;

public abstract class ICCProfile {
    private static final String eol = System.getProperty("line.separator");
    public static final int GRAY = 0;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int boolean_size = 1;
    public static final int byte_size = 1;
    public static final int char_size = 2;
    public static final int short_size = 2;
    public static final int int_size = 4;
    public static final int float_size = 4;
    public static final int long_size = 8;
    public static final int double_size = 8;
    public static final int BITS_PER_BYTE = 8;
    public static final int BITS_PER_SHORT = 16;
    public static final int BITS_PER_INT = 32;
    public static final int BITS_PER_LONG = 64;
    public static final int BYTES_PER_SHORT = 2;
    public static final int BYTES_PER_INT = 4;
    public static final int BYTES_PER_LONG = 8;
    public static final int kdwProfileSignature = ICCProfile.getInt(new String("acsp").getBytes(), 0);
    public static final int kdwProfileSigReverse = ICCProfile.getInt(new String("psca").getBytes(), 0);
    public static final int kdwInputProfile = ICCProfile.getInt(new String("scnr").getBytes(), 0);
    public static final int kdwDisplayProfile = ICCProfile.getInt(new String("mntr").getBytes(), 0);
    public static final int kdwRGBData = ICCProfile.getInt(new String("RGB ").getBytes(), 0);
    public static final int kdwGrayData = ICCProfile.getInt(new String("GRAY").getBytes(), 0);
    public static final int kdwXYZData = ICCProfile.getInt(new String("XYZ ").getBytes(), 0);
    public static final int kMonochromeInput = 0;
    public static final int kThreeCompInput = 1;
    public static final int kdwGrayTRCTag = ICCProfile.getInt(new String("kTRC").getBytes(), 0);
    public static final int kdwRedColorantTag = ICCProfile.getInt(new String("rXYZ").getBytes(), 0);
    public static final int kdwGreenColorantTag = ICCProfile.getInt(new String("gXYZ").getBytes(), 0);
    public static final int kdwBlueColorantTag = ICCProfile.getInt(new String("bXYZ").getBytes(), 0);
    public static final int kdwRedTRCTag = ICCProfile.getInt(new String("rTRC").getBytes(), 0);
    public static final int kdwGreenTRCTag = ICCProfile.getInt(new String("gTRC").getBytes(), 0);
    public static final int kdwBlueTRCTag = ICCProfile.getInt(new String("bTRC").getBytes(), 0);
    public static final int kdwCopyrightTag = ICCProfile.getInt(new String("cprt").getBytes(), 0);
    public static final int kdwMediaWhiteTag = ICCProfile.getInt(new String("wtpt").getBytes(), 0);
    public static final int kdwProfileDescTag = ICCProfile.getInt(new String("desc").getBytes(), 0);
    private ICCProfileHeader header = null;
    private ICCTagTable tags = null;
    private byte[] profile = null;
    private byte[] data = null;
    private ParameterList pl = null;

    public static int getIntFromString(String fourChar) {
        byte[] bytes = fourChar.getBytes();
        return ICCProfile.getInt(bytes, 0);
    }

    public static XYZNumber getXYZNumber(byte[] data, int offset) {
        int x = ICCProfile.getInt(data, offset);
        int y = ICCProfile.getInt(data, offset + 4);
        int z = ICCProfile.getInt(data, offset + 8);
        return new XYZNumber(x, y, z);
    }

    public static ICCProfileVersion getICCProfileVersion(byte[] data, int offset) {
        byte major = data[offset];
        byte minor = data[offset + 1];
        byte resv1 = data[offset + 2];
        byte resv2 = data[offset + 3];
        return new ICCProfileVersion(major, minor, resv1, resv2);
    }

    public static ICCDateTime getICCDateTime(byte[] data, int offset) {
        short wYear = ICCProfile.getShort(data, offset);
        short wMonth = ICCProfile.getShort(data, offset + 2);
        short wDay = ICCProfile.getShort(data, offset + 4);
        short wHours = ICCProfile.getShort(data, offset + 6);
        short wMinutes = ICCProfile.getShort(data, offset + 8);
        short wSeconds = ICCProfile.getShort(data, offset + 10);
        return new ICCDateTime(wYear, wMonth, wDay, wHours, wMinutes, wSeconds);
    }

    public static String getString(byte[] bfr, int offset, int length, boolean swap) {
        byte[] result = new byte[length];
        int incr = swap ? -1 : 1;
        int start = swap ? offset + length - 1 : offset;
        int i = 0;
        int j = start;
        while (i < length) {
            result[i] = bfr[j];
            j += incr;
            ++i;
        }
        return new String(result);
    }

    public static short getShort(byte[] bfr, int off, boolean swap) {
        int tmp0 = bfr[off] & 0xFF;
        int tmp1 = bfr[off + 1] & 0xFF;
        return (short)(swap ? tmp1 << 8 | tmp0 : tmp0 << 8 | tmp1);
    }

    public static short getShort(byte[] bfr, int off) {
        int tmp0 = bfr[off] & 0xFF;
        int tmp1 = bfr[off + 1] & 0xFF;
        return (short)(tmp0 << 8 | tmp1);
    }

    public static byte[] setInt(int d) {
        return ICCProfile.setInt(d, new byte[4]);
    }

    public static byte[] setInt(int d, byte[] b) {
        if (b == null) {
            b = new byte[4];
        }
        int i = 0;
        while (i < 4) {
            b[i] = (byte)(d & 0xFF);
            d >>= 8;
            ++i;
        }
        return b;
    }

    public static byte[] setLong(long d) {
        return ICCProfile.setLong(d, new byte[4]);
    }

    public static byte[] setLong(long d, byte[] b) {
        if (b == null) {
            b = new byte[8];
        }
        int i = 0;
        while (i < 8) {
            b[i] = (byte)(d & 0xFFL);
            d >>= 8;
            ++i;
        }
        return b;
    }

    public static int getInt(byte[] bfr, int off, boolean swap) {
        int tmp0 = ICCProfile.getShort(bfr, off, swap) & 0xFFFF;
        int tmp1 = ICCProfile.getShort(bfr, off + 2, swap) & 0xFFFF;
        return swap ? tmp1 << 16 | tmp0 : tmp0 << 16 | tmp1;
    }

    public static int getInt(byte[] bfr, int off) {
        int tmp0 = ICCProfile.getShort(bfr, off) & 0xFFFF;
        int tmp1 = ICCProfile.getShort(bfr, off + 2) & 0xFFFF;
        return tmp0 << 16 | tmp1;
    }

    public static long getLong(byte[] bfr, int off) {
        long tmp0 = ICCProfile.getInt(bfr, off) & 0xFFFFFFFF;
        long tmp1 = ICCProfile.getInt(bfr, off + 4) & 0xFFFFFFFF;
        return tmp0 << 32 | tmp1;
    }

    private int getProfileSize() {
        return this.header.dwProfileSize;
    }

    private int getCMMTypeSignature() {
        return this.header.dwCMMTypeSignature;
    }

    private int getProfileClass() {
        return this.header.dwProfileClass;
    }

    private int getColorSpaceType() {
        return this.header.dwColorSpaceType;
    }

    private int getPCSType() {
        return this.header.dwPCSType;
    }

    private int getProfileSignature() {
        return this.header.dwProfileSignature;
    }

    private int getPlatformSignature() {
        return this.header.dwPlatformSignature;
    }

    private int getCMMFlags() {
        return this.header.dwCMMFlags;
    }

    private int getDeviceManufacturer() {
        return this.header.dwDeviceManufacturer;
    }

    private int getDeviceModel() {
        return this.header.dwDeviceModel;
    }

    private int getDeviceAttributes1() {
        return this.header.dwDeviceAttributes1;
    }

    private int getDeviceAttributesReserved() {
        return this.header.dwDeviceAttributesReserved;
    }

    private int getRenderingIntent() {
        return this.header.dwRenderingIntent;
    }

    private int getCreatorSig() {
        return this.header.dwCreatorSig;
    }

    private ICCProfileVersion getProfileVersion() {
        return this.header.profileVersion;
    }

    private void setProfileSignature(int profilesig) {
        this.header.dwProfileSignature = profilesig;
    }

    private void setProfileSize(int size) {
        this.header.dwProfileSize = size;
    }

    private void setCMMTypeSignature(int cmmsig) {
        this.header.dwCMMTypeSignature = cmmsig;
    }

    private void setProfileClass(int pclass) {
        this.header.dwProfileClass = pclass;
    }

    private void setColorSpaceType(int colorspace) {
        this.header.dwColorSpaceType = colorspace;
    }

    private void setPCSIlluminant(XYZNumber xyz) {
        this.header.PCSIlluminant = xyz;
    }

    private void setPCSType(int PCStype) {
        this.header.dwPCSType = PCStype;
    }

    private void setPlatformSignature(int platformsig) {
        this.header.dwPlatformSignature = platformsig;
    }

    private void setCMMFlags(int cmmflags) {
        this.header.dwCMMFlags = cmmflags;
    }

    private void setDeviceManufacturer(int manufacturer) {
        this.header.dwDeviceManufacturer = manufacturer;
    }

    private void setDeviceModel(int model) {
        this.header.dwDeviceModel = model;
    }

    private void setDeviceAttributes1(int attr1) {
        this.header.dwDeviceAttributes1 = attr1;
    }

    private void setDeviceAttributesReserved(int attrreserved) {
        this.header.dwDeviceAttributesReserved = attrreserved;
    }

    private void setRenderingIntent(int rendering) {
        this.header.dwRenderingIntent = rendering;
    }

    private void setCreatorSig(int creatorsig) {
        this.header.dwCreatorSig = creatorsig;
    }

    private void setProfileVersion(ICCProfileVersion version) {
        this.header.profileVersion = version;
    }

    private void setDateTime(ICCDateTime datetime) {
        this.header.dateTime = datetime;
    }

    private ICCProfile() throws ICCProfileException {
        throw new ICCProfileException("illegal to invoke empty constructor");
    }

    protected ICCProfile(ColorSpace csm) throws ColorSpaceException, ICCProfileInvalidException {
        this.pl = csm.pl;
        this.profile = csm.getICCProfile();
        this.initProfile(this.profile);
    }

    private void initProfile(byte[] data) throws ICCProfileInvalidException {
        this.header = new ICCProfileHeader(data);
        this.tags = ICCTagTable.createInstance((byte[])data);
        if (this.getProfileClass() == kdwDisplayProfile) {
            String message = "NOTE!! Technically, this profile is a Display profile, not an Input Profile, and thus is not a valid Restricted ICC profile. However, it is quite possible that this profile is usable as a Restricted ICC profile, so this code will ignore this state and proceed with processing.";
            FacilityManager.getMsgLogger().printmsg(2, message);
        }
        if (this.getProfileSignature() != kdwProfileSignature || this.getProfileClass() != kdwInputProfile && this.getProfileClass() != kdwDisplayProfile || this.getPCSType() != kdwXYZData) {
            throw new ICCProfileInvalidException();
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ICCProfile:");
        StringBuffer body = new StringBuffer();
        body.append(eol).append(this.header);
        body.append(eol).append(eol).append(this.tags);
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }

    public static String toHexString(byte i) {
        String rep = (i >= 0 && i < 16 ? "0" : "") + Integer.toHexString(i);
        if (rep.length() > 2) {
            rep = rep.substring(rep.length() - 2);
        }
        return rep;
    }

    public static String toHexString(short i) {
        String rep = i >= 0 && i < 16 ? "000" + Integer.toHexString(i) : (i >= 0 && i < 256 ? "00" + Integer.toHexString(i) : (i >= 0 && i < 4096 ? "0" + Integer.toHexString(i) : "" + Integer.toHexString(i)));
        if (rep.length() > 4) {
            rep = rep.substring(rep.length() - 4);
        }
        return rep;
    }

    public static String toHexString(int i) {
        String rep = i >= 0 && i < 16 ? "0000000" + Integer.toHexString(i) : (i >= 0 && i < 256 ? "000000" + Integer.toHexString(i) : (i >= 0 && i < 4096 ? "00000" + Integer.toHexString(i) : (i >= 0 && i < 65536 ? "0000" + Integer.toHexString(i) : (i >= 0 && i < 0x100000 ? "000" + Integer.toHexString(i) : (i >= 0 && i < 0x1000000 ? "00" + Integer.toHexString(i) : (i >= 0 && i < 0x10000000 ? "0" + Integer.toHexString(i) : "" + Integer.toHexString(i)))))));
        if (rep.length() > 8) {
            rep = rep.substring(rep.length() - 8);
        }
        return rep;
    }

    public static String toString(byte[] data) {
        byte b;
        int col;
        int l;
        int t;
        byte[] tbytes;
        StringBuffer rep = new StringBuffer();
        StringBuffer rep0 = null;
        StringBuffer rep1 = null;
        StringBuffer rep2 = null;
        int cols = 16;
        int rows = data.length / cols;
        int rem = data.length % cols;
        byte[] lbytes = new byte[8];
        int row = 0;
        int i = 0;
        while (row < rows) {
            rep1 = new StringBuffer();
            rep2 = new StringBuffer();
            i = 0;
            while (i < 8) {
                lbytes[i] = 0;
                ++i;
            }
            tbytes = Integer.toHexString(row * 16).getBytes();
            t = 0;
            l = lbytes.length - tbytes.length;
            while (t < tbytes.length) {
                lbytes[l] = tbytes[t];
                ++l;
                ++t;
            }
            rep0 = new StringBuffer(new String(lbytes));
            col = 0;
            while (col < cols) {
                b = data[i++];
                rep1.append(ICCProfile.toHexString(b)).append(i % 2 == 0 ? " " : "");
                if (Character.isJavaIdentifierStart((char)b)) {
                    rep2.append((char)b);
                } else {
                    rep2.append(".");
                }
                ++col;
            }
            rep.append(rep0).append(" :  ").append(rep1).append(":  ").append(rep2).append(eol);
            ++row;
        }
        rep1 = new StringBuffer();
        rep2 = new StringBuffer();
        i = 0;
        while (i < 8) {
            lbytes[i] = 0;
            ++i;
        }
        tbytes = Integer.toHexString(row * 16).getBytes();
        t = 0;
        l = lbytes.length - tbytes.length;
        while (t < tbytes.length) {
            lbytes[l] = tbytes[t];
            ++l;
            ++t;
        }
        rep0 = new StringBuffer(new String(lbytes));
        col = 0;
        while (col < rem) {
            b = data[i++];
            rep1.append(ICCProfile.toHexString(b)).append(i % 2 == 0 ? " " : "");
            if (Character.isJavaIdentifierStart((char)b)) {
                rep2.append((char)b);
            } else {
                rep2.append(".");
            }
            ++col;
        }
        col = rem;
        while (col < 16) {
            rep1.append("  ").append(col % 2 == 0 ? " " : "");
            ++col;
        }
        rep.append(rep0).append(" :  ").append(rep1).append(":  ").append(rep2).append(eol);
        return rep.toString();
    }

    public ICCProfileHeader getHeader() {
        return this.header;
    }

    public ICCTagTable getTagTable() {
        return this.tags;
    }

    public RestrictedICCProfile parse() throws ICCProfileInvalidException {
        ICCCurveType grayTag = (ICCCurveType)this.tags.get((Object)new Integer(kdwGrayTRCTag));
        if (grayTag != null) {
            return RestrictedICCProfile.createInstance(grayTag);
        }
        ICCCurveType rTRCTag = (ICCCurveType)this.tags.get((Object)new Integer(kdwRedTRCTag));
        if (rTRCTag != null) {
            ICCCurveType gTRCTag = (ICCCurveType)this.tags.get((Object)new Integer(kdwGreenTRCTag));
            ICCCurveType bTRCTag = (ICCCurveType)this.tags.get((Object)new Integer(kdwBlueTRCTag));
            ICCXYZType rColorantTag = (ICCXYZType)this.tags.get((Object)new Integer(kdwRedColorantTag));
            ICCXYZType gColorantTag = (ICCXYZType)this.tags.get((Object)new Integer(kdwGreenColorantTag));
            ICCXYZType bColorantTag = (ICCXYZType)this.tags.get((Object)new Integer(kdwBlueColorantTag));
            return RestrictedICCProfile.createInstance(rTRCTag, gTRCTag, bTRCTag, rColorantTag, gColorantTag, bColorantTag);
        }
        throw new ICCProfileInvalidException("curve data not found in profile");
    }

    public void write(RandomAccessFile os) throws IOException {
        this.getHeader().write(os);
        this.getTagTable().write(os);
    }

    private static class BoxType
    extends Hashtable {
        private static Hashtable map = new Hashtable();

        private BoxType() {
        }

        public static void put(int type, String desc) {
            map.put(new Integer(type), desc);
        }

        public static String get(int type) {
            return (String)map.get(new Integer(type));
        }

        public static String colorSpecMethod(int meth) {
            switch (meth) {
                case 2: {
                    return "Restricted ICC Profile";
                }
                case 1: {
                    return "Enumerated Color Space";
                }
            }
            return "Undefined Color Spec Method";
        }

        static {
            BoxType.put(1651532643, "BITS_PER_COMPONENT_BOX");
            BoxType.put(1919251299, "CAPTURE_RESOLUTION_BOX");
            BoxType.put(1667523942, "CHANNEL_DEFINITION_BOX");
            BoxType.put(1668246642, "COLOUR_SPECIFICATION_BOX");
            BoxType.put(1668112752, "COMPONENT_MAPPING_BOX");
            BoxType.put(1785737827, "CONTIGUOUS_CODESTREAM_BOX");
            BoxType.put(1919251300, "DEFAULT_DISPLAY_RESOLUTION_BOX");
            BoxType.put(1718909296, "FILE_TYPE_BOX");
            BoxType.put(1768449138, "IMAGE_HEADER_BOX");
            BoxType.put(1685074537, "INTELLECTUAL_PROPERTY_BOX");
            BoxType.put(1785737832, "JP2_HEADER_BOX");
            BoxType.put(1783636000, "JP2_SIGNATURE_BOX");
            BoxType.put(1885564018, "PALETTE_BOX");
            BoxType.put(1919251232, "RESOLUTION_BOX");
            BoxType.put(1970433056, "URL_BOX");
            BoxType.put(1970628964, "UUID_BOX");
            BoxType.put(1969843814, "UUID_INFO_BOX");
            BoxType.put(1969451892, "UUID_LIST_BOX");
            BoxType.put(2020437024, "XML_BOX");
        }
    }
}

