/*
 *                    BioJava development code
 *
 * This code may be freely distributed and modified under the
 * terms of the GNU Lesser General Public Licence.  This should
 * be distributed with the code.  If you do not have a copy,
 * see:
 *
 *      http://www.gnu.org/copyleft/lesser.html
 *
 * Copyright for this code is held jointly by the individual
 * authors.  These should be listed in @author doc comments.
 *
 * For more information on the BioJava project and its aims,
 * or to join the biojava-l mailing list, visit the home page
 * at:
 *
 *      http://www.biojava.org/
 *
 */

package org.biojava.bio.program.homologene;

import java.util.Set;

import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.AbstractChangeable;

/**
 * represents the Homologene Group.
 */
public abstract class AbstractOrthoPairSet
    extends AbstractChangeable
    implements OrthoPairSet
{

    public OrthoPairSet filter(OrthoPairFilter filter)
    {
        OrthoPairSet results = new SimpleOrthoPairSet();

        for (Iterator pairsI = iterator();
               pairsI.hasNext(); )
        {
            OrthoPair pair = pairsI.nextOrthoPair();

            if (filter.accept(pair)) {
                try {
                    results.addOrthoPair(pair);
                }
                catch (ChangeVetoException cve) {
                    // should be impossible as this group was created by me
                }
            }
        }
        return results;
    }
}

