/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.HTMLStringNode;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLTag;
import com.kizna.html.tags.HTMLTitleTag;
import java.io.IOException;

public class HTMLTitleScanner
extends HTMLTagScanner {
    public HTMLTitleScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        HTMLTagScanner.absorbLeadingBlanks(s);
        return s.toUpperCase().equals("TITLE");
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws IOException {
        boolean endFlag = false;
        String title = "";
        HTMLEndTag endTag = null;
        do {
            String tmp;
            HTMLNode node;
            if ((node = reader.readElement()) instanceof HTMLStringNode) {
                title = ((HTMLStringNode)node).getText();
            }
            if (!(node instanceof HTMLEndTag) || !(tmp = (endTag = (HTMLEndTag)node).getContents()).toUpperCase().equals("TITLE")) continue;
            endFlag = true;
        } while (!endFlag);
        return new HTMLTitleTag(tag.elementBegin(), endTag.elementEnd(), title, tag.getText(), tag.getTagLine());
    }
}

