/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLStyleTag;
import com.kizna.html.tags.HTMLTag;
import java.io.IOException;

public class HTMLStyleScanner
extends HTMLTagScanner {
    public HTMLStyleScanner() {
    }

    public HTMLStyleScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        boolean retVal = false;
        if ((s = HTMLTagScanner.absorbLeadingBlanks(s)).toUpperCase().indexOf("STYLE") == 0) {
            retVal = true;
        }
        return retVal;
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws IOException {
        HTMLEndTag endTag = null;
        HTMLNode node = null;
        boolean endStyleFound = false;
        StringBuffer buff = new StringBuffer();
        int currLoc = currentLine.toUpperCase().indexOf("<STYLE>");
        String line = currentLine.substring(currLoc += "<STYLE>".length(), currentLine.length());
        boolean newLine = false;
        do {
            if (line == null) continue;
            node = HTMLEndTag.find(line, 0);
            if (node != null) {
                HTMLEndTag tempEndTag = (HTMLEndTag)node;
                endTag = !newLine ? new HTMLEndTag(tempEndTag.elementBegin() + tag.elementEnd() + 1, tempEndTag.elementEnd() + tag.elementEnd() + 1, tempEndTag.getContents()) : tempEndTag;
                if (endTag.getContents().toUpperCase().equals("STYLE")) {
                    endStyleFound = true;
                    String temp = !newLine ? line.substring(0, endTag.elementBegin() - tag.elementBegin()) : line.substring(0, endTag.elementBegin());
                    buff.append(temp);
                } else {
                    buff.append(line);
                    buff.append("\n");
                }
            } else {
                buff.append(line);
                buff.append("\n");
            }
            if (!endStyleFound) {
                line = reader.getNextLine();
            }
            newLine = true;
        } while (!endStyleFound && line != null);
        HTMLStyleTag styleTag = new HTMLStyleTag(tag.elementBegin(), endTag.elementEnd(), buff.toString(), currentLine);
        styleTag.setThisScanner(this);
        return styleTag;
    }
}

