/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLScriptTag;
import com.kizna.html.tags.HTMLTag;
import java.io.IOException;

public class HTMLScriptScanner
extends HTMLTagScanner {
    private String language;
    private String type;

    public HTMLScriptScanner() {
    }

    public HTMLScriptScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        boolean retVal = false;
        if ((s = HTMLTagScanner.absorbLeadingBlanks(s)).toUpperCase().indexOf("SCRIPT") == 0) {
            retVal = true;
        }
        return retVal;
    }

    public void extractLanguage(HTMLTag tag) {
        this.language = this.extractField(tag, "LANGUAGE");
    }

    public void extractType(HTMLTag tag) {
        this.type = this.extractField(tag, "TYPE");
    }

    public String getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.type;
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws IOException {
        this.extractLanguage(tag);
        this.extractType(tag);
        HTMLEndTag endTag = null;
        HTMLNode node = null;
        boolean endScriptFound = false;
        StringBuffer buff = new StringBuffer();
        String line = currentLine;
        int lookPos = tag.elementEnd() + 1;
        do {
            if (line != null) {
                node = HTMLEndTag.find(line, lookPos);
                if (node != null) {
                    endTag = (HTMLEndTag)node;
                    if (endTag.getContents().toUpperCase().equals("SCRIPT")) {
                        endScriptFound = true;
                        if (endTag.elementBegin() > 0) {
                            buff.append(line.substring(lookPos, endTag.elementBegin()));
                        }
                    } else {
                        buff.append(line);
                        buff.append("\n\r");
                    }
                } else {
                    buff.append(line);
                    buff.append("\n\r");
                }
            }
            if (endScriptFound) continue;
            line = reader.getNextLine();
            lookPos = 0;
        } while (!endScriptFound && line != null);
        HTMLScriptTag scriptTag = new HTMLScriptTag(0, node.elementEnd(), tag.getText(), buff.toString(), this.language, this.type, currentLine);
        scriptTag.setThisScanner(this);
        return scriptTag;
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }
}

