/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLDoctypeTag;
import com.kizna.html.tags.HTMLTag;
import java.io.IOException;

public class HTMLDoctypeScanner
extends HTMLTagScanner {
    private String language;
    private String type;

    public HTMLDoctypeScanner() {
    }

    public HTMLDoctypeScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        boolean retVal = false;
        if ((s = HTMLTagScanner.absorbLeadingBlanks(s)).toUpperCase().indexOf("!DOCTYPE") == 0) {
            retVal = true;
        }
        return retVal;
    }

    public void extractLanguage(HTMLTag tag) {
        this.language = this.extractField(tag, "LANGUAGE");
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws IOException {
        String tagContents = tag.getText();
        tagContents = tagContents.substring(9, tagContents.length());
        HTMLDoctypeTag docTypeTag = new HTMLDoctypeTag(tag.elementBegin(), tag.elementEnd(), tagContents, currentLine);
        docTypeTag.setThisScanner(this);
        return docTypeTag;
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }
}

