/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLAppletTag;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLTag;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLAppletScanner
extends HTMLTagScanner {
    private String className;
    private String archive;
    private String codebase;

    public HTMLAppletScanner() {
    }

    public HTMLAppletScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        return (s = HTMLTagScanner.absorbLeadingBlanks(s)).toUpperCase().indexOf("APPLET") == 0;
    }

    public void extractFields(HTMLTag tag) {
        this.className = this.extractField(tag, "CODE");
        this.archive = this.extractField(tag, "ARCHIVE");
        this.codebase = this.extractField(tag, "CODEBASE");
    }

    public String getArchive() {
        return this.archive;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws IOException {
        String line;
        tag.getText();
        this.extractFields(tag);
        HTMLEndTag endTag = null;
        HTMLNode node = null;
        boolean endScriptFound = false;
        Vector<HTMLNode> buff = new Vector<HTMLNode>();
        Vector<HTMLTag> misc = new Vector<HTMLTag>();
        do {
            if ((line = reader.getNextLine()) == null) continue;
            node = HTMLEndTag.find(line, 0);
            if (node != null) {
                endTag = (HTMLEndTag)node;
                if (!endTag.getContents().toUpperCase().equals("APPLET")) continue;
                endScriptFound = true;
                continue;
            }
            node = HTMLTag.find(reader, line, 0);
            if (node == null) continue;
            buff.addElement(node);
        } while (!endScriptFound && line != null);
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (buff != null) {
            Enumeration e = buff.elements();
            while (e.hasMoreElements()) {
                HTMLNode hnode = (HTMLNode)e.nextElement();
                if (!(hnode instanceof HTMLTag)) continue;
                HTMLTag htag = (HTMLTag)hnode;
                String paramName = this.extractField(htag, "NAME");
                if (paramName != null && paramName.length() != 0) {
                    String paramValue = this.extractField(htag, "VALUE");
                    table.put(paramName, paramValue);
                    continue;
                }
                misc.addElement(htag);
            }
        }
        HTMLAppletTag appTag = new HTMLAppletTag(node.elementBegin(), node.elementEnd(), tag.getText(), currLine, this.className, this.archive, this.codebase, table, misc);
        appTag.setThisScanner(this);
        return appTag;
    }

    public void setArchive(String newArchive) {
        this.archive = newArchive;
    }

    public void setClassName(String newClassName) {
        this.className = newClassName;
    }

    public void setCodebase(String newCodebase) {
        this.codebase = newCodebase;
    }
}

