/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;

public class HTMLStringNode
implements HTMLNode {
    protected String text;
    protected int textBegin;
    protected int textEnd;

    public HTMLStringNode(String text, int textBegin, int textEnd) {
        this.text = text;
        this.textBegin = textBegin;
        this.textEnd = textEnd;
    }

    public int elementBegin() {
        return this.textBegin;
    }

    public int elementEnd() {
        return this.textEnd;
    }

    public static HTMLNode find(HTMLReader reader, String input, int position) {
        String text = "";
        int state = 0;
        int textBegin = position;
        int textEnd = position;
        int i = position;
        while (i < input.length() && state != 2) {
            if (input.charAt(i) == '<' && state == 0) {
                return null;
            }
            if (input.charAt(i) == '<') {
                state = 2;
                textEnd = i - 1;
            }
            if (state == 0) {
                if (input.charAt(i) != ' ') {
                    state = 1;
                } else {
                    text = String.valueOf(text) + input.charAt(i);
                }
            }
            if (state == 1) {
                text = String.valueOf(text) + input.charAt(i);
            }
            if (state == 1 && i == input.length() - 1) {
                state = 2;
                textEnd = i;
            }
            ++i;
        }
        if (textBegin <= textEnd) {
            return new HTMLStringNode(text, textBegin, textEnd);
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void print() {
        System.out.println("Text = " + this.text + "; begins at : " + this.elementBegin() + "; ends at : " + this.elementEnd());
    }

    public String toString() {
        return "Text = " + this.text + "; begins at : " + this.elementBegin() + "; ends at : " + this.elementEnd();
    }
}

