/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLParser;
import com.kizna.html.HTMLRemarkNode;
import com.kizna.html.HTMLStringNode;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLTag;
import java.io.BufferedReader;
import java.io.IOException;

public class HTMLReader
extends BufferedReader {
    protected int posInLine = -1;
    protected String line;
    protected HTMLNode node = null;
    protected HTMLTagScanner previousOpenScanner = null;
    protected String url;
    private BufferedReader in;
    private HTMLParser parser;

    public HTMLReader(BufferedReader in, int len) {
        super(in, len);
        this.in = in;
        this.parser = null;
    }

    public HTMLReader(BufferedReader in, String url) {
        super(in);
        this.in = in;
        this.url = url;
        this.parser = null;
    }

    public int getLastReadPosition() {
        if (this.node != null) {
            return this.node.elementEnd();
        }
        return 0;
    }

    public String getNextLine() {
        try {
            this.line = this.readLine();
            this.posInLine = 0;
            return this.line;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception occurred while reading!");
            return null;
        }
    }

    public HTMLParser getParser() {
        return this.parser;
    }

    public HTMLNode readElement() throws IOException {
        if (this.readNextLine()) {
            do {
                this.line = this.getNextLine();
            } while (this.line != null && this.line.length() == 0);
        } else {
            this.posInLine = this.node.elementEnd() + 1;
        }
        if (this.line == null) {
            return null;
        }
        this.node = HTMLRemarkNode.find(this, this.line, this.posInLine);
        if (this.node != null) {
            return this.node;
        }
        this.node = HTMLStringNode.find(this, this.line, this.posInLine);
        if (this.node != null) {
            return this.node;
        }
        this.node = HTMLTag.find(this, this.line, this.posInLine);
        if (this.node != null) {
            HTMLTag tag = (HTMLTag)this.node;
            try {
                this.node = tag.scan(this.parser.getScanners(), this.url, this);
                return this.node;
            }
            catch (IOException iOException) {
                System.err.println("Error! I/O Exception occurred while reading " + this.url);
            }
        }
        this.node = HTMLEndTag.find(this.line, this.posInLine);
        if (this.node != null) {
            return this.node;
        }
        return null;
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    protected boolean readNextLine() {
        return this.posInLine == -1 || this.line != null && this.node.elementEnd() + 1 >= this.line.length();
    }

    public void setParser(HTMLParser newParser) {
        this.parser = newParser;
    }

    public HTMLTagScanner getPreviousOpenScanner() {
        return this.previousOpenScanner;
    }

    public void setPreviousOpenScanner(HTMLTagScanner previousOpenScanner) {
        this.previousOpenScanner = previousOpenScanner;
    }
}

