/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.tags;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HTMLTag
implements HTMLNode {
    public static final String TAGNAME = "$<TAGNAME>$";
    protected static final int TAG_BEFORE_PARSING_STATE = 0;
    protected static final int TAG_BEGIN_PARSING_STATE = 1;
    protected static final int TAG_FINISHED_PARSING_STATE = 2;
    protected static final int TAG_ILLEGAL_STATE = 3;
    protected static final int TAG_IGNORE_DATA_STATE = 4;
    StringBuffer tagContents;
    int tagBegin;
    int tagEnd;
    private Hashtable parsed = null;
    protected HTMLTagScanner thisScanner = null;
    private String tagLine;

    public HTMLTag(int tagBegin, int tagEnd, String tagContents, String tagLine) {
        this.tagBegin = tagBegin;
        this.tagEnd = tagEnd;
        this.tagContents = new StringBuffer();
        this.tagContents.append(tagContents);
        this.tagLine = tagLine;
    }

    public int elementBegin() {
        return this.tagBegin;
    }

    public int elementEnd() {
        return this.tagEnd;
    }

    public static HTMLTag find(HTMLReader reader, String input, int position) {
        int state = 0;
        new StringBuffer();
        int i = position;
        HTMLTag tag = new HTMLTag(0, 0, "", input);
        while (i < tag.getTagLine().length() && state != 2 && state != 3) {
            char ch = tag.getTagLine().charAt(i);
            state = HTMLTag.automataInput(state, i, ch, tag);
            i = HTMLTag.incrementCounter(reader, state, i, tag);
        }
        if (state == 2) {
            return tag;
        }
        return null;
    }

    public static int incrementCounter(HTMLReader reader, int state, int i, HTMLTag tag) {
        if ((state == 1 || state == 4) && i == tag.getTagLine().length() - 1) {
            tag.setTagLine(reader.getNextLine());
            tag.append('\n');
            i = -1;
        }
        return ++i;
    }

    protected static int automataInput(int state, int i, char ch, HTMLTag tag) {
        state = HTMLTag.checkIllegalState(state, i, ch, tag);
        state = HTMLTag.checkFinishedState(state, i, ch, tag);
        state = HTMLTag.toggleIgnoringState(state, ch);
        HTMLTag.checkIfAppendable(state, ch, tag);
        state = HTMLTag.checkBeginParsingState(state, i, ch, tag);
        return state;
    }

    private static int checkBeginParsingState(int state, int i, char ch, HTMLTag tag) {
        if (ch == '<' && (state == 0 || state == 3)) {
            tag.setTagBegin(i);
            state = 1;
        }
        return state;
    }

    private static void checkIfAppendable(int state, char ch, HTMLTag tag) {
        if (state == 4 || state == 1) {
            tag.append(ch);
        }
    }

    private static int toggleIgnoringState(int state, char ch) {
        if (ch == '\"') {
            if (state == 4) {
                state = 1;
            } else if (state == 1) {
                state = 4;
            }
        }
        return state;
    }

    private static int checkFinishedState(int state, int i, char ch, HTMLTag tag) {
        if (ch == '>' && state == 1) {
            state = 2;
            tag.setTagEnd(i);
        }
        return state;
    }

    private static int checkIllegalState(int state, int i, char ch, HTMLTag tag) {
        if (ch == '/' && i > 0 && tag.getTagLine().charAt(i - 1) == '<') {
            state = 3;
        }
        return state;
    }

    protected static int automataIllegalState(String input, int state, int i, char ch) {
        if (ch == '/' && i > 0 && input.charAt(i - 1) == '<') {
            state = 3;
        }
        return state;
    }

    public String getParameter(String name) {
        if (this.parsed == null) {
            return null;
        }
        return (String)this.parsed.get(name.toUpperCase());
    }

    public String getTag() {
        if (this.parsed == null) {
            return null;
        }
        return (String)this.parsed.get(TAGNAME);
    }

    public String getTagLine() {
        return this.tagLine;
    }

    public String getText() {
        return this.tagContents.toString();
    }

    public HTMLTagScanner getThisScanner() {
        return this.thisScanner;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Hashtable parseParameters() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        boolean isAmp = false;
        boolean isApo = false;
        boolean isValue = false;
        boolean isName = true;
        boolean waitingForValue = false;
        String name = null;
        String value = null;
        String t = null;
        waitingForValue = false;
        StringTokenizer token = new StringTokenizer(String.valueOf(this.getText()) + " ", " \t\r\n\f=\"'>", true);
        while (token.hasMoreTokens()) {
            block15: {
                String st;
                block16: {
                    st = token.nextToken();
                    if (!isAmp && !isApo) break block16;
                    if (isAmp && st.equals("\"")) {
                        isAmp = false;
                        break block15;
                    } else if (isApo && st.equals("'")) {
                        isApo = false;
                        break block15;
                    } else {
                        t = String.valueOf(t) + st;
                        continue;
                    }
                }
                if (st.equals("\"")) {
                    isAmp = true;
                    t = "";
                    continue;
                }
                if (st.equals("'")) {
                    isApo = true;
                    t = "";
                    continue;
                }
                t = st;
            }
            if (" \t\r\n\f=\"'>".indexOf(t) >= 0) {
                if (waitingForValue && t.equals("=")) {
                    waitingForValue = false;
                    isValue = true;
                    value = "";
                }
                if (name == null || isValue) continue;
                if (isName && value == null) {
                    value = TAGNAME;
                } else if (value == null) {
                    value = "";
                }
                if (isName) {
                    h.put(value, name.toUpperCase());
                } else {
                    h.put(name.toUpperCase(), value);
                }
                isName = false;
                name = null;
                name = null;
                value = null;
                continue;
            }
            if (isValue) {
                value = t;
                isValue = false;
                continue;
            }
            if (name != null) continue;
            name = t;
            waitingForValue = true;
        }
        return h;
    }

    public void print() {
        System.out.println("Begin Tag : " + this.tagContents + "; begins at : " + this.elementBegin() + "; ends at : " + this.elementEnd());
    }

    public HTMLNode scan(Enumeration scanners, String url, HTMLReader reader) throws IOException {
        boolean found = false;
        HTMLNode retVal = null;
        Enumeration e = scanners;
        while (e.hasMoreElements() && !found) {
            HTMLTagScanner scanner = (HTMLTagScanner)e.nextElement();
            if (!scanner.evaluate(this.tagContents.toString(), reader.getPreviousOpenScanner())) continue;
            found = true;
            reader.setPreviousOpenScanner(scanner);
            retVal = scanner.scan(this, url, reader, this.tagLine);
            reader.setPreviousOpenScanner(null);
        }
        if (!found) {
            return this;
        }
        return retVal;
    }

    public void setTagLine(String newTagLine) {
        this.tagLine = newTagLine;
    }

    public void setThisScanner(HTMLTagScanner scanner) {
        this.thisScanner = scanner;
    }

    public void setTagEnd(int tagEnd) {
        this.tagEnd = tagEnd;
    }

    public void setTagBegin(int tagBegin) {
        this.tagBegin = tagBegin;
    }

    public void append(char ch) {
        this.tagContents.append(ch);
    }
}

