/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.tags;

import com.kizna.html.HTMLNode;
import com.kizna.html.tags.HTMLTag;
import java.util.Enumeration;
import java.util.Vector;

public class HTMLLinkTag
extends HTMLTag {
    protected String link;
    protected String linkText;
    protected String linkContents;
    protected String accessKey;
    private Vector nodeVector;
    private boolean mailLink;

    public HTMLLinkTag(String link, String linkText, int linkBegin, int linkEnd, String accessKey, String currentLine, Vector nodeVector, boolean mailLink, String tagContents, String linkContents) {
        super(linkBegin, linkEnd, tagContents, currentLine);
        this.link = link;
        this.linkText = linkText;
        this.accessKey = accessKey;
        this.nodeVector = nodeVector;
        this.mailLink = mailLink;
        this.linkContents = linkContents;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLink() {
        return this.link;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public String getText() {
        return this.tagContents + ">" + this.linkContents;
    }

    public boolean isMailLink() {
        return this.mailLink;
    }

    public Enumeration linkData() {
        return this.nodeVector.elements();
    }

    public void print() {
        System.out.print("Link to : " + this.link + "; titled : " + this.linkText + "; begins at : " + this.elementBegin() + "; ends at : " + this.elementEnd() + ", AccessKey=");
        if (this.accessKey == null) {
            System.out.println("null");
        } else {
            System.out.println(this.accessKey);
        }
        if (this.linkData() != null) {
            System.out.println("  LinkData");
            System.out.println("  --------");
            int i = 0;
            Enumeration e = this.linkData();
            while (e.hasMoreElements()) {
                HTMLNode node = (HTMLNode)e.nextElement();
                System.out.print("   " + i++ + ":");
                node.print();
            }
        }
    }

    public void setMailLink(boolean newMailLink) {
        this.mailLink = newMailLink;
    }

    public void setNodeVector(Vector newNodeVector) {
        this.nodeVector = newNodeVector;
    }
}

