/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.HTMLStringNode;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLTag;
import java.io.IOException;

public abstract class HTMLTagScanner {
    protected String filter;

    public HTMLTagScanner() {
        this.filter = "";
    }

    public HTMLTagScanner(String filter) {
        this.filter = filter;
    }

    public String absorb(String s, char c) {
        int index = s.indexOf(c);
        if (index != -1) {
            s = s.substring(index + 1, s.length());
        }
        return s;
    }

    public static String absorbLeadingBlanks(String s) {
        String temp = new String(s);
        while (temp.charAt(0) == ' ') {
            temp = temp.substring(1, temp.length());
        }
        return temp;
    }

    public abstract boolean evaluate(String var1, HTMLTagScanner var2);

    public String extractField(HTMLTag tag, String field) {
        String s = tag.getText();
        int fieldPos = s.toUpperCase().indexOf(field);
        if (fieldPos == -1) {
            return "";
        }
        int loc = fieldPos + field.length();
        s = s.substring(loc, s.length());
        s = this.absorb(s, '=');
        int n = (s = this.absorb(s, '\"')).indexOf(34);
        if (n == -1) {
            n = s.indexOf(32);
        }
        if (n != -1) {
            s = s.substring(0, n);
        }
        return s;
    }

    public static String extractXMLData(HTMLNode node, String tagName, HTMLReader reader) {
        HTMLEndTag endTag;
        String xmlData = "";
        boolean xmlTagFound = HTMLTagScanner.isXMLTagFound(node, tagName);
        if (xmlTagFound) {
            try {
                do {
                    if ((node = reader.readElement()) == null) continue;
                    if (node instanceof HTMLStringNode) {
                        HTMLStringNode stringNode = (HTMLStringNode)node;
                        if (xmlData.length() > 0) {
                            xmlData = String.valueOf(xmlData) + " ";
                        }
                        xmlData = String.valueOf(xmlData) + stringNode.getText();
                        continue;
                    }
                    if (node instanceof HTMLEndTag) continue;
                    xmlTagFound = false;
                } while (node instanceof HTMLStringNode);
            }
            catch (IOException iOException) {}
        }
        if (xmlTagFound && node != null && node instanceof HTMLEndTag && !(endTag = (HTMLEndTag)node).getContents().equals(tagName)) {
            xmlTagFound = false;
        }
        if (xmlTagFound) {
            return xmlData;
        }
        return null;
    }

    public String getFilter() {
        return this.filter;
    }

    public static boolean isXMLTagFound(HTMLNode node, String tagName) {
        HTMLTag tag;
        boolean xmlTagFound = false;
        if (node instanceof HTMLTag && (tag = (HTMLTag)node).getText().toUpperCase().indexOf(tagName) == 0) {
            xmlTagFound = true;
        }
        return xmlTagFound;
    }

    public abstract HTMLNode scan(HTMLTag var1, String var2, HTMLReader var3, String var4) throws IOException;

    public String removeChars(String s, char occur) {
        StringBuffer newString = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != occur) {
                newString.append(ch);
            }
            ++i;
        }
        return newString.toString();
    }
}

