/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.HTMLStringNode;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLEndTag;
import com.kizna.html.tags.HTMLLinkTag;
import com.kizna.html.tags.HTMLTag;
import com.kizna.html.util.HTMLLinkProcessor;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLLinkScanner
extends HTMLTagScanner {
    private boolean dirty = false;

    public HTMLLinkScanner() {
    }

    public HTMLLinkScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        boolean retVal;
        char ch = (s = HTMLTagScanner.absorbLeadingBlanks(s)).charAt(0);
        if ((ch == 'a' || ch == 'A') && s.length() == 1) {
            if (previousOpenScanner instanceof HTMLLinkScanner) {
                this.dirty = true;
                return true;
            }
        } else {
            this.dirty = false;
        }
        if ((retVal = !(ch != 'a' && ch != 'A' || s.charAt(1) != ' ' && s.charAt(1) != '\n')) && s.toUpperCase().indexOf("HREF") == -1) {
            retVal = false;
        }
        return retVal;
    }

    public String extractLink(HTMLTag tag, String url) {
        Hashtable table = tag.parseParameters();
        String relativeLink = (String)table.get("HREF");
        if (relativeLink != null) {
            relativeLink = this.removeChars(relativeLink, '\n');
        }
        return new HTMLLinkProcessor().extract(relativeLink, url);
    }

    public String getAccessKey(String text) {
        String sub = "ACCESSKEY";
        String accessKey = null;
        int n = text.toUpperCase().indexOf(sub);
        if (n != -1) {
            char ch;
            n += sub.length();
            do {
                ch = text.charAt(n);
                ++n;
            } while (ch != '=');
            accessKey = "";
            do {
                if ((ch = text.charAt(n)) < '0' || ch > '9') continue;
                accessKey = String.valueOf(accessKey) + ch;
            } while (ch >= '0' && ch <= '9' && ++n < text.length());
            return accessKey;
        }
        return null;
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws IOException {
        HTMLNode node;
        if (this.dirty) {
            return new HTMLEndTag(tag.elementBegin(), tag.elementEnd(), "A");
        }
        boolean mailLink = false;
        String linkText = "";
        String accessKey = null;
        String tagContents = tag.getText();
        String linkContents = "";
        String link = this.extractLink(tag, url);
        int mailto = link.indexOf("mailto");
        if (mailto == 0) {
            mailto = link.indexOf(":");
            link = link.substring(mailto + 1);
            mailLink = true;
        }
        accessKey = this.getAccessKey(tag.getText());
        int linkBegin = tag.elementBegin();
        boolean endFlag = false;
        Vector<HTMLNode> nodeVector = new Vector<HTMLNode>();
        do {
            String tmp;
            if ((node = reader.readElement()) instanceof HTMLStringNode) {
                tmp = ((HTMLStringNode)node).getText();
                linkText = String.valueOf(linkText) + tmp;
                linkContents = String.valueOf(linkContents) + tmp;
            }
            if (node instanceof HTMLEndTag) {
                tmp = ((HTMLEndTag)node).getContents();
                linkContents = String.valueOf(linkContents) + "</" + tmp;
                char ch = tmp.charAt(0);
                if (ch == 'a' || ch == 'A') {
                    endFlag = true;
                    continue;
                }
                endFlag = false;
                continue;
            }
            nodeVector.addElement(node);
        } while (!endFlag);
        if (node instanceof HTMLEndTag) {
            return this.createLinkTag(currentLine, node, mailLink, link, linkText, accessKey, linkBegin, tagContents, linkContents, nodeVector);
        }
        return null;
    }

    protected HTMLNode createLinkTag(String currentLine, HTMLNode node, boolean mailLink, String link, String linkText, String accessKey, int linkBegin, String tagContents, String linkContents, Vector nodeVector) {
        int linkEnd = node.elementEnd();
        HTMLLinkTag linkTag = new HTMLLinkTag(link, linkText, linkBegin, linkEnd, accessKey, currentLine, nodeVector, mailLink, tagContents, linkContents);
        linkTag.setThisScanner(this);
        return linkTag;
    }

    public boolean getDirty() {
        return this.dirty;
    }
}

