/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.scanners;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.tags.HTMLImageTag;
import com.kizna.html.tags.HTMLTag;
import com.kizna.html.util.HTMLLinkProcessor;
import java.io.IOException;
import java.util.Hashtable;

public class HTMLImageScanner
extends HTMLTagScanner {
    public HTMLImageScanner() {
    }

    public HTMLImageScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        s = HTMLTagScanner.absorbLeadingBlanks(s);
        int state = 0;
        s = s.toUpperCase();
        int i = 0;
        while (i < s.length() && state < 3) {
            char ch = s.charAt(i);
            if (ch == 'I' && state == 0) {
                state = 1;
            } else if (ch == 'M' && state == 1) {
                state = 2;
            } else if (ch == 'G' && state == 2) {
                state = 3;
            } else if (ch != ' ') {
                state = 4;
            }
            ++i;
        }
        return state == 3;
    }

    public String extractImageLocn(HTMLTag tag, String url) {
        Hashtable table = tag.parseParameters();
        String relativeLink = (String)table.get("SRC");
        if (relativeLink != null) {
            relativeLink = this.removeChars(relativeLink, '\n');
        }
        if (relativeLink == null) {
            return "";
        }
        return new HTMLLinkProcessor().extract(relativeLink, url);
    }

    public HTMLNode scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws IOException {
        String link = this.extractImageLocn(tag, url);
        int linkBegin = tag.elementBegin();
        int linkEnd = tag.elementEnd();
        HTMLImageTag imageTag = new HTMLImageTag(link, linkBegin, linkEnd, currentLine);
        imageTag.setThisScanner(this);
        return imageTag;
    }
}

