/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.parserapplications;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLParser;
import com.kizna.html.tags.HTMLLinkTag;
import java.util.Enumeration;

public class Robot {
    private HTMLParser parser;

    public Robot(String resourceLocation) {
        this.parser = new HTMLParser(resourceLocation);
        this.parser.registerScanners();
    }

    public void crawl(int crawlDepth) {
        this.crawl(this.parser, crawlDepth);
    }

    public void crawl(HTMLParser parser, int crawlDepth) {
        System.out.println(" crawlDepth = " + crawlDepth);
        Enumeration e = parser.elements();
        while (e.hasMoreElements()) {
            HTMLLinkTag linkTag;
            HTMLNode node = (HTMLNode)e.nextElement();
            if (!(node instanceof HTMLLinkTag) || (linkTag = (HTMLLinkTag)node).isMailLink() || linkTag.getLink().toUpperCase().indexOf("HTM") == -1 && linkTag.getLink().toUpperCase().indexOf("COM") == -1 && linkTag.getLink().toUpperCase().indexOf("ORG") == -1) continue;
            if (crawlDepth > 0) {
                HTMLParser newParser = new HTMLParser(linkTag.getLink());
                newParser.registerScanners();
                System.out.print("Crawling to " + linkTag.getLink());
                this.crawl(newParser, crawlDepth - 1);
                continue;
            }
            System.out.println(linkTag.getLink());
        }
    }

    public static void main(String[] args) {
        System.out.println("Robot Crawler v1.1 (Released Apr 7, 2002)");
        if (args.length < 2 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -classpath htmlparser.jar com.kizna.parserapplications.Robot <resourceLocn/website> <depth>");
            System.out.println();
            System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path ");
            System.out.println("                  if not in current directory)");
            System.out.println("   <depth> No of links to be followed from each link");
            System.out.println("   -help This screen");
            System.out.println();
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("Example : java -classpath htmlparser.jar com.kizna.parserapplications.Robot http://www.google.com 3");
            System.out.println();
            System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
            System.exit(-1);
        }
        String resourceLocation = "";
        int crawlDepth = 1;
        if (args.length != 0) {
            resourceLocation = args[0];
        }
        if (args.length == 2) {
            crawlDepth = Integer.valueOf(args[1]);
        }
        Robot robot = new Robot(resourceLocation);
        System.out.println("Crawling Site " + resourceLocation);
        robot.crawl(crawlDepth);
    }
}

