/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html.parserapplications;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLParser;
import com.kizna.html.tags.HTMLLinkTag;
import java.util.Enumeration;
import java.util.Vector;

public class MailRipper {
    private HTMLParser parser;

    public MailRipper(String resourceLocation) {
        this.parser = new HTMLParser(resourceLocation);
        this.parser.registerScanners();
    }

    public static void main(String[] args) {
        System.out.println("Mail Ripper v1.1 (Released Apr 7, 2002)");
        if (args.length < 1 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -classpath htmlparser.jar com.kizna.parserapplications.MailRipper <resourceLocn/website>");
            System.out.println();
            System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path ");
            System.out.println("                  if not in current directory)");
            System.out.println("   -help This screen");
            System.out.println();
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("Example : java -classpath htmlparser.jar com.kizna.parserapplications.MailRipper http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
            System.exit(-1);
        }
        String resourceLocation = "http://htmlparser.sourceforge.net";
        if (args.length != 0) {
            resourceLocation = args[0];
        }
        MailRipper ripper = new MailRipper(resourceLocation);
        System.out.println("Ripping Site " + resourceLocation);
        Enumeration e = ripper.rip();
        while (e.hasMoreElements()) {
            HTMLLinkTag tag = (HTMLLinkTag)e.nextElement();
            System.out.println("Ripped mail address : " + tag.getLink());
        }
    }

    public Enumeration rip() {
        Vector<HTMLLinkTag> mailAddresses = new Vector<HTMLLinkTag>();
        Enumeration e = this.parser.elements();
        while (e.hasMoreElements()) {
            HTMLLinkTag linkTag;
            HTMLNode node = (HTMLNode)e.nextElement();
            if (!(node instanceof HTMLLinkTag) || !(linkTag = (HTMLLinkTag)node).isMailLink()) continue;
            mailAddresses.addElement(linkTag);
        }
        return mailAddresses.elements();
    }
}

