/*
 * Decompiled with CFR 0.152.
 */
package com.kizna.html;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLReader;
import com.kizna.html.scanners.HTMLAppletScanner;
import com.kizna.html.scanners.HTMLImageScanner;
import com.kizna.html.scanners.HTMLJspScanner;
import com.kizna.html.scanners.HTMLLinkScanner;
import com.kizna.html.scanners.HTMLMetaTagScanner;
import com.kizna.html.scanners.HTMLScriptScanner;
import com.kizna.html.scanners.HTMLStyleScanner;
import com.kizna.html.scanners.HTMLTagScanner;
import com.kizna.html.scanners.HTMLTitleScanner;
import com.kizna.html.tags.HTMLTag;
import com.kizna.html.util.HTMLLinkProcessor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;

public class HTMLParser {
    protected String resourceLocn;
    protected HTMLReader reader;
    protected HTMLNode node;
    protected boolean readFlag = false;
    private Vector scanners = new Vector();
    public static final String VERSION_STRING = "1.1 (Released Apr 7, 2002)";

    public HTMLParser(HTMLReader reader) {
        this.reader = reader;
        reader.setParser(this);
    }

    public HTMLParser(String resourceLocn) {
        this.resourceLocn = resourceLocn;
        this.openConnection();
    }

    public void addScanner(HTMLTagScanner scanner) {
        this.scanners.addElement(scanner);
    }

    private String checkEnding(String link) {
        link.indexOf("html");
        link.indexOf("htm");
        link.indexOf("php");
        link.indexOf("jsp");
        return link;
    }

    public Enumeration elements() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                if (HTMLParser.this.reader == null) {
                    return false;
                }
                try {
                    HTMLParser.this.node = HTMLParser.this.reader.readElement();
                    HTMLParser.this.readFlag = true;
                    return HTMLParser.this.node != null;
                }
                catch (IOException iOException) {
                    System.err.println("I/O Exception occured while reading " + HTMLParser.this.resourceLocn);
                    return false;
                }
            }

            public Object nextElement() {
                try {
                    if (!HTMLParser.this.readFlag) {
                        HTMLParser.this.node = HTMLParser.this.reader.readElement();
                    }
                    return HTMLParser.this.node;
                }
                catch (IOException iOException) {
                    System.err.println("I/O Exception occured while reading " + HTMLParser.this.resourceLocn);
                    return null;
                }
            }
        };
    }

    public void flushScanners() {
        this.scanners = new Vector();
    }

    public int getNumScanners() {
        return this.scanners.size();
    }

    public Enumeration getScanners() {
        return this.scanners.elements();
    }

    public static void main(String[] args) {
        System.out.println("HTMLParser v1.1 (Released Apr 7, 2002)");
        if (args.length < 1 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -jar htmlparser.jar <resourceLocn/website> -l");
            System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path if not in current directory)");
            System.out.println("   -l Show only the link tags extracted from the document");
            System.out.println("   -i Show only the image tags extracted from the document");
            System.out.println("   -s Show only the Javascript code extracted from the document");
            System.out.println("   -t Show only the Style code extracted from the document");
            System.out.println("   -a Show only the Applet tag extracted from the document");
            System.out.println("   -j Parse JSP tags");
            System.out.println("   -m Parse Meta tags");
            System.out.println("   -t Extract the Title");
            System.out.println("   -help This screen");
            System.out.println();
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("Example : java -jar htmlparser.jar http://www.yahoo.com");
            System.out.println();
            System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
            System.exit(-1);
        }
        if (args[0].indexOf("http") != -1 || args[0].indexOf("www.") != -1) {
            System.out.println("Parsing website " + args[0]);
        } else {
            System.out.println("Parsing file " + args[0] + "...");
        }
        HTMLParser parser = new HTMLParser(args[0]);
        parser.registerScanners();
        if (args.length == 2) {
            parser.parse(args[1]);
        } else {
            parser.parse(null);
        }
    }

    private void openConnection() {
        try {
            if (this.resourceLocn.indexOf("http") != -1 || this.resourceLocn.indexOf("www.") != -1) {
                this.resourceLocn = HTMLLinkProcessor.removeEscapeCharacters(this.resourceLocn);
                this.resourceLocn = this.checkEnding(this.resourceLocn);
                URL url = new URL(this.resourceLocn);
                URLConnection uc = url.openConnection();
                this.reader = new HTMLReader(new BufferedReader(new InputStreamReader(uc.getInputStream(), "8859_4")), this.resourceLocn);
            } else {
                this.reader = new HTMLReader(new BufferedReader(new FileReader(this.resourceLocn)), this.resourceLocn);
            }
            this.reader.setParser(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error! File " + this.resourceLocn + " not found!");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error! URL " + this.resourceLocn + " Malformed!");
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception occured while reading " + this.resourceLocn);
        }
    }

    public void parse(String filter) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            if (node != null) {
                String tagFilter;
                HTMLTag tag;
                HTMLTagScanner scanner;
                if (filter == null) {
                    node.print();
                    continue;
                }
                if (!(node instanceof HTMLTag) || (scanner = (tag = (HTMLTag)node).getThisScanner()) == null || (tagFilter = scanner.getFilter()) == null || !tagFilter.equals(filter)) continue;
                node.print();
                continue;
            }
            System.out.println("Node is null");
        }
    }

    public void registerScanners() {
        if (this.scanners.size() > 0) {
            System.err.println("registerScanners() should be called first, when no other scanner has been registered.");
            System.err.println("Other scanners already exist, hence this method call wont have any effect");
            return;
        }
        this.addScanner(new HTMLLinkScanner("-l"));
        this.addScanner(new HTMLImageScanner("-i"));
        this.addScanner(new HTMLScriptScanner("-s"));
        this.addScanner(new HTMLStyleScanner("-t"));
        this.addScanner(new HTMLJspScanner("-j"));
        this.addScanner(new HTMLAppletScanner("-a"));
        this.addScanner(new HTMLMetaTagScanner("-m"));
        this.addScanner(new HTMLTitleScanner("-t"));
    }

    public boolean removeScanner(HTMLTagScanner scanner) {
        return this.scanners.removeElement(scanner);
    }

    public void setScanners(Vector newScanners) {
        this.scanners = newScanners;
    }
}

