/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class StringConstantInstruction
implements Instruction {
    private String s;

    StringConstantInstruction(String s) {
        if (s == null) {
            throw new NullPointerException("Can't make a StringConstantInstruction for a null string");
        }
        this.s = s;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        int i_indx = ctx.getConstants().resolveString(this.s);
        if (i_indx < 256) {
            ctx.writeByte((byte)18);
            ctx.writeByte((byte)i_indx);
        } else {
            ctx.writeByte((byte)19);
            ctx.writeShort(i_indx);
        }
    }
}

