/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.List;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;

public class SimpleCodeMethod
implements CodeMethod {
    private String name;
    private CodeClass parent;
    private CodeClass type;
    private List args;
    private int modifiers;

    public SimpleCodeMethod(String name, CodeClass parent, CodeClass type, List args, int mods) {
        this.name = name;
        this.parent = parent;
        this.type = type;
        this.args = args;
        this.modifiers = mods;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getContainingClass().getName() + "." + this.getName();
    }

    public CodeClass getContainingClass() {
        return this.parent;
    }

    public String getDescriptor() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int i = 0;
        while (i < this.numParameters()) {
            CodeClass cc = this.getParameterType(i);
            sb.append(cc.getDescriptor());
            ++i;
        }
        sb.append(')');
        sb.append(this.getReturnType().getDescriptor());
        return sb.toString();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CodeClass getReturnType() {
        return this.type;
    }

    public int numParameters() {
        return this.args.size();
    }

    public CodeClass getParameterType(int pos) {
        return (CodeClass)this.args.get(pos);
    }
}

