/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.Instruction;

class MethodInstruction
implements Instruction {
    private CodeMethod meth;
    private byte opcode;

    MethodInstruction(byte op, CodeMethod m) {
        if (m == null) {
            throw new NullPointerException("CodeMethod can not be null");
        }
        this.opcode = op;
        this.meth = m;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        if (this.opcode == -71) {
            ctx.writeShort(ctx.getConstants().resolveInterfaceMethod(this.meth));
            int count = 1;
            int i = 0;
            while (i < this.meth.numParameters()) {
                CodeClass ptype = this.meth.getParameterType(i);
                count = ptype == CodeUtils.TYPE_LONG || ptype == CodeUtils.TYPE_DOUBLE ? (count += 2) : ++count;
                ++i;
            }
            ctx.writeByte((byte)count);
            ctx.writeByte((byte)0);
        } else {
            ctx.writeShort(ctx.getConstants().resolveMethod(this.meth));
        }
    }
}

