/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.IntrospectedCodeConstructor;
import org.biojava.utils.bytecode.IntrospectedCodeMethod;

public class IntrospectedCodeClass
implements CodeClass {
    private static Map introspectedClasses = new HashMap();
    private static Map primitiveDescriptors = new HashMap();
    private Class clazz;
    private Set _methods;

    public static CodeClass forClass(Class c) {
        CodeClass cc = (CodeClass)introspectedClasses.get(c);
        if (cc == null) {
            cc = new IntrospectedCodeClass(c);
            introspectedClasses.put(c, cc);
        }
        return cc;
    }

    public static CodeClass forClass(String name) throws ClassNotFoundException {
        Class<?> c = ClassLoader.getSystemClassLoader().loadClass(name);
        return IntrospectedCodeClass.forClass(c);
    }

    private IntrospectedCodeClass(Class c) {
        this.clazz = c;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getJName() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String getDescriptor() {
        if (this.clazz.isPrimitive()) {
            String desc = (String)primitiveDescriptors.get(this.clazz);
            if (desc == null) {
                throw new RuntimeException("Unknown primitive type " + this.clazz.getName() + ", eeek!");
            }
            return desc;
        }
        if (this.clazz.isArray()) {
            return "[" + IntrospectedCodeClass.forClass(this.clazz.getComponentType()).getDescriptor();
        }
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        sb.append('L');
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append(';');
        return sb.toString();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public CodeClass getSuperClass() {
        return IntrospectedCodeClass.forClass(this.clazz.getSuperclass());
    }

    public List getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        return Arrays.asList(interfaces);
    }

    public Set getMethods() {
        if (this._methods == null) {
            Method[] jmethods = this.clazz.getMethods();
            this._methods = new HashSet();
            int i = 0;
            while (i < jmethods.length) {
                this._methods.add(new IntrospectedCodeMethod(jmethods[i]));
                ++i;
            }
        }
        return this._methods;
    }

    public CodeField getFieldByName(String name) throws NoSuchFieldException {
        try {
            Field f = this.clazz.getField(name);
            return new CodeField(this, name, IntrospectedCodeClass.forClass(f.getType()), f.getModifiers());
        }
        catch (NoSuchFieldException ex) {
            throw new NoSuchFieldException("Can't find field " + name + " in class " + this.getName());
        }
    }

    public Set getMethodsByName(String name) {
        HashSet<CodeMethod> s = new HashSet<CodeMethod>();
        Iterator i = this.getMethods().iterator();
        while (i.hasNext()) {
            CodeMethod cm = (CodeMethod)i.next();
            if (!cm.getName().equals(name)) continue;
            s.add(cm);
        }
        return s;
    }

    public CodeMethod getMethod(String name, CodeClass[] args) throws NoSuchMethodException {
        try {
            Class[] argsC = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argsC[i] = ((IntrospectedCodeClass)args[i]).clazz;
                ++i;
            }
            return new IntrospectedCodeMethod(this.clazz.getMethod(name, argsC));
        }
        catch (NoSuchMethodException nsme) {
            throw new NoSuchMethodException("Could not find method " + this.getName() + "." + name + "(" + CodeUtils.classListToString(args) + ")");
        }
    }

    public CodeMethod getConstructor(CodeClass[] args) throws NoSuchMethodException {
        try {
            Class[] argsC = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argsC[i] = ((IntrospectedCodeClass)args[i]).clazz;
                ++i;
            }
            return new IntrospectedCodeConstructor(this.clazz.getConstructor(argsC));
        }
        catch (NoSuchMethodException nsme) {
            throw new NoSuchMethodException("Could not find constructor new " + this.getName() + "(" + CodeUtils.classListToString(args) + ")");
        }
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    static {
        primitiveDescriptors.put(Byte.TYPE, "B");
        primitiveDescriptors.put(Character.TYPE, "C");
        primitiveDescriptors.put(Double.TYPE, "D");
        primitiveDescriptors.put(Float.TYPE, "F");
        primitiveDescriptors.put(Integer.TYPE, "I");
        primitiveDescriptors.put(Long.TYPE, "J");
        primitiveDescriptors.put(Short.TYPE, "S");
        primitiveDescriptors.put(Boolean.TYPE, "Z");
        primitiveDescriptors.put(Void.TYPE, "V");
    }
}

