/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class IntConstantInstruction
implements Instruction {
    private int i;

    IntConstantInstruction(int i) {
        this.i = i;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        int i_indx = ctx.getConstants().resolveInt(this.i);
        if (i_indx < 256) {
            ctx.writeByte((byte)18);
            ctx.writeByte((byte)i_indx);
        } else {
            ctx.writeByte((byte)19);
            ctx.writeShort(i_indx);
        }
    }
}

