/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Label;

public class InstructionVector
implements CodeGenerator {
    private List instructions;
    private Label endLabel = new Label();
    private Label startLabel = new Label();

    public InstructionVector() {
        this.instructions = new ArrayList();
    }

    public void add(CodeGenerator g) {
        this.instructions.add(g);
    }

    public int size() {
        return this.instructions.size();
    }

    public void add(int pos, CodeGenerator g) {
        this.instructions.add(pos, g);
    }

    public void remove(int pos) {
        this.instructions.remove(pos);
    }

    public CodeGenerator generatorAt(int pos) {
        return (CodeGenerator)this.instructions.get(pos);
    }

    public Label getStartLabel() {
        return this.startLabel;
    }

    public Label getEndLabel() {
        return this.endLabel;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        CodeContext subctx = ctx.subContext();
        subctx.open();
        subctx.markLabel(this.startLabel);
        Iterator i = this.instructions.iterator();
        while (i.hasNext()) {
            CodeGenerator cg = (CodeGenerator)i.next();
            cg.writeCode(subctx);
        }
        subctx.markLabel(this.endLabel);
        subctx.close();
    }
}

