/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LabelInstruction;

public class IfExpression
implements CodeGenerator {
    private Instruction ifInstruction;
    private CodeGenerator ifTrue;
    private CodeGenerator ifFalse;
    private Label trueLabel = new Label();
    private Label endLabel = new Label();
    private Instruction skipTrue = ByteCode.make_goto(this.endLabel);

    public Instruction getIfInstruction() {
        return this.ifInstruction;
    }

    public CodeGenerator getIfTrue() {
        return this.ifTrue;
    }

    public CodeGenerator getIfFalse() {
        return this.ifFalse;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        CodeContext subctx = ctx.subContext();
        subctx.open();
        this.ifInstruction.writeCode(subctx);
        this.ifFalse.writeCode(subctx);
        this.skipTrue.writeCode(subctx);
        subctx.markLabel(this.trueLabel);
        this.ifTrue.writeCode(subctx);
        subctx.markLabel(this.endLabel);
        subctx.close();
    }

    public IfExpression(byte ifInstruction, CodeGenerator ifTrue, CodeGenerator ifFalse) {
        this.ifInstruction = new LabelInstruction(ifInstruction, this.trueLabel);
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }
}

