/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.MethodRootContext;

public class GeneratedCodeClass
implements CodeClass {
    private String name;
    private CodeClass superClass;
    private List interfaces;
    private int modifiers;
    private Map methods = new HashMap();
    private Map fields = new HashMap();

    public GeneratedCodeClass(String name, Class superClass, Class[] interfaces, int modifiers) throws CodeException {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = IntrospectedCodeClass.forClass(superClass);
        this.interfaces = new ArrayList<Class>(Arrays.asList(interfaces));
        Iterator i = this.interfaces.iterator();
        while (i.hasNext()) {
            Class clazz = (Class)i.next();
            if (clazz.isInterface()) continue;
            throw new CodeException("Attempted to create class implemneting non-interface " + clazz);
        }
    }

    public GeneratedCodeClass(String name, CodeClass superClass, CodeClass[] interfaces, int modifiers) throws CodeException {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = new ArrayList<CodeClass>(Arrays.asList(interfaces));
        Iterator i = this.interfaces.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof CodeClass) continue;
            throw new CodeException("Interface list must contain CodeClass instances");
        }
    }

    public List getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Set getMethods() {
        return this.methods.keySet();
    }

    public Set getMethodsByName(String name) {
        Set all = this.getMethods();
        HashSet<CodeMethod> some = new HashSet<CodeMethod>();
        Iterator i = all.iterator();
        while (i.hasNext()) {
            CodeMethod m = (CodeMethod)i.next();
            if (!m.getName().equals(name)) continue;
            some.add(m);
        }
        return some;
    }

    public CodeMethod getConstructor(CodeClass[] args) throws NoSuchMethodException {
        return this.getMethod("<init>", args);
    }

    public CodeMethod getMethod(String name, CodeClass[] args) throws NoSuchMethodException {
        Set poss = this.getMethodsByName(name);
        Iterator i = poss.iterator();
        block0: while (i.hasNext()) {
            CodeMethod meth = (CodeMethod)i.next();
            if (meth.numParameters() != args.length) continue;
            int j = 0;
            while (j < args.length) {
                if (!meth.getParameterType(j).equals(args[j])) continue block0;
                ++j;
            }
            return meth;
        }
        StringBuffer methodSig = new StringBuffer("Could not find method " + this.getName() + "." + name + "(");
        if (args.length > 0) {
            methodSig.append(args[0].getName());
        }
        int i2 = 1;
        while (i2 < args.length) {
            methodSig.append(",");
            methodSig.append(args[i2].getName());
            ++i2;
        }
        methodSig.append(")");
        throw new NoSuchMethodException(methodSig.toString());
    }

    public Set getFields() {
        return this.fields.keySet();
    }

    public CodeClass getSuperClass() {
        return this.superClass;
    }

    public CodeField getFieldByName(String name) throws NoSuchFieldException {
        CodeField f = (CodeField)this.fields.get(name);
        if (f == null) {
            throw new NoSuchFieldException("No field for " + name + " in class " + this.getName());
        }
        return f;
    }

    public String getName() {
        return this.name;
    }

    public String getJName() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getDescriptor() {
        String name = this.getName();
        StringBuffer sb = new StringBuffer();
        sb.append('L');
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                sb.append('/');
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append(';');
        return sb.toString();
    }

    public GeneratedCodeMethod createMethod(String name, CodeClass type, CodeClass[] args, String[] argNames, int mods) throws CodeException {
        GeneratedCodeMethod cm = new GeneratedCodeMethod(this, name, type, args, argNames, mods);
        if (this.methods.containsKey(cm)) {
            throw new CodeException("Attempt to create multiple methods with same signatures.");
        }
        this.methods.put(cm, null);
        return cm;
    }

    public GeneratedCodeMethod createMethod(String name, CodeClass type, CodeClass[] args, int mods) throws CodeException {
        return this.createMethod(name, type, args, new String[0], mods);
    }

    public CodeField createField(String name, CodeClass clazz, int mods) throws CodeException {
        if (this.fields.containsKey(name)) {
            throw new CodeException("Attempt to create multiple fields named " + name);
        }
        CodeField cf = new CodeField(this, name, clazz, mods);
        this.fields.put(name, cf);
        return cf;
    }

    public void setCodeGenerator(CodeMethod method, CodeGenerator cg) throws CodeException {
        if (!this.methods.containsKey(method)) {
            throw new CodeException("Class doesn't provide method " + method.getName());
        }
        this.methods.put(method, cg);
    }

    public void createCode(OutputStream os) throws IOException, CodeException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(-889275714);
        dos.writeShort(3);
        dos.writeShort(45);
        ConstantPool cp = new ConstantPool();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream bdos = new DataOutputStream(baos);
        bdos.writeShort(this.modifiers);
        bdos.writeShort(cp.resolveClass(this));
        bdos.writeShort(cp.resolveClass(this.superClass));
        bdos.writeShort(this.interfaces.size());
        Iterator i = this.interfaces.iterator();
        while (i.hasNext()) {
            bdos.writeShort(cp.resolveClass((CodeClass)i.next()));
        }
        bdos.writeShort(this.fields.size());
        Iterator i2 = this.fields.values().iterator();
        while (i2.hasNext()) {
            CodeField cf = (CodeField)i2.next();
            bdos.writeShort(cf.getModifiers());
            bdos.writeShort(cp.resolveUtf8(cf.getName()));
            bdos.writeShort(cp.resolveUtf8(cf.getType().getDescriptor()));
            bdos.writeShort(0);
        }
        Set methSet = this.methods.entrySet();
        bdos.writeShort(methSet.size());
        Iterator i3 = methSet.iterator();
        while (i3.hasNext()) {
            Map.Entry me = i3.next();
            GeneratedCodeMethod cm = (GeneratedCodeMethod)me.getKey();
            CodeGenerator cg = (CodeGenerator)me.getValue();
            bdos.writeShort(cm.getModifiers());
            bdos.writeShort(cp.resolveUtf8(cm.getName()));
            bdos.writeShort(cp.resolveUtf8(cm.getDescriptor()));
            MethodRootContext ctx = new MethodRootContext(this, cm, cp);
            ctx.open();
            LocalVariable thisP = cm.getThis();
            if (thisP != null) {
                ctx.resolveLocal(thisP);
            }
            int parm = 0;
            while (parm < cm.numParameters()) {
                ctx.resolveLocal(cm.getVariable(parm));
                ++parm;
            }
            cg.writeCode(ctx);
            ctx.close();
            Set thrownExceptions = cm.getThrownExceptions();
            bdos.writeShort(thrownExceptions.size() > 0 ? 2 : 1);
            List exceptionTable = ctx.getExceptionTable();
            bdos.writeShort(cp.resolveUtf8("Code"));
            bdos.writeInt(12 + ctx.getOffset() + exceptionTable.size() * 8);
            bdos.writeShort(20);
            bdos.writeShort(ctx.getMaxLocals());
            bdos.writeInt(ctx.getOffset());
            ctx.writeTo(bdos);
            bdos.writeShort(exceptionTable.size());
            Iterator ei = exceptionTable.iterator();
            while (ei.hasNext()) {
                ExceptionMemento em = (ExceptionMemento)ei.next();
                if (!em.isFullyResolved()) {
                    throw new CodeException("Exception table entry refers to unresolved label");
                }
                bdos.writeShort(em.startHandled.getOffset());
                bdos.writeShort(em.endHandled.getOffset());
                bdos.writeShort(em.handler.getOffset());
                if (em.eClass != null) {
                    bdos.writeShort(cp.resolveClass(em.eClass));
                    continue;
                }
                bdos.writeShort(0);
            }
            bdos.writeShort(0);
            if (thrownExceptions.size() <= 0) continue;
            bdos.writeShort(cp.resolveUtf8("Exceptions"));
            bdos.writeInt(4 + thrownExceptions.size() * 2);
            bdos.writeShort(thrownExceptions.size());
            Iterator tei = thrownExceptions.iterator();
            while (tei.hasNext()) {
                CodeClass exClass = (CodeClass)tei.next();
                bdos.writeShort(cp.resolveClass(exClass));
            }
        }
        bdos.writeShort(0);
        dos.writeShort(cp.constantPoolSize());
        cp.writeConstantPool(dos);
        baos.writeTo(dos);
    }

    public boolean isPrimitive() {
        return false;
    }
}

