/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.Instruction;

class FieldInstruction
implements Instruction {
    private CodeField field;
    private byte opcode;

    FieldInstruction(byte op, CodeField f) {
        if (f == null) {
            throw new NullPointerException("CodeField can not be null");
        }
        this.opcode = op;
        this.field = f;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        ctx.writeShort(ctx.getConstants().resolveField(this.field));
    }
}

