/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

public class CodeUtils {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final CodeClass TYPE_VOID = IntrospectedCodeClass.forClass(Void.TYPE);
    public static final CodeClass TYPE_INT;
    public static final CodeClass TYPE_FLOAT;
    public static final CodeClass TYPE_DOUBLE;
    public static final CodeClass TYPE_LONG;
    public static final CodeClass TYPE_BYTE;
    public static final CodeClass TYPE_SHORT;
    public static final CodeClass TYPE_CHAR;
    public static final CodeClass TYPE_BOOLEAN;
    public static final CodeClass[] EMPTY_LIST;
    public static final CodeGenerator DO_NOTHING;

    public static String classListToString(CodeClass[] args) {
        StringBuffer sb = new StringBuffer();
        if (args.length > 0) {
            sb.append(args[0].getName());
        }
        int a = 1;
        while (a < args.length) {
            sb.append(", ");
            sb.append(args[a].getName());
            ++a;
        }
        return sb.toString();
    }

    static {
        TYPE_BYTE = IntrospectedCodeClass.forClass(Byte.TYPE);
        TYPE_INT = IntrospectedCodeClass.forClass(Integer.TYPE);
        TYPE_FLOAT = IntrospectedCodeClass.forClass(Float.TYPE);
        TYPE_DOUBLE = IntrospectedCodeClass.forClass(Double.TYPE);
        TYPE_LONG = IntrospectedCodeClass.forClass(Long.TYPE);
        TYPE_SHORT = IntrospectedCodeClass.forClass(Short.TYPE);
        TYPE_CHAR = IntrospectedCodeClass.forClass(Character.TYPE);
        TYPE_BOOLEAN = IntrospectedCodeClass.forClass(Boolean.TYPE);
        EMPTY_LIST = new CodeClass[0];
        DO_NOTHING = new CodeGenerator(){

            public void writeCode(CodeContext cxt) {
            }
        };
    }
}

