/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.ByteInstruction;
import org.biojava.utils.bytecode.ClassInstruction;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.DoubleInstruction;
import org.biojava.utils.bytecode.FieldInstruction;
import org.biojava.utils.bytecode.FloatConstantInstruction;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.IntConstantInstruction;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LabelInstruction;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.LocalVariableInstruction;
import org.biojava.utils.bytecode.LongConstantInstruction;
import org.biojava.utils.bytecode.MethodInstruction;
import org.biojava.utils.bytecode.NoOperandsInstruction;
import org.biojava.utils.bytecode.ShortInstruction;
import org.biojava.utils.bytecode.StringConstantInstruction;

public class ByteCode {
    public static final byte op_nop = 0;
    public static final byte op_aconst_null = 1;
    public static final byte op_iconst_m1 = 2;
    public static final byte op_iconst_0 = 3;
    public static final byte op_iconst_1 = 4;
    public static final byte op_iconst_2 = 5;
    public static final byte op_iconst_3 = 6;
    public static final byte op_iconst_4 = 7;
    public static final byte op_iconst_5 = 8;
    public static final byte op_lconst_0 = 9;
    public static final byte op_lconst_1 = 10;
    public static final byte op_fconst_0 = 11;
    public static final byte op_fconst_1 = 12;
    public static final byte op_fconst_2 = 13;
    public static final byte op_dconst_0 = 14;
    public static final byte op_dconst_1 = 15;
    public static final byte op_bipush = 16;
    public static final byte op_sipush = 17;
    public static final byte op_ldc = 18;
    public static final byte op_ldc_w = 19;
    public static final byte op_ldc2_w = 20;
    public static final byte op_iload = 21;
    public static final byte op_lload = 22;
    public static final byte op_fload = 23;
    public static final byte op_dload = 24;
    public static final byte op_aload = 25;
    public static final byte op_iload_0 = 26;
    public static final byte op_iload_1 = 27;
    public static final byte op_iload_2 = 28;
    public static final byte op_iload_3 = 29;
    public static final byte op_lload_0 = 30;
    public static final byte op_lload_1 = 31;
    public static final byte op_lload_2 = 32;
    public static final byte op_lload_3 = 33;
    public static final byte op_fload_0 = 34;
    public static final byte op_fload_1 = 35;
    public static final byte op_fload_2 = 36;
    public static final byte op_fload_3 = 37;
    public static final byte op_dload_0 = 38;
    public static final byte op_dload_1 = 39;
    public static final byte op_dload_2 = 40;
    public static final byte op_dload_3 = 41;
    public static final byte op_aload_0 = 42;
    public static final byte op_aload_1 = 43;
    public static final byte op_aload_2 = 44;
    public static final byte op_aload_3 = 45;
    public static final byte op_iaload = 46;
    public static final byte op_laload = 47;
    public static final byte op_faload = 48;
    public static final byte op_daload = 49;
    public static final byte op_aaload = 50;
    public static final byte op_baload = 51;
    public static final byte op_caload = 52;
    public static final byte op_saload = 53;
    public static final byte op_istore = 54;
    public static final byte op_lstore = 55;
    public static final byte op_fstore = 56;
    public static final byte op_dstore = 57;
    public static final byte op_astore = 58;
    public static final byte op_istore_0 = 59;
    public static final byte op_istore_1 = 60;
    public static final byte op_istore_2 = 61;
    public static final byte op_istore_3 = 62;
    public static final byte op_lstore_0 = 63;
    public static final byte op_lstore_1 = 64;
    public static final byte op_lstore_2 = 65;
    public static final byte op_lstore_3 = 66;
    public static final byte op_fstore_0 = 67;
    public static final byte op_fstore_1 = 68;
    public static final byte op_fstore_2 = 69;
    public static final byte op_fstore_3 = 70;
    public static final byte op_dstore_0 = 71;
    public static final byte op_dstore_1 = 72;
    public static final byte op_dstore_2 = 73;
    public static final byte op_dstore_3 = 74;
    public static final byte op_astore_0 = 75;
    public static final byte op_astore_1 = 76;
    public static final byte op_astore_2 = 77;
    public static final byte op_astore_3 = 78;
    public static final byte op_iastore = 79;
    public static final byte op_lastore = 80;
    public static final byte op_fastore = 81;
    public static final byte op_dastore = 82;
    public static final byte op_aastore = 83;
    public static final byte op_bastore = 84;
    public static final byte op_castore = 85;
    public static final byte op_sastore = 86;
    public static final byte op_pop = 87;
    public static final byte op_pop2 = 88;
    public static final byte op_dup = 89;
    public static final byte op_dup_x1 = 90;
    public static final byte op_dup_x2 = 91;
    public static final byte op_dup2 = 92;
    public static final byte op_dup2_x1 = 93;
    public static final byte op_dup2_x2 = 94;
    public static final byte op_swap = 95;
    public static final byte op_iadd = 96;
    public static final byte op_ladd = 97;
    public static final byte op_fadd = 98;
    public static final byte op_dadd = 99;
    public static final byte op_isub = 100;
    public static final byte op_lsub = 101;
    public static final byte op_fsub = 102;
    public static final byte op_dsub = 103;
    public static final byte op_imul = 104;
    public static final byte op_lmul = 105;
    public static final byte op_fmul = 106;
    public static final byte op_dmul = 107;
    public static final byte op_idiv = 108;
    public static final byte op_ldiv = 109;
    public static final byte op_fdiv = 110;
    public static final byte op_ddiv = 111;
    public static final byte op_irem = 112;
    public static final byte op_lrem = 113;
    public static final byte op_frem = 114;
    public static final byte op_drem = 115;
    public static final byte op_ineg = 116;
    public static final byte op_lneg = 117;
    public static final byte op_fneg = 118;
    public static final byte op_dneg = 119;
    public static final byte op_ishl = 120;
    public static final byte op_lshl = 121;
    public static final byte op_ishr = 122;
    public static final byte op_lshr = 123;
    public static final byte op_iushr = 124;
    public static final byte op_lushr = 125;
    public static final byte op_iand = 126;
    public static final byte op_land = 127;
    public static final byte op_ior = -128;
    public static final byte op_lor = -127;
    public static final byte op_ixor = -126;
    public static final byte op_lxor = -125;
    public static final byte op_iinc = -124;
    public static final byte op_i2l = -123;
    public static final byte op_i2f = -122;
    public static final byte op_i2d = -121;
    public static final byte op_l2i = -120;
    public static final byte op_l2f = -119;
    public static final byte op_l2d = -118;
    public static final byte op_f2i = -117;
    public static final byte op_f2l = -116;
    public static final byte op_f2d = -115;
    public static final byte op_d2i = -114;
    public static final byte op_d2l = -113;
    public static final byte op_d2f = -112;
    public static final byte op_i2b = -111;
    public static final byte op_i2c = -110;
    public static final byte op_i2s = -109;
    public static final byte op_lcmp = -108;
    public static final byte op_fcmpl = -107;
    public static final byte op_fcmpg = -106;
    public static final byte op_dcmpl = -105;
    public static final byte op_dcmpg = -104;
    public static final byte op_ifeq = -103;
    public static final byte op_ifne = -102;
    public static final byte op_iflt = -101;
    public static final byte op_ifge = -100;
    public static final byte op_ifgt = -99;
    public static final byte op_ifle = -98;
    public static final byte op_if_icmpeq = -97;
    public static final byte op_if_icmpne = -96;
    public static final byte op_if_icmplt = -95;
    public static final byte op_if_icmpge = -94;
    public static final byte op_if_icmpgt = -93;
    public static final byte op_if_icmple = -92;
    public static final byte op_if_acmpeq = -91;
    public static final byte op_if_acmpne = -90;
    public static final byte op_goto = -89;
    public static final byte op_jsr = -88;
    public static final byte op_ret = -87;
    public static final byte op_tableswitch = -86;
    public static final byte op_lookupswitch = -85;
    public static final byte op_ireturn = -84;
    public static final byte op_lreturn = -83;
    public static final byte op_freturn = -82;
    public static final byte op_dreturn = -81;
    public static final byte op_areturn = -80;
    public static final byte op_return = -79;
    public static final byte op_getstatic = -78;
    public static final byte op_putstatic = -77;
    public static final byte op_getfield = -76;
    public static final byte op_putfield = -75;
    public static final byte op_invokevirtual = -74;
    public static final byte op_invokespecial = -73;
    public static final byte op_invokestatic = -72;
    public static final byte op_invokeinterface = -71;
    public static final byte op_new = -69;
    public static final byte op_newarray = -68;
    public static final byte op_anewarray = -67;
    public static final byte op_arraylength = -66;
    public static final byte op_athrow = -65;
    public static final byte op_checkcast = -64;
    public static final byte op_instanceof = -63;
    public static final byte op_monitorenter = -62;
    public static final byte op_monitorexit = -61;
    public static final byte op_wide = -60;
    public static final byte op_multianewarray = -59;
    public static final byte op_ifnull = -58;
    public static final byte op_ifnonnull = -57;
    public static final byte op_goto_w = -56;
    public static final byte op_jsr_w = -55;
    public static final byte op_breakpoint = -54;
    public static final byte op_ldc_quick = -53;
    public static final byte op_ldc_w_quick = -52;
    public static final byte op_ldc2_w_quick = -51;
    public static final byte op_getfield_quick = -50;
    public static final byte op_putfield_quick = -49;
    public static final byte op_getfield2_quick = -48;
    public static final byte op_putfield2_quick = -47;
    public static final byte op_getstatic_quick = -46;
    public static final byte op_putstatic_quick = -45;
    public static final byte op_getstatic2_quick = -44;
    public static final byte op_putstatic2_quick = -43;
    public static final byte op_invokevirtual_quick = -42;
    public static final byte op_invokenonvirtual_quick = -41;
    public static final byte op_invokesuper_quick = -40;
    public static final byte op_invokestatic_quick = -39;
    public static final byte op_invokeinterface_quick = -38;
    public static final byte op_invokevirtualobject_quick = -37;
    public static final byte op_new_quick = -35;
    public static final byte op_anewarray_quick = -34;
    public static final byte op_multianewarray_quick = -33;
    public static final byte op_checkcast_quick = -32;
    public static final byte op_instanceof_quick = -31;
    public static final byte op_invokevirtual_quick_w = -30;
    public static final byte op_getfield_quick_w = -29;
    public static final byte op_putfield_quick_w = -28;
    public static final byte op_impdep1 = -2;
    public static final byte op_impdep2 = -1;

    public static Instruction make_iconst(int i) {
        if (i >= -1 && i <= 5) {
            return NoOperandsInstruction.get((byte)(3 + i));
        }
        if (i >= -128 && i <= 127) {
            return new ByteInstruction(16, (byte)i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new ShortInstruction(17, i);
        }
        return new IntConstantInstruction(i);
    }

    public static Instruction make_sconst(String s) {
        return new StringConstantInstruction(s);
    }

    public static Instruction make_dconst(double d) {
        if (d == 0.0) {
            return NoOperandsInstruction.get((byte)14);
        }
        if (d == 1.0) {
            return NoOperandsInstruction.get((byte)15);
        }
        return new DoubleInstruction(d);
    }

    public static Instruction make_lconst(long l) {
        if (l == 0L) {
            return NoOperandsInstruction.get((byte)9);
        }
        if (l == 1L) {
            return NoOperandsInstruction.get((byte)10);
        }
        return new LongConstantInstruction(l);
    }

    public static Instruction make_fconst(float f) {
        if (f == 0.0f) {
            return NoOperandsInstruction.get((byte)11);
        }
        if (f == 1.0f) {
            return NoOperandsInstruction.get((byte)12);
        }
        if (f == 2.0f) {
            return NoOperandsInstruction.get((byte)13);
        }
        return new FloatConstantInstruction(f);
    }

    public static Instruction make_invokevirtual(CodeMethod cm) {
        return new MethodInstruction(-74, cm);
    }

    public static Instruction make_invokespecial(CodeMethod cm) {
        return new MethodInstruction(-73, cm);
    }

    public static Instruction make_invokestatic(CodeMethod cm) {
        return new MethodInstruction(-72, cm);
    }

    public static Instruction make_invokeinterface(CodeMethod cm) {
        return new MethodInstruction(-71, cm);
    }

    public static Instruction make_getfield(CodeField cf) {
        return new FieldInstruction(-76, cf);
    }

    public static Instruction make_putfield(CodeField cf) {
        return new FieldInstruction(-75, cf);
    }

    public static Instruction make_getstatic(CodeField cf) {
        return new FieldInstruction(-78, cf);
    }

    public static Instruction make_putstatic(CodeField cf) {
        return new FieldInstruction(-77, cf);
    }

    public static Instruction make_iload(LocalVariable lv) throws CodeException {
        CodeClass cc = lv.getType();
        if (cc != CodeUtils.TYPE_INT && cc != CodeUtils.TYPE_SHORT && cc != CodeUtils.TYPE_CHAR && cc != CodeUtils.TYPE_BYTE && cc != CodeUtils.TYPE_BOOLEAN) {
            throw new CodeException(cc.getName() + " is not a VM `i' type");
        }
        return new LocalVariableInstruction(21, 26, lv);
    }

    public static Instruction make_lload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_LONG) {
            throw new CodeException(lv.getType().getName() + " is not a long");
        }
        return new LocalVariableInstruction(22, 30, lv);
    }

    public static Instruction make_fload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_FLOAT) {
            throw new CodeException(lv.getType().getName() + " is not a float");
        }
        return new LocalVariableInstruction(23, 34, lv);
    }

    public static Instruction make_dload(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_DOUBLE) {
            throw new CodeException(lv.getType().getName() + " is not a double");
        }
        return new LocalVariableInstruction(24, 38, lv);
    }

    public static Instruction make_aload(LocalVariable lv) throws CodeException {
        if (lv.getType().isPrimitive()) {
            throw new CodeException(lv.getType().getName() + " is a primitive type");
        }
        return new LocalVariableInstruction(25, 42, lv);
    }

    public static Instruction make_istore(LocalVariable lv) throws CodeException {
        CodeClass cc = lv.getType();
        if (cc != CodeUtils.TYPE_INT && cc != CodeUtils.TYPE_SHORT && cc != CodeUtils.TYPE_CHAR && cc != CodeUtils.TYPE_BYTE && cc != CodeUtils.TYPE_BOOLEAN) {
            throw new CodeException(cc.getName() + " is not a VM `i' type");
        }
        return new LocalVariableInstruction(54, 59, lv);
    }

    public static Instruction make_lstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_LONG) {
            throw new CodeException(lv.getType().getName() + " is not a long");
        }
        return new LocalVariableInstruction(55, 63, lv);
    }

    public static Instruction make_fstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_FLOAT) {
            throw new CodeException(lv.getType().getName() + " is not a float");
        }
        return new LocalVariableInstruction(56, 67, lv);
    }

    public static Instruction make_dstore(LocalVariable lv) throws CodeException {
        if (lv.getType() != CodeUtils.TYPE_DOUBLE) {
            throw new CodeException(lv.getType().getName() + " is not a double");
        }
        return new LocalVariableInstruction(57, 71, lv);
    }

    public static Instruction make_astore(LocalVariable lv) throws CodeException {
        if (lv.getType().isPrimitive()) {
            throw new CodeException(lv.getType().getName() + " is a primitive type");
        }
        return new LocalVariableInstruction(58, 75, lv);
    }

    public static Instruction make_ifeq(Label l) {
        return new LabelInstruction(-103, l);
    }

    public static Instruction make_ifne(Label l) {
        return new LabelInstruction(-102, l);
    }

    public static Instruction make_iflt(Label l) {
        return new LabelInstruction(-101, l);
    }

    public static Instruction make_ifge(Label l) {
        return new LabelInstruction(-100, l);
    }

    public static Instruction make_ifgt(Label l) {
        return new LabelInstruction(-99, l);
    }

    public static Instruction make_ifle(Label l) {
        return new LabelInstruction(-98, l);
    }

    public static Instruction make_if_icmpeq(Label l) {
        return new LabelInstruction(-97, l);
    }

    public static Instruction make_if_icmpne(Label l) {
        return new LabelInstruction(-96, l);
    }

    public static Instruction make_if_icmplt(Label l) {
        return new LabelInstruction(-95, l);
    }

    public static Instruction make_if_icmpge(Label l) {
        return new LabelInstruction(-94, l);
    }

    public static Instruction make_if_icmpgt(Label l) {
        return new LabelInstruction(-93, l);
    }

    public static Instruction make_if_icmple(Label l) {
        return new LabelInstruction(-92, l);
    }

    public static Instruction make_if_acmpeq(Label l) {
        return new LabelInstruction(-91, l);
    }

    public static Instruction make_if_acmpne(Label l) {
        return new LabelInstruction(-90, l);
    }

    public static Instruction make_ifnull(Label l) {
        return new LabelInstruction(-58, l);
    }

    public static Instruction make_ifnonnull(Label l) {
        return new LabelInstruction(-57, l);
    }

    public static Instruction make_goto(Label l) {
        return new LabelInstruction(-89, l);
    }

    public static Instruction make_jsr(Label l) {
        return new LabelInstruction(-88, l);
    }

    public static Instruction make_nop() {
        return NoOperandsInstruction.get((byte)0);
    }

    public static Instruction make_aconst_null() {
        return NoOperandsInstruction.get((byte)1);
    }

    public static Instruction make_iaload() {
        return NoOperandsInstruction.get((byte)46);
    }

    public static Instruction make_laload() {
        return NoOperandsInstruction.get((byte)47);
    }

    public static Instruction make_faload() {
        return NoOperandsInstruction.get((byte)48);
    }

    public static Instruction make_daload() {
        return NoOperandsInstruction.get((byte)49);
    }

    public static Instruction make_aaload() {
        return NoOperandsInstruction.get((byte)50);
    }

    public static Instruction make_baload() {
        return NoOperandsInstruction.get((byte)51);
    }

    public static Instruction make_caload() {
        return NoOperandsInstruction.get((byte)52);
    }

    public static Instruction make_saload() {
        return NoOperandsInstruction.get((byte)53);
    }

    public static Instruction make_iastore() {
        return NoOperandsInstruction.get((byte)79);
    }

    public static Instruction make_lastore() {
        return NoOperandsInstruction.get((byte)80);
    }

    public static Instruction make_fastore() {
        return NoOperandsInstruction.get((byte)81);
    }

    public static Instruction make_dastore() {
        return NoOperandsInstruction.get((byte)82);
    }

    public static Instruction make_aastore() {
        return NoOperandsInstruction.get((byte)83);
    }

    public static Instruction make_bastore() {
        return NoOperandsInstruction.get((byte)84);
    }

    public static Instruction make_castore() {
        return NoOperandsInstruction.get((byte)85);
    }

    public static Instruction make_sastore() {
        return NoOperandsInstruction.get((byte)86);
    }

    public static Instruction make_pop() {
        return NoOperandsInstruction.get((byte)87);
    }

    public static Instruction make_pop2() {
        return NoOperandsInstruction.get((byte)88);
    }

    public static Instruction make_dup() {
        return NoOperandsInstruction.get((byte)89);
    }

    public static Instruction make_dup_x1() {
        return NoOperandsInstruction.get((byte)90);
    }

    public static Instruction make_dup_x2() {
        return NoOperandsInstruction.get((byte)91);
    }

    public static Instruction make_dup2() {
        return NoOperandsInstruction.get((byte)92);
    }

    public static Instruction make_dup2_x1() {
        return NoOperandsInstruction.get((byte)93);
    }

    public static Instruction make_dup2_x2() {
        return NoOperandsInstruction.get((byte)94);
    }

    public static Instruction make_swap() {
        return NoOperandsInstruction.get((byte)95);
    }

    public static Instruction make_iadd() {
        return NoOperandsInstruction.get((byte)96);
    }

    public static Instruction make_ladd() {
        return NoOperandsInstruction.get((byte)97);
    }

    public static Instruction make_fadd() {
        return NoOperandsInstruction.get((byte)98);
    }

    public static Instruction make_dadd() {
        return NoOperandsInstruction.get((byte)99);
    }

    public static Instruction make_isub() {
        return NoOperandsInstruction.get((byte)100);
    }

    public static Instruction make_lsub() {
        return NoOperandsInstruction.get((byte)101);
    }

    public static Instruction make_fsub() {
        return NoOperandsInstruction.get((byte)102);
    }

    public static Instruction make_dsub() {
        return NoOperandsInstruction.get((byte)103);
    }

    public static Instruction make_imul() {
        return NoOperandsInstruction.get((byte)104);
    }

    public static Instruction make_lmul() {
        return NoOperandsInstruction.get((byte)105);
    }

    public static Instruction make_fmul() {
        return NoOperandsInstruction.get((byte)106);
    }

    public static Instruction make_dmul() {
        return NoOperandsInstruction.get((byte)107);
    }

    public static Instruction make_idiv() {
        return NoOperandsInstruction.get((byte)108);
    }

    public static Instruction make_ldiv() {
        return NoOperandsInstruction.get((byte)109);
    }

    public static Instruction make_fdiv() {
        return NoOperandsInstruction.get((byte)110);
    }

    public static Instruction make_ddiv() {
        return NoOperandsInstruction.get((byte)111);
    }

    public static Instruction make_irem() {
        return NoOperandsInstruction.get((byte)112);
    }

    public static Instruction make_lrem() {
        return NoOperandsInstruction.get((byte)113);
    }

    public static Instruction make_frem() {
        return NoOperandsInstruction.get((byte)114);
    }

    public static Instruction make_drem() {
        return NoOperandsInstruction.get((byte)115);
    }

    public static Instruction make_ineg() {
        return NoOperandsInstruction.get((byte)116);
    }

    public static Instruction make_lneg() {
        return NoOperandsInstruction.get((byte)117);
    }

    public static Instruction make_fneg() {
        return NoOperandsInstruction.get((byte)118);
    }

    public static Instruction make_dneg() {
        return NoOperandsInstruction.get((byte)119);
    }

    public static Instruction make_ishl() {
        return NoOperandsInstruction.get((byte)120);
    }

    public static Instruction make_lshl() {
        return NoOperandsInstruction.get((byte)121);
    }

    public static Instruction make_ishr() {
        return NoOperandsInstruction.get((byte)122);
    }

    public static Instruction make_lshr() {
        return NoOperandsInstruction.get((byte)123);
    }

    public static Instruction make_iushr() {
        return NoOperandsInstruction.get((byte)124);
    }

    public static Instruction make_lushr() {
        return NoOperandsInstruction.get((byte)125);
    }

    public static Instruction make_iand() {
        return NoOperandsInstruction.get((byte)126);
    }

    public static Instruction make_land() {
        return NoOperandsInstruction.get((byte)127);
    }

    public static Instruction make_ior() {
        return NoOperandsInstruction.get((byte)-128);
    }

    public static Instruction make_lor() {
        return NoOperandsInstruction.get((byte)-127);
    }

    public static Instruction make_ixor() {
        return NoOperandsInstruction.get((byte)-126);
    }

    public static Instruction make_lxor() {
        return NoOperandsInstruction.get((byte)-125);
    }

    public static Instruction make_i2l() {
        return NoOperandsInstruction.get((byte)-123);
    }

    public static Instruction make_i2f() {
        return NoOperandsInstruction.get((byte)-122);
    }

    public static Instruction make_i2d() {
        return NoOperandsInstruction.get((byte)-121);
    }

    public static Instruction make_l2i() {
        return NoOperandsInstruction.get((byte)-120);
    }

    public static Instruction make_l2f() {
        return NoOperandsInstruction.get((byte)-119);
    }

    public static Instruction make_l2d() {
        return NoOperandsInstruction.get((byte)-118);
    }

    public static Instruction make_f2i() {
        return NoOperandsInstruction.get((byte)-117);
    }

    public static Instruction make_f2l() {
        return NoOperandsInstruction.get((byte)-116);
    }

    public static Instruction make_f2d() {
        return NoOperandsInstruction.get((byte)-115);
    }

    public static Instruction make_d2i() {
        return NoOperandsInstruction.get((byte)-114);
    }

    public static Instruction make_d2l() {
        return NoOperandsInstruction.get((byte)-113);
    }

    public static Instruction make_d2f() {
        return NoOperandsInstruction.get((byte)-112);
    }

    public static Instruction make_i2b() {
        return NoOperandsInstruction.get((byte)-111);
    }

    public static Instruction make_i2c() {
        return NoOperandsInstruction.get((byte)-110);
    }

    public static Instruction make_i2s() {
        return NoOperandsInstruction.get((byte)-109);
    }

    public static Instruction make_lcmp() {
        return NoOperandsInstruction.get((byte)-108);
    }

    public static Instruction make_fcmpl() {
        return NoOperandsInstruction.get((byte)-107);
    }

    public static Instruction make_fcmpg() {
        return NoOperandsInstruction.get((byte)-106);
    }

    public static Instruction make_dcmpl() {
        return NoOperandsInstruction.get((byte)-105);
    }

    public static Instruction make_dcmpg() {
        return NoOperandsInstruction.get((byte)-104);
    }

    public static Instruction make_ireturn() {
        return NoOperandsInstruction.get((byte)-84);
    }

    public static Instruction make_lreturn() {
        return NoOperandsInstruction.get((byte)-83);
    }

    public static Instruction make_freturn() {
        return NoOperandsInstruction.get((byte)-82);
    }

    public static Instruction make_dreturn() {
        return NoOperandsInstruction.get((byte)-81);
    }

    public static Instruction make_areturn() {
        return NoOperandsInstruction.get((byte)-80);
    }

    public static Instruction make_return() {
        return NoOperandsInstruction.get((byte)-79);
    }

    public static Instruction make_arraylength() {
        return NoOperandsInstruction.get((byte)-66);
    }

    public static Instruction make_athrow() {
        return NoOperandsInstruction.get((byte)-65);
    }

    public static Instruction make_monitorenter() {
        return NoOperandsInstruction.get((byte)-62);
    }

    public static Instruction make_monitorexit() {
        return NoOperandsInstruction.get((byte)-61);
    }

    public static Instruction make_wide() {
        return NoOperandsInstruction.get((byte)-60);
    }

    public static Instruction make_breakpoint() {
        return NoOperandsInstruction.get((byte)-54);
    }

    public static Instruction make_invokevirtual_quick_w() {
        return NoOperandsInstruction.get((byte)-30);
    }

    public static Instruction make_impdep1() {
        return NoOperandsInstruction.get((byte)-2);
    }

    public static Instruction make_impdep2() {
        return NoOperandsInstruction.get((byte)-1);
    }

    public static Instruction make_new(CodeClass clazz) {
        return new ClassInstruction(-69, clazz);
    }

    public static Instruction make_newarray(CodeClass clazz) throws CodeException {
        if (clazz.isPrimitive()) {
            int type = -1;
            if (clazz == CodeUtils.TYPE_BOOLEAN) {
                type = 4;
            } else if (clazz == CodeUtils.TYPE_CHAR) {
                type = 5;
            } else if (clazz == CodeUtils.TYPE_FLOAT) {
                type = 6;
            } else if (clazz == CodeUtils.TYPE_DOUBLE) {
                type = 7;
            } else if (clazz == CodeUtils.TYPE_BYTE) {
                type = 8;
            } else if (clazz == CodeUtils.TYPE_SHORT) {
                type = 9;
            } else if (clazz == CodeUtils.TYPE_INT) {
                type = 10;
            } else if (clazz == CodeUtils.TYPE_LONG) {
                type = 11;
            }
            if (type < 0) {
                throw new CodeException("Invalid type " + clazz.getName());
            }
            return new ByteInstruction(-68, (byte)type);
        }
        return new ClassInstruction(-67, clazz);
    }

    public static Instruction make_return(CodeMethod method) {
        return ByteCode.make_return(method.getReturnType());
    }

    public static Instruction make_return(CodeClass clazz) {
        if (CodeUtils.TYPE_VOID.equals(clazz)) {
            return ByteCode.make_return();
        }
        if (CodeUtils.TYPE_BYTE.equals(clazz) || CodeUtils.TYPE_SHORT.equals(clazz) || CodeUtils.TYPE_CHAR.equals(clazz) || CodeUtils.TYPE_BOOLEAN.equals(clazz) || CodeUtils.TYPE_INT.equals(clazz)) {
            return ByteCode.make_ireturn();
        }
        if (CodeUtils.TYPE_LONG.equals(clazz)) {
            return ByteCode.make_lreturn();
        }
        if (CodeUtils.TYPE_FLOAT.equals(clazz)) {
            return ByteCode.make_freturn();
        }
        if (CodeUtils.TYPE_DOUBLE.equals(clazz)) {
            return ByteCode.make_dreturn();
        }
        return ByteCode.make_areturn();
    }
}

