package baseCode.gui.file;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import baseCode.util.FileTools;

/**
 * <hr>
 * <p>
 * Copyright (c) 2004 Columbia University
 * 
 * @author Will Braynen
 * @version $Id: DataFileFilter.java,v 1.3 2004/07/27 03:18:58 pavlidis Exp $
 */
public class DataFileFilter extends FileFilter {

   public boolean accept( File f ) {

      if ( f.isDirectory() ) {
         return true;
      }

      return FileTools.hasDataExtension( f.getName() );

   } // end accept

   public String getDescription() {

      return "TXT data files";
   }
}