package baseCode.util;

/**
 * Intended use is to display 'status' information or other messages to users in a non-disruptive fashion (though the
 * actual use is up to the implementer). Copyright (c) 2004 Columbia University
 * 
 * @author Paul Pavlidis
 * @version $Id: StatusViewer.java,v 1.3 2004/07/27 03:18:58 pavlidis Exp $
 */
public interface StatusViewer {

   /**
    * Print the status to the location appropriate for this application.
    * 
    * @param s
    */
   public abstract void setStatus( String s );

   /**
    * Print an error status messge.
    * 
    * @param s
    */
   public abstract void setError( String s );

   /**
    * Clear the status dislay. Implementers that do not write to GUI elements probably don't need to do anything.
    */
   public abstract void clear();
}