/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails;

import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.util.Assert;

public class User
implements UserDetails {
    private String password;
    private String username;
    private GrantedAuthority[] authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;

    protected User() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public User(String username, String password, boolean enabled, GrantedAuthority[] authorities) throws IllegalArgumentException {
        this(username, password, enabled, true, true, authorities);
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, GrantedAuthority[] authorities) throws IllegalArgumentException {
        this(username, password, enabled, accountNonExpired, credentialsNonExpired, true, authorities);
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.setAuthorities(authorities);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof User) || rhs == null) {
            return false;
        }
        User user = (User)rhs;
        if (user.getAuthorities().length != this.getAuthorities().length) {
            return false;
        }
        for (int i = 0; i < this.getAuthorities().length; ++i) {
            if (this.getAuthorities()[i].equals(user.getAuthorities()[i])) continue;
            return false;
        }
        return this.getPassword().equals(user.getPassword()) && this.getUsername().equals(user.getUsername()) && this.isAccountNonExpired() == user.isAccountNonExpired() && this.isAccountNonLocked() == user.isAccountNonLocked() && this.isCredentialsNonExpired() == user.isCredentialsNonExpired() && this.isEnabled() == user.isEnabled();
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setAuthorities(GrantedAuthority[] authorities) {
        Assert.notNull((Object)authorities, (String)"Cannot pass a null GrantedAuthority array");
        for (int i = 0; i < authorities.length; ++i) {
            Assert.notNull((Object)authorities[i], (String)("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
        }
        this.authorities = authorities;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + ": ");
        sb.append("Username: " + this.username + "; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: " + this.enabled + "; ");
        sb.append("AccountNonExpired: " + this.accountNonExpired + "; ");
        sb.append("credentialsNonExpired: " + this.credentialsNonExpired + "; ");
        sb.append("AccountNonLocked: " + this.accountNonLocked + "; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

